""" The entry point for an Envisage application. """


# Standard library imports.
import sys

# Enthought library imports.
from enthought.envisage import Application
from enthought.pyface.api import ImageResource, SplashScreen 

# Local imports.
from plugin_definitions import PLUGIN_DEFINITIONS


# Application entry point.
if __name__ == '__main__':

    # Create an Envisage application.
    application = Application(
        argv               = sys.argv,
        id                 = "enthought.envisage.example.simple_ui",
        plugin_definitions = PLUGIN_DEFINITIONS,
        splash_screen      = SplashScreen(image=ImageResource('splash'))
    )

    # Start it!
    application.start()

#### EOF ######################################################################
