""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run.py'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""


# Enthought library imports.
from enthought.envisage.api import join

# We use this package to find the absolute location of the plugin definition
# files.
import enthought


# The plugin definitions used in the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    join(enthought, 'envisage/core/core_plugin_definition.py'),
    join(enthought, 'envisage/resource/resource_plugin_definition.py'),
    join(enthought, 'envisage/workbench/workbench_plugin_definition.py'),
    join(enthought, 'envisage/action/action_plugin_definition.py'),
    join(enthought, 'envisage/workbench/action/action_plugin_definition.py'),

    # Enthought plugins.
    join(enthought, 'plugins/python_shell/python_shell_plugin_definition.py'),
    join(enthought, 'plugins/text_editor/text_editor_plugin_definition.py'),

    # Application plugins.
    join(enthought, 'envisage/examples/plugin/acme/plugin_definition.py')
]

#### EOF ######################################################################
