""" Abstract base class for all workbench actions. """


# Enthought library imports.
from enthought.envisage.api import Application
from enthought.envisage.resource.api import ResourceManager
from enthought.envisage.workbench.api import Window
from enthought.pyface.action.api import Action
from enthought.traits.api import Instance, Property


class WorkbenchAction(Action):
    """ Abstract base class for all workbench actions. """

    #### 'WorkbenchAction' interface ##########################################

    # The application that the action is part of. This is a convenience
    # property and is equivalent to 'self.window.application'.
    application = Property(Instance(Application))
    
    # The resource manager. This is a convenience property and is equivalent to
    # 'self.window.resource_manager'.
    resource_manager = Property(Instance(ResourceManager))

    # The workbench window that the action is in.
    #
    # This is set by the framework.
    window = Instance(Window)

    ###########################################################################
    # 'WorkbenchAction' interface.
    ###########################################################################

    #### Properties ###########################################################

    def _get_application(self):
        """ Property getter. """

        return self.window.application

    def _get_resource_manager(self):
        """ Property getter. """

        return self.window.resource_manager

#### EOF ######################################################################
