""" The resource type for projects. """


# Enthought library imports.
from enthought.envisage.resource import FolderResourceType
from enthought.traits.api import Instance

# Local imports.
from project import Project
from project_node_type import ProjectNodeType


class ProjectResourceType(FolderResourceType):
    """ The resource type for projects. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Instance(Project)

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return ProjectNodeType(resource_type=self)

#### EOF ######################################################################
