#!/usr/bin/ruby -w
# filter converting from .depend to .dot
# tested on .depend generated by ocamldep
# $Id: dep2dot.rb 7922 2007-11-25 13:12:25Z tassi $

require 'set'

edges = Set.new
$stdin.each {|line|
  target, deps = line.split(/\s*:\s*/)
  while deps =~ /\\\s*$/  # deal with lines continued with trailing \
    deps.sub!(/\s*\\\s*$/, '')
    line = $stdin.readline
    deps += ' ' + line.lstrip
  end
  sources, targets = target.split, deps.split
  for src in sources
    for tgt in targets	# ignore file extensions
      src.sub!(/\.[^.]+/, '')
      tgt.sub!(/\.[^.]+/, '')
      edges << [src, tgt] unless src == tgt   # ignore self deps
    end
  end
}
puts 'digraph G {'
for src, tgt in edges
  print "\"#{src}\" -> \"#{tgt}\";\n"
end
puts '}'

