(* Copyright (C) 2002, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://cs.unibo.it/helm/.
 *)

(* $Id: variousTactics.ml 7922 2007-11-25 13:12:25Z tassi $ *)


(* TODO se ce n'e' piu' di una, prende la prima che trova... sarebbe meglio
chiedere: find dovrebbe restituire una lista di hyp (?) da passare all'utonto con una
funzione di callback che restituisce la (sola) hyp da applicare *)

let assumption_tac =
 let module PET = ProofEngineTypes in
 let assumption_tac status =
  let (proof, goal) = status in
  let module C = Cic in
  let module R = CicReduction in
  let module S = CicSubstitution in
  let module PT = PrimitiveTactics in
  let _,metasenv,_subst,_,_, _ = proof in
  let _,context,ty = CicUtil.lookup_meta goal metasenv in
  let rec find n = function 
      hd::tl -> 
        (match hd with
             (Some (_, C.Decl t)) when
               fst (R.are_convertible context (S.lift n t) ty 
		       CicUniv.empty_ugraph) -> n
           | (Some (_, C.Def (_,Some ty'))) when
               fst (R.are_convertible context (S.lift n ty') ty
                       CicUniv.empty_ugraph) -> n
           | (Some (_, C.Def (t,None))) ->
	       let ty_t, u = (* TASSI: FIXME *)
		 CicTypeChecker.type_of_aux' metasenv context (S.lift n t) 
		   CicUniv.empty_ugraph in
	       let b,_ = R.are_convertible context ty_t ty u in
		 if b then n else find (n+1) tl
           | _ -> find (n+1) tl
         )
      | [] -> raise (PET.Fail (lazy "Assumption: No such assumption"))
     in PET.apply_tactic (PT.apply_tac ~term:(C.Rel (find 1 context))) status
 in
  PET.mk_tactic assumption_tac
;;

(* ANCORA DA DEBUGGARE *)

exception UnableToDetectTheTermThatMustBeGeneralizedYouMustGiveItExplicitly;;
exception TheSelectedTermsMustLiveInTheGoalContext
exception AllSelectedTermsMustBeConvertible;;
exception GeneralizationInHypothesesNotImplementedYet;;

let generalize_tac 
 ?(mk_fresh_name_callback = FreshNamesGenerator.mk_fresh_name ~subst:[])
 pattern
 =
  let module PET = ProofEngineTypes in
  let generalize_tac mk_fresh_name_callback
       ~pattern:(term,hyps_pat,concl_pat) status
  =
   if hyps_pat <> [] then raise GeneralizationInHypothesesNotImplementedYet;
   let (proof, goal) = status in
   let module C = Cic in
   let module P = PrimitiveTactics in
   let module T = Tacticals in
    let uri,metasenv,_subst,pbo,pty, attrs = proof in
    let (_,context,ty) as conjecture = CicUtil.lookup_meta goal metasenv in
    let subst,metasenv,u,selected_hyps,terms_with_context =
     ProofEngineHelpers.select ~metasenv ~ugraph:CicUniv.empty_ugraph
      ~conjecture ~pattern in
    let context = CicMetaSubst.apply_subst_context subst context in
    let metasenv = CicMetaSubst.apply_subst_metasenv subst metasenv in
    let pbo = CicMetaSubst.apply_subst subst pbo in
    let pty = CicMetaSubst.apply_subst subst pty in
    let term =
     match term with
        None -> None
      | Some term ->
          Some (fun context metasenv ugraph -> 
                  let term, metasenv, ugraph = term context metasenv ugraph in
                   CicMetaSubst.apply_subst subst term,
                    CicMetaSubst.apply_subst_metasenv subst metasenv,
                    ugraph)
    in
    let u,typ,term, metasenv' =
     let context_of_t, (t, metasenv, u) =
      match terms_with_context, term with
         [], None ->
          raise
           UnableToDetectTheTermThatMustBeGeneralizedYouMustGiveItExplicitly
       | [], Some t -> context, t context metasenv u
       | (context_of_t, _)::_, Some t -> 
           context_of_t, t context_of_t metasenv u
       | (context_of_t, t)::_, None -> context_of_t, (t, metasenv, u)
     in
      let t,subst,metasenv' =
       try
        CicMetaSubst.delift_rels [] metasenv
         (List.length context_of_t - List.length context) t
       with
        CicMetaSubst.DeliftingARelWouldCaptureAFreeVariable ->
         raise TheSelectedTermsMustLiveInTheGoalContext
      in
       (*CSC: I am not sure about the following two assertions;
         maybe I need to propagate the new subst and metasenv *)
       assert (subst = []);
       assert (metasenv' = metasenv);
       let typ,u = CicTypeChecker.type_of_aux' ~subst metasenv context t u in
        u,typ,t,metasenv
    in
    (* We need to check:
        1. whether they live in the context of the goal;
           if they do they are also well-typed since they are closed subterms
           of a well-typed term in the well-typed context of the well-typed
           term
        2. whether they are convertible
    *)
    ignore (
     List.fold_left
      (fun u (context_of_t,t) ->
        (* 1 *)
        let t,subst,metasenv'' =
         try
          CicMetaSubst.delift_rels [] metasenv'
           (List.length context_of_t - List.length context) t
         with
          CicMetaSubst.DeliftingARelWouldCaptureAFreeVariable ->
           raise TheSelectedTermsMustLiveInTheGoalContext in
        (*CSC: I am not sure about the following two assertions;
          maybe I need to propagate the new subst and metasenv *)
        assert (subst = []);
        assert (metasenv'' = metasenv');
        (* 2 *)
        let b,u1 = CicReduction.are_convertible ~subst context term t u in 
         if not b then 
          raise AllSelectedTermsMustBeConvertible
         else
          u1
      ) u terms_with_context) ;
    let status = (uri,metasenv',_subst,pbo,pty, attrs),goal in
    let proof,goals =
     PET.apply_tactic 
      (T.thens 
        ~start:
          (P.cut_tac 
           (C.Prod(
             (mk_fresh_name_callback metasenv context C.Anonymous ~typ:typ), 
             typ,
             (ProofEngineReduction.replace_lifting_csc 1
               ~equality:(==) 
               ~what:(List.map snd terms_with_context)
               ~with_what:(List.map (function _ -> C.Rel 1) terms_with_context)
               ~where:ty)
           )))
        ~continuations:
          [(P.apply_tac ~term:(C.Appl [C.Rel 1; CicSubstitution.lift 1 term])) ;
            T.id_tac])
        status
    in
     let _,metasenv'',_subst,_,_, _ = proof in
      (* CSC: the following is just a bad approximation since a meta
         can be closed and then re-opened! *)
      (proof,
        goals @
         (List.filter
           (fun j -> List.exists (fun (i,_,_) -> i = j) metasenv'')
           (ProofEngineHelpers.compare_metasenvs ~oldmetasenv:metasenv
             ~newmetasenv:metasenv')))
 in
  PET.mk_tactic (generalize_tac mk_fresh_name_callback ~pattern)
;;
