/***************************************************************************
 *   Copyright (C) 2004-2005 by Andreas Ramm                                    *
 *   psychobrain@gmx.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mateedit.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("MateEdit is an easy-to-use network-enabled multiuser editor \nwhich allows real-time collaboration on documents");

static const char version[] = "0.2";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about(I18N_NOOP("mateedit"), I18N_NOOP("MateEdit"), version, description,
                     KAboutData::License_GPL, I18N_NOOP("(C) 2004-2005 Andreas Ramm"), 0, I18N_NOOP("http://sourceforge.net/projects/mateedit/"), I18N_NOOP("psychobrain@gmx.net") );
    about.addAuthor( I18N_NOOP("Andreas Ramm"), 0, I18N_NOOP("psychobrain@gmx.net") );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    MateEditMainWindow *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(MateEditMainWindow);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here

        mainWin = new MateEditMainWindow();
        app.setMainWidget( mainWin );
        mainWin->show();

        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    app.connect(&app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()));
    return app.exec();
}

