#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2003, Matthias A. Benkard.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import gettext
import locale
import logging
import optparse
import os
import sys

path = { }

pref = {
	"maxima_exe": "maxima", # Full pathname if not in $PATH.
	"toolkit": None
}

_locale = None

toolkit = None

locale_set = False

def _(txt):
	return _locale.gettext(txt)

def init_os():
	if sys.platform == 'win32':
		os.environ['PATH'] += ';GTK/lib;GTK/bin'

def init_cmdline():
	global toolkit
	log = logging.getLogger("init")
	
	parser = optparse.OptionParser(usage = "%prog [options]",
			version = "Brummulk Mascyma 0.0.1")
	
	parser.add_option("-m", "--maxima",
			help = _("the Maxima executable to use [%s]") % pref["maxima_exe"],
			dest = "maxima_exe", metavar = _("<PATH>"),
			default = pref["maxima_exe"])
	
	a = toolkit
	if pref["toolkit"]:
		a = pref["toolkit"]
	parser.add_option("-t", "--toolkit",
			help = _("the GUI toolkit to use [%s];\n"
					"possible values: gtk, wx") % a,
			dest = "toolkit", metavar = _("<TOOLKIT>"),
			default = pref["toolkit"])
	del a
	
	options, args = parser.parse_args()
	pref["maxima_exe"] = options.maxima_exe
	
	if options.toolkit:
		if options.toolkit == 'wx' or options.toolkit == 'gtk':
			pref["toolkit"] = options.toolkit
			toolkit = options.toolkit
		else:
			log.warn(_("Invalid toolkit \"%s\" selected.") % options.toolkit)
	log.info(_("Using \"%s\" toolkit.") % toolkit)

def init_debugging():
	log = logging.getLogger()
	log.setLevel(logging.DEBUG)
	
	stderr_handler = logging.StreamHandler(sys.stderr)
	# %(levelname)s [%(asctime)s] %(name)s: %(message)s
	stderr_handler.setFormatter(logging.Formatter("%(levelname)s - %(name)s: %(message)s"))
	log.addHandler(stderr_handler)

def init_locale():
	global _locale
	global locale_set
	
	log = logging.getLogger("init")
	
	gettext.install("mascyma")
	try:
		_locale = gettext.translation("mascyma", path["locale"])
	except:
		log.warn("Could not load locale.")
		_locale = gettext.NullTranslations()
	
	locale.setlocale(locale.LC_ALL, '')
	try:
		log.debug(_("Using the 'locale' module to set locale."))
		locale.textdomain("mascyma")
		locale.bindtextdomain("mascyma", path["locale"])
		log.debug(_("Locale set."))
	except AttributeError, ex:
		log.debug(ex)
		locale_set = False
	else:
		locale_set = True
		
def init_guilocale():
	global _locale
	global locale_set
	
	log = logging.getLogger("init")
	
	# The following is necessary because we use PyGlade,
	# which of course does not use Python's gettext but libintl.
	if not locale_set:
		if toolkit == 'gtk':
			log.debug(_("Using Glade methods to set locale."))
			import gtk.glade
			gtk.glade.bindtextdomain("mascyma", path["locale"])
			gtk.glade.textdomain("mascyma")
			log.debug(_("Locale set."))
		
		if sys.platform == 'win32' and toolkit == 'gtk':
			log.debug(_("Trying to set C locale."))
			try:
				from ctypes import cdll
				lib = cdll.LoadLibrary(r'GTK\lib\libintl-1.dll')
				lib.bindtextdomain('mascyma', path["locale"])
				lib.textdomain('mascyma')
				lib.bind_textdomain_codeset('mascyma', 'UTF-8')
			except Exception, ex:
				log.debug(ex)
				log.warn(_("Could not set C locale."))
			else:
				log.debug(_("C locale set! W00t!"))

def init_paths():
	path["glade"] = "./mascyma.glade"
	path["xrc"] = "./mascyma.xrc"
	path["locale"] = "./po"
	path["data"] = "./data"

def init_gui():
	try:
		import pygtk
		pygtk.require('2.0')
	except ImportError:
		# Some distributions ship the 'gtk' module,
		# but not the 'pygtk' one. Bleh.
		pass

def init():
	global toolkit
	if sys.platform == 'win32' or sys.platform == 'macos':
		toolkit	= 'wx'
	else:
		toolkit = 'gtk'
	
	init_paths()
	init_debugging()
	init_locale()
	init_cmdline()
	init_os()
	init_gui()
	init_guilocale()

