/*****************************************************************************
 * 
 * This file is part of Mapnik (c++ mapping toolkit)
 *
 * Copyright (C) 2006 Artem Pavlenko, Jean-Francois Doyon
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/
//$Id$

// boost
#include <boost/python/suite/indexing/map_indexing_suite.hpp>
#include <boost/python.hpp>
// mapnik
#include <mapnik/feature.hpp>

void export_feature()
{
   using namespace boost::python;
   using mapnik::Feature;
   class_<Feature,boost::shared_ptr<Feature>,
      boost::noncopyable>("Feature",no_init)
      .def("id",&Feature::id)
      .def("__str__",&Feature::to_string)
      //.def(map_indexing_suite<mapnik::Feature>())
      .add_property("properties", 
                    make_function(&Feature::props,return_value_policy<reference_existing_object>()))
      ;
    
   class_<std::map<std::string, mapnik::value> >("Properties")
      .def(map_indexing_suite<std::map<std::string, mapnik::value
	   > >())
      ;
    
   class_<mapnik::value>("Value")
      .def("__str__",&mapnik::value::to_string)
      .def("unicode",&mapnik::value::to_unicode)
      ;
}
