'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: upvar.n,v 1.2 2003/11/24 05:10:00 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: upvar.n,v 1.2 2003/11/24 05:10:00 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH upvar n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
upvar \- 建立到在不同栈桢上的变量的连接
.SH "总览 SYNOPSIS"
\fBupvar \fR?\fIlevel\fR? \fIotherVar myVar \fR?\fIotherVar myVar \fR...?
.BE

.SH "描述 DESCRIPTION"
.PP
这个命令安排在当前过程中的一个或多个局部变量去引用位于包围它的过程调用中的变量或引用全局变量。 \fILevel\fR 可以用 \fBuplevel\fR 命令允许的任何形式，并且如果第一个 \fIotherVar\fR 的第一个字母不是 \fB#\fR 或一个数字，则可以被省略(它缺省为\fB1\fR)。对于每个 \fIotherVar\fR 参数，\fBupvar\fR 使由 \fIlevel\fR 给出的过程桢中(如果 \fIlevel\fR 是 \fB#0 \fR则在全局层次)的叫这个名字的变量在当前过程中可以用由相应的 \fImyVar\fR 参数给出名字来访问。在调用它的时候叫做 \fIotherVar\fR 的变量不需要存在；可以在第一次引用 \fImyVar\fR 时象普通变量那样建立它。在调用 \fBupvar\fR 的时候一定不能存在一个叫 \fImyVar\fR 的变量。\fIMyVar\fR 总是被作为一个变量的名字来对待，而不是一个数组的元素。即使这个名字看起来象一个数组元素，比如 \fBa(b)\fR，仍建立一个正规的变量。\fIOtherVar\fR 可以引用一个标量变量，或一个数组元素。\fBUpvar\fR 返回一个空串。
.PP
\fBupvar\fR 命令简化了传名调用(call-by-name)过程的实现并使它易于建立如同 Tcl 过程的新控制结构。例如，考虑下列过程:
.CS
\fBproc add2 name {
	upvar $name x
	set x [expr $x+2]
}\fR
.CE
调用\fB Add2\fR 时加上给出一个变量名字的一个参数，它向这个变量的值加二。尽管 \fBadd2\fR 可以使用 \fBuplevel\fR 替代 \fBupvar \fR来实现，\fBupvar\fR 简便了 \fBadd2\fR 访问在调用者过程桢中的变量。
.PP
\fBnamespace eval\fR 是改变 Tcl 命令上下文的另一种方式(除了过程调用之外)。它向栈增加一个调用桢来表示名字空间上下文。这意味着每个 \fBnamespace eval\fR 命令被视为给 \fBuplevel\fR 和 \fBupvar\fR 命令的另一个调用层次。例如，\fBinfo level 1\fR 将返回描述一个命令的列表，它要么是最外的过程要么是最外的 \fBnamespace eval\fR 命令。还有，\fBuplevel #0\fR 在最外面的名字空间(全局名字空间)中的顶层求值一个脚本。
.PP
.VS
如果删除(unset)一个 upvar 变量(比如，上面的 \fBadd2\fR 中的 \fBx\fR )，则 \fBunset\fR 操作影响它所连接到的变量，而不是 upvar 变量。除了退出在其中定义它的那个过程之外，没有方法删除一个 upvar 变量。但是，可以通过执行另一个 \fBupvar\fR 命令来为一个 upvar 变量重定目标(retarget)。

.SH "Traces 和 upvar"
.PP
upvar 以一种直接但可能不是预期的方式与 trace 交互。如果在 \fIotherVar \fR上定义了一个变量跟踪，涉及 \fImyVar \fR的动作将触发这个追踪。但是，传递给跟踪过程将是 \fImyVar \fR的名字，而不是 \fIotherVar\fR 的名字。 所以，下列代码的输出将是 \fBlocalVar\fR 而不是 \fBoriginalVar\fR:
.CS
\fBproc traceproc { name index op } {
	puts $name
}
proc setByUpvar { name value } {
	upvar $name localVar
	set localVar $value
}
set originalVar 1
trace variable originalVar w traceproc
setByUpvar originalVar 2
}\fR
.CE

如果 \fIotherVar\fR 引用一个数组的元素，则为整个数组设置的变量跟踪在 \fImyVar\fR 被访问的时候将不被调用(但在特定元素上的跟踪仍将被调用)。特别的，如果这个数组是 \fBenv\fR，则对 \fImyVar\fR 的变动将不被正确的传递给子进程。

.VE

.SH "参见 SEE ALSO"
global(n), namespace(n), uplevel(n), variable(n)

.SH "关键字 KEYWORDS"
context, frame, global, level, namespace, procedure, variable

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/11/21
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
