/* This file is part of the KDE project

   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef SMTP_H
#define SMTP_H

#include "qwidget.h"
class QSocket;

namespace Mailody {

class SocketSafe;

/**
 * @class SMTP
 * Responsible for sending messages
 * @author Tom Albers <tomalbers@kde.nl>
 */
class SMTP : public QWidget
{
    Q_OBJECT

    public:
        /**
         * Contructor
         */
        explicit SMTP( QWidget* parent,  const char* name );

        /**
         * Destructor
         */
        ~SMTP();

        /**
         * send a message @p tos recipients and @p body with @p identity
         */
        void send(const QString identity, const QStringList& tos,
                  const QString& body);

    private:

        enum Commands {
                None=0,
                Connecting,
                Helo,
                TLS,
                Login,
                User,
                Pass,
                From,
                Rcpt,
                Data,
                DataBody,
                Done,
                NotDone
            };

        SocketSafe*         m_socket;
        QString             m_name;
        QString             m_email;
        QCString            m_login;
        QCString            m_pass;
        QStringList         m_tos;
        QString             m_message;
        Commands            m_currentCommand;
        bool                m_tls;
        bool                m_tlsPossible;
        bool                m_authNeeded;
        bool                m_authPossible;

    private slots:
        void slotRead(const QString&);
        void slotTLS();
        void slotLogin();
        void slotError(const QString& error);

    signals:
        void error(const QString&);
        void done();

    private:
        static SMTP*   m_instance;
        void manualAuth();
};

}

#endif // SMTP_H

