/* This file is part of the KDE project
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2001 Anders Lund <anders.lund@lund.tdcadsl.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef __KATE_FILESELECTOR_H__
#define __KATE_FILESELECTOR_H__

#include <kbookmarkmanager.h>
#include <kbookmarkmenu.h>

#include <qvbox.h>
#include <kfile.h>
#include <kurl.h>
#include <kurlcombobox.h>
#include <kdiroperator.h>
#include <kcombobox.h>
#include <ktoolbar.h>
#include <qframe.h>

class QToolButton;
class KateMainWindow;
class KateViewManager;
class KActionCollection;
class KActionSelector;

namespace FileBrowserNS {


/*
    The kate file selector presents a directory view, in which the default action is
    to open the activated file.
    Additinally, a toolbar for managing the kdiroperator widget + sync that to
    the directory of the current file is available, as well as a filter widget
    allowing to filter the displayed files using a name filter.
*/

/* I think this fix for not moving toolbars is better */
class FileBrowserToolBar: public KToolBar
{
	Q_OBJECT
public:
         explicit FileBrowserToolBar(QWidget *parent);
         virtual ~FileBrowserToolBar();

	 virtual void setMovingEnabled( bool b );
};

class FileBrowserToolBarParent: public QFrame
{
	Q_OBJECT
public:
	FileBrowserToolBarParent(QWidget *parent);
	~FileBrowserToolBarParent();
        void setToolBar(FileBrowserToolBar *tb);
private:
        FileBrowserToolBar *m_tb;
protected:
	virtual void resizeEvent ( QResizeEvent * );
};

class FileBrowser: public QVBox
{
  Q_OBJECT

  public:
    FileBrowser( QWidget * parent = 0, const char * name = 0 );
    ~FileBrowser();

    void readConfig( KConfig *, const QString & );
    void writeConfig( KConfig *, const QString & );
    void setupToolbar( KConfig * );
    void setView( KFile::FileView );
    KDirOperator *dirOperator(){ return dir; }
    KActionCollection *actionCollection() { return mActionCollection; };

  public slots:
    void setDir(KURL);
    void setDir( const QString& url ) { setDir( KURL( url ) ); };

  private slots:
    void cmbPathActivated( const KURL& u );
    void cmbPathReturnPressed( const QString& u );
    void dirUrlEntered( const KURL& u );
    void dirFinishedLoading();

  protected:
    void focusInEvent( QFocusEvent * );
    bool eventFilter( QObject *, QEvent * );
    void initialDirChangeHack();

  private:
    class FileBrowserToolBar *toolbar;
    KActionCollection *mActionCollection;
    class KBookmarkHandler *bookmarkHandler;
    KURLComboBox *cmbPath;
    KDirOperator * dir;
    class KAction *acSyncDir;

    KateMainWindow *mainwin;
    KateViewManager *viewmanager;

    QString lastFilter;
    int autoSyncEvents; // enabled autosync events
    QString waitingUrl; // maybe display when we gets visible
    QString waitingDir;
};

class KBookmarkHandler : public QObject, public KBookmarkOwner
{
    Q_OBJECT

public:
    KBookmarkHandler( FileBrowser *parent, KPopupMenu *kpopupmenu=0 );
    ~KBookmarkHandler();

    // KBookmarkOwner interface:
    virtual void openBookmarkURL( const QString& url ) { emit openURL( url ); }
    virtual QString currentURL() const;

    KPopupMenu *menu() const { return m_menu; }

signals:
    void openURL( const QString& url );

private slots:
    void slotNewBookmark( const QString& text, const QCString& url,
                          const QString& additionalInfo );
    void slotNewFolder( const QString& text, bool open,
                        const QString& additionalInfo );
    void newSeparator();
    void endFolder();

protected:
    virtual void virtual_hook( int id, void* data );

private:
    FileBrowser *mParent;
    KPopupMenu *m_menu;
    KBookmarkMenu *m_bookmarkMenu;

    QTextStream *m_importStream;

    //class KBookmarkHandlerPrivate *d;
};

}

#endif //__KATE_FILESELECTOR_H__
