/* This file is part of the KDE project

   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef COMPOSER_H
#define COMPOSER_H

#include <kabc/stdaddressbook.h>
#include <kmainwindow.h>
#include <kcompletion.h>
#include <kcompletionbox.h>
#include <kiconview.h>
#include <kfileiconview.h>

class QSplitter;
class QPushButton;
class FileBrowser;

class KFileItem;
class KFileIconView;
class KTextEdit;
class KListView;
class KListViewItem;
class QListViewItem;
class KComboBox;

#include "../libkmime/kmime_message.h"
#include "sidebar.h"
#include "filebrowser.h"

namespace KIO {
    class Slave;
    class MetaData;
}

namespace Mailody {

using namespace FileBrowserNS;
using namespace SideBar;
using namespace KABC;

class AddressLineEdit;
class DataListView;
class SMTP;
class ToolTip;
class ComposerTextEdit;
class MessageData;


/**
 * @class Composer
 * This is het main class for the composer...
 * @author Tom Albers <tomalbers@kde.nl>
 */
class Composer : public KMainWindow
{
  Q_OBJECT

    public:
        /**
        * Contructor
        * @param mb the mailbox where the resulting message will be stored.
        * @param identity the identity to use
        */
        explicit Composer(QWidget* parent, const QString& mb);

        /**
        * Destructor
        */
        ~Composer();

       /**
        * Call this to find out if the window is dirty
        */
        bool canClose();

        /**
         * You can use this enum for setRcpt, to set the type
         */
        enum TypeOfAddress{
            To = 1,
            Cc,
            Bcc
        };

        /**
         * add @p address to the composer
         */
        void setRcpt(const QString& address, TypeOfAddress addressType);

        /**
         * set @p identity as identity
         */
        void setIdentity(const QString& identity);

        /**
         * set @p subject to be the subject
         */
        void setSubject(const QString& subject);

        /**
         * set @p msg to be the message, after this call the cursor
         * will be set to the top of the text part, but only when there is
         * at least one recipient. @p sign indicates if you want to sign the
         * or not. Defaults to true (sign).
         */
        void setMsg(const QString& msg, bool sign=true);

        /**
         * add @p attachment to the message. It will take the filename as a
         * name, unless @p name is provided.
         */
        void addAttachment(const KURL& attachment,
                           const QString& name = QString::null);

        /**
         * set a In-reply-to header with the value @p messageID
         */
        void inReplyTo(const QString& messageID);

        /**
         * add signature at the end of @p text
         */
        void addSignature(QString& text);

        /**
         * set composer dirty or not. @p dirty
         */
        void setDirty(bool dirty=true);

        /**
         * set m_oldSig to @p text
         */
        void setOldSig(QString& text);

        /**
         * set m_newpos to @p pos
         */
        void setNewPos(int pos);

    protected:
        bool queryClose();

    private:


        AddressLineEdit                 *m_edit;
        DataListView                    *m_lv;
        KListView                       *m_addressbook;
        MailodyBaseListView             *m_recentbook;
        KListViewItem                   *m_lastInserted;
        int                             m_lastState;
        QMap<QListViewItem*, QString>   m_abMap;
        SideBar::Sidebar                *m_sidebar;
        QSplitter*                      m_hsplitter;
        QSplitter*                      m_vsplitter;
        QSplitter*                      m_vhsplitter;
        KLineEdit*                      m_subject;
        ComposerTextEdit*               m_text;
        SMTP*                           m_smtp;
        KMime::Message*                 m_main;
        QStringList                     m_tos;
        QPushButton*                    m_add;
        QString                         m_mailbox;
        QString                         m_replyTo;
        bool                            m_close;
        bool                            m_dirty;
        KABC::AddressBook*              m_ab;
        KComboBox*                      m_identityBox;
        FileBrowserNS::FileBrowser*     m_filebrowser;
        KFileIconView*                  m_attachview;
        QLabel*                         m_alabel;
        ToolTip*                        m_tip;
        QTimer*                         m_timer;
        QListViewItem*                  m_currentItem;
        QString                         m_oldSig;
        int                             m_sigPos;
        int                             m_newpos;

        const char * encoding(const QString& data);
        void addAddress(const QString& text);
        void showError(const QString& error);

        QString compileMessage(bool);

    private slots:
        void slotShiftAddress();
        void slotAddAddress(const QString&);
        void slotAddClicked();
        void slotAddFile(const KFileItem*);
        void slotAddFile(const KURL&);
        void slotUpdateLineEdit();
        void slotEditAddress(QListViewItem*, const QPoint&, int);
        void slotContextMenuAttachedFile(const KFileItem*, const QPoint&);
        void slotShowFile(const KFileItem*);

        void slotSetAddress(const QString& address);
        void slotReplaceSignature(const QString& signWith);

        void slotAddAddressFromAddressBook(QListViewItem*);
        void slotLoadAddressBook();
        void slotLoadAddresses(AddressBook* ab);
        void slotContextMenuAddressBook(KListView*, QListViewItem* lvi,
                                        const QPoint &point);
        void slotContextMenuAddressList(KListView*, QListViewItem* lvi,
                                        const QPoint &point);

        void slotLoadRecentBook();
        void slotAddAddressFromRecentBook(QListViewItem*);
        void slotContextMenuRecentBook(KListView*, QListViewItem*,
                                       const QPoint&);
        void slotShowRecentDetailsDoIt();
        void slotShowRecentDetails(QListViewItem*);
        void slotHideRecentDetails( );

        void slotSend();
        void slotSave();
        void slotDone();
        void slotError(const QString& error);
        void slotSetDirty();
        void slotFixedFont( bool );
};

}

#endif // COMPOSER
