/* This file is part of the KDE project
   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <klineedit.h>
#include <kdebug.h>
#include "addresslineedit.h"

//---------- Completion class --------------------//

namespace Mailody {

Completion::Completion( KLineEdit* parent)
    : KCompletion()
{
    m_box = new KCompletionBox(parent);
}

QString Completion::makeCompletion(const QString& text )
{
    QStringList results = substringCompletion( text );

    m_box->setItems(results);
    m_box->popup();

    return QString::null;
}

//------------- AddressLineEdit -------------------//
AddressLineEdit::AddressLineEdit(QWidget* parent)
    : KLineEdit(parent)
    , m_helpText(false)
{
    m_origColor = paletteForegroundColor();

    m_completion = new Completion( this );
    m_completion->setOrder( KCompletion::Sorted );
    m_completion->setIgnoreCase( true );
    connect(m_completion->box(), SIGNAL(activated(const QString&)),
            SLOT(slotSetAddress(const QString&)));

    setCompletionObject( m_completion );
    setAutoDeleteCompletionObject( true );
}

void AddressLineEdit::keyPressEvent ( QKeyEvent *e )
{
    if (help() && !(e->key() == Qt::Key_Return || e->key() == Qt::Key_Enter))
    {
        clear();
        setHelp(false);
        setPaletteForegroundColor(m_origColor);
        KLineEdit::keyPressEvent(e);
    }
    else if (help() && (e->key() == Qt::Key_Return || e->key() == Qt::Key_Enter))
        emit shiftAddress();
    else if (!help() && (e->key() == Qt::Key_Return || e->key() == Qt::Key_Enter))
    {
        QString textt;
        if (m_completion->boxVisible())
        {
            emit addAddress(m_completion->box()->currentText());
            m_completion->box()->hide();
        }
        else
            emit addAddress(text());
    }
    else
        KLineEdit::keyPressEvent(e);
}

void AddressLineEdit::mousePressEvent ( QMouseEvent * e )
{
    if (help())
    {
        clear();
        setHelp(false);
        setPaletteForegroundColor(m_origColor);
        KLineEdit::mousePressEvent(e);
    }
}

void AddressLineEdit::slotSetAddress(const QString& text)
{
    setText(text);
}

}

#include "addresslineedit.moc"
