#define PORT_LED_1 1<<0
#define PORT_LED_2 1<<1
#define PORT_LED_3 1<<2
#define PORT_LED_4 1<<3
#define PORT_LED_5 1<<4
#define PORT_LED_6 1<<5
#define PORT_LED_7 1<<6
#define PORT_LED_8 1<<7

#define X_CAP 1
#define X_NUM 2
#define X_SCR 3

#include <time.h>
#include <stdio.h>

/* default the maildir */
#ifndef MAILDIR
#include <paths.h>
#define MAILDIR _PATH_MAILDIR 
#endif

void blink_once(unsigned long on_pause, unsigned long off_pause);
void blink_x(unsigned long on_pause, unsigned long off_pause, int x);
void check_ttys(char **ttyfiles);
void close_files();
void detach_from_tty();
void exit_cleanly();
void exit_fatal(const char *reason);
void get_X_leds_from_kbd_leds(int leds);
void parse_argv(int argc, char **argv);
void reset_flags();
void set_kbd_leds(int leds);
void set_port_leds(int port, int leds);
void unset_port_leds(int port, int leds);
void set_pidfilename();
void stat_error(char *filename);
void poke_kbd_leds(int fd, int leds);
void usage(void);
void write_pidfile(void);
void *xmalloc(int bytes);
void make_tty_array();
void make_display_array(char **displays);
void close_display_array(void);
void free_2d_array(char **array);
int count_mail(FILE *mailbox);
int count_occurences(FILE *file, char *exp);
int get_kbd_leds(int fd);
int get_x_leds_from_kbd_leds(int leds);
int get_pid_from_file(char *pid_filename);
int pid_check();
char *get_mailfile();
char *itoa(int x);
FILE *open_mailbox_file(char *file);
time_t get_time_of(char *filename);


