<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2009 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2006-2009 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

define('INTERNAL', 1);
define('MENUITEM', 'groups/groupsiown');
require(dirname(dirname(__FILE__)) . '/init.php');
require_once('pieforms/pieform.php');
require_once('group.php');

if ($id = param_integer('id', null)) {
    define('TITLE', get_string('editgroup', 'group'));
    define('GROUP', $id);

    if (!group_user_access($id)) {
        $SESSION->add_error_msg(get_string('canteditdontown', 'group'));
        redirect('/group/mygroups.php');
    }

    $group_data = group_get_groups_for_editing(array($id));

    if (count($group_data) != 1) {
        throw new GroupNotFoundException(get_string('groupnotfound', 'group', $id));
    }

    $group_data = $group_data[0];
}
else {
    define('TITLE', get_string('creategroup', 'group'));

    if (!group_can_create_groups()) {
        throw new AccessDeniedException(get_string('accessdenied', 'error'));
    }

    $group_data = (object) array(
        'id'             => null,
        'name'           => null,
        'description'    => null,
        'grouptype'      => 'standard',
        'open'           => 1,
        'controlled'     => 0,
        'category'       => 0,
        'public'         => 0,
        'usersautoadded' => 0,
        'viewnotify'     => 1,
        'submittableto'  => 0,
        'editroles'      => 'all',
        'hidden'         => 0,
        'hidemembers'    => 0,
        'hidemembersfrommembers' => 0,
        'invitefriends'  => 0,
        'suggestfriends' => 0,
    );
}

$form = array(
    'name'       => 'editgroup',
    'plugintype' => 'core',
    'pluginname' => 'groups',
    'elements'   => array(
        'name' => array(
            'type'         => 'text',
            'title'        => get_string('groupname', 'group'),
            'rules'        => array( 'required' => true, 'maxlength' => 128 ),
            'defaultvalue' => $group_data->name,
        ),
        'description' => array(
            'type'         => 'wysiwyg',
            'title'        => get_string('groupdescription', 'group'),
            'rules'        => array('maxlength' => 65536),
            'rows'         => 10,
            'cols'         => 55,
            'defaultvalue' => $group_data->description,
        ),
        'settings' => array(
            'type'         => 'fieldset',
            'collapsible'  => true,
            'collapsed'    => false,
            'class'        => 'sectioned',
            'legend'       => get_string('settings'),
            'elements'     => array(),
        ),
        'submit' => array(
            'type'         => 'submitcancel',
            'value'        => array(get_string('savegroup', 'group'), get_string('cancel')),
            'goto'         => get_config('wwwroot') . 'group/mygroups.php',
        ),
    ),
);

$elements = array();

$elements['membership'] = array(
    'type'         => 'html',
    'title'        => get_string('Membership', 'group'),
    'value'        => '',
);

$cancreatecontrolled = $USER->get('admin') || $USER->get('staff')
    || $USER->is_institutional_admin() || $USER->is_institutional_staff();

$elements['open'] = array(
    'type'         => 'checkbox',
    'title'        => get_string('Open', 'group'),
    'description'  => get_string('opendescription', 'group'),
    'defaultvalue' => $group_data->open,
    'disabled'     => !$cancreatecontrolled && $group_data->controlled,
);
if ($cancreatecontrolled || $group_data->controlled) {
    $elements['controlled'] = array(
        'type'         => 'checkbox',
        'title'        => get_string('Controlled', 'group'),
        'description'  => get_string('controlleddescription', 'group'),
        'defaultvalue' => $group_data->controlled,
        'disabled'     => !$cancreatecontrolled,
    );
}
else {
    $form['elements']['controlled'] = array(
        'type'         => 'hidden',
        'value'        => $group_data->controlled,
    );
}
$elements['request'] = array(
    'type'         => 'checkbox',
    'title'        => get_string('request', 'group'),
    'description'  => get_string('requestdescription', 'group'),
    'defaultvalue' => !$group_data->open && $group_data->request,
    'disabled'     => $group_data->open,
);

// The grouptype determines the allowed roles
$grouptypeoptions = group_get_grouptype_options($group_data->grouptype);

// Hide the grouptype option if it was passed in as a parameter, if the user
// isn't allowed to change it, or if there's only one option.
if (!$id) {
    $grouptypeparam = param_alphanumext('grouptype', 0);
    if (isset($grouptypeoptions[$grouptypeparam])) {
        $group_data->grouptype = $grouptypeparam;
        $forcegrouptype = true;
    }
}
else if (!isset($grouptypeoptions[$group_data->grouptype])) {
    // The user can't create groups of this type.  Probably a non-staff user
    // who's been promoted to admin of a controlled group.
    $forcegrouptype = true;
}

if (!empty($forcegrouptype) || count($grouptypeoptions) < 2) {
    $form['elements']['grouptype'] = array(
        'type'         => 'hidden',
        'value'        => $group_data->grouptype,
    );
}
else {
    $elements['grouptype'] = array(
        'type'         => 'select',
        'title'        => get_string('Roles', 'group'),
        'options'      => $grouptypeoptions,
        'defaultvalue' => $group_data->grouptype,
        'help'         => true
    );
}

$elements['invitefriends'] = array(
    'type'         => 'checkbox',
    'title'        => get_string('friendinvitations', 'group'),
    'description'  => get_string('invitefriendsdescription', 'group'),
    'defaultvalue' => $group_data->invitefriends,
);

$elements['suggestfriends'] = array(
    'type'         => 'checkbox',
    'title'        => get_string('Recommendations', 'group'),
    'description'  => get_string('suggestfriendsdescription', 'group'),
    'defaultvalue' => $group_data->suggestfriends && ($group_data->open || $group_data->request),
    'disabled'     => !$group_data->open && !$group_data->request,
);

$elements['pages'] = array(
    'type'         => 'html',
    'title'        => get_string('views'),
    'value'        => '',
);

$elements['editroles'] = array(
    'type'         => 'select',
    'options'      => group_get_editroles_options(),
    'title'        => get_string('editroles', 'group'),
    'description'  => get_string('editrolesdescription', 'group'),
    'defaultvalue' => $group_data->editroles,
    'help'         => true,
);

if ($cancreatecontrolled) {
    $elements['submittableto'] = array(
        'type'         => 'checkbox',
        'title'        => get_string('allowssubmissions', 'group'),
        'description'  => get_string('allowssubmissionsdescription', 'group'),
        'defaultvalue' => $group_data->submittableto,
    );
}
else {
    $form['elements']['submittableto'] = array(
        'type'         => 'hidden',
        'value'        => $group_data->submittableto,
    );
}

$publicallowed = get_config('createpublicgroups') == 'all' || (get_config('createpublicgroups') == 'admins' && $USER->get('admin'));

if (!$id && !param_exists('pieform_editgroup')) {
    // If a 'public=0' parameter is passed on the first page load, hide the
    // public checkbox.  The only purpose of this is to allow custom create
    // group buttons/links which lead to a slightly simplified form.
    $publicparam = param_integer('public', null);
}

$ignorepublic = !$publicallowed || (isset($publicparam) && $publicparam === 0);

if ($cancreatecontrolled || !$ignorepublic) {
    $elements['visibility'] = array(
        'type'         => 'html',
        'title'        => get_string('Visibility'),
        'value'        => '',
    );
}

$elements['public'] = array(
    'type'         => 'checkbox',
    'title'        => get_string('publiclyviewablegroup', 'group'),
    'description'  => get_string('publiclyviewablegroupdescription', 'group'),
    'defaultvalue' => $group_data->public,
    'help'         => true,
    'ignore'       => $ignorepublic,
);

if ($cancreatecontrolled) {
    $elements['hidden'] = array(
        'type'         => 'checkbox',
        'title'        => get_string('hiddengroup', 'group'),
        'description'  => get_string('hiddengroupdescription', 'group'),
        'defaultvalue' => $group_data->hidden,
    );
    $elements['hidemembers'] = array(
        'type'         => 'checkbox',
        'title'        => get_string('hidemembers', 'group'),
        'description'  => get_string('hidemembersdescription', 'group'),
        'defaultvalue' => $group_data->hidemembers || $group_data->hidemembersfrommembers,
        'disabled'     => $group_data->hidemembersfrommembers,
    );
    $elements['hidemembersfrommembers'] = array(
        'type'         => 'checkbox',
        'title'        => get_string('hidemembersfrommembers', 'group'),
        'description'  => get_string('hidemembersfrommembersdescription', 'group'),
        'defaultvalue' => $group_data->hidemembersfrommembers,
    );
}
else {
    $form['elements']['hidden'] = array(
        'type'         => 'hidden',
        'value'        => $group_data->hidden,
    );
    $form['elements']['hidemembers'] = array(
        'type'         => 'hidden',
        'value'        => $group_data->hidemembers || $group_data->hidemembersfrommembers,
    );
    $form['elements']['hidemembersfrommembers'] = array(
        'type'         => 'hidden',
        'value'        => $group_data->hidemembersfrommembers,
    );
}

$elements['general'] = array(
    'type'         => 'html',
    'title'        => get_string('general'),
    'value'        => '',
);

if (get_config('allowgroupcategories')
    && $groupcategories = get_records_menu('group_category','','','displayorder', 'id,title')
) {
    $elements['category'] = array(
                'type'         => 'select',
                'title'        => get_string('groupcategory', 'group'),
                'options'      => array('0'=>get_string('nocategoryselected', 'group')) + $groupcategories,
                'defaultvalue' => $group_data->category);

    // If it's a new group & the category was passed as a parameter, hide it in the form.
    $groupcategoryparam = param_integer('category', 0);
    if (!$id && isset($groupcategories[$groupcategoryparam])) {
        $form['elements']['category'] = array(
            'type'  => 'hidden',
            'value' => $groupcategoryparam,
        );
    }
}

$elements['usersautoadded'] = array(
            'type'         => 'checkbox',
            'title'        => get_string('usersautoadded', 'group'),
            'description'  => get_string('usersautoaddeddescription', 'group'),
            'defaultvalue' => $group_data->usersautoadded,
            'help'         => true,
            'ignore'       => !$USER->get('admin'));
$elements['viewnotify'] = array(
    'type' => 'checkbox',
    'title' => get_string('viewnotify', 'group'),
    'description' => get_string('viewnotifydescription', 'group'),
    'defaultvalue' => $group_data->viewnotify
);

$form['elements']['settings']['elements'] = $elements;
$editgroup = pieform($form);

function editgroup_validate(Pieform $form, $values) {
    global $group_data;
    if ($group_data->name != $values['name']) {
        // This check has not always been case-insensitive; don't use get_record in case we get >1 row back.
        if ($ids = get_records_sql_array('SELECT id FROM {group} WHERE LOWER(TRIM(name)) = ?', array(strtolower(trim($values['name']))))) {
            if (count($ids) > 1 || $ids[0]->id != $group_data->id) {
                $form->set_error('name', get_string('groupalreadyexists', 'group'));
            }
        }
    }
    if (!empty($values['open'])) {
        if (!empty($values['controlled'])) {
            $form->set_error('open', get_string('membershipopencontrolled', 'group'));
        }
        if (!empty($values['request'])) {
            $form->set_error('request', get_string('membershipopenrequest', 'group'));
        }
    }
    if (!empty($values['invitefriends']) && !empty($values['suggestfriends'])) {
        $form->set_error('invitefriends', get_string('suggestinvitefriends', 'group'));
    }
    if (!empty($values['suggestfriends']) && empty($values['open']) && empty($values['request'])) {
        $form->set_error('suggestfriends', get_string('suggestfriendsrequesterror', 'group'));
    }
}

function editgroup_cancel_submit() {
    redirect('/group/mygroups.php');
}

function editgroup_submit(Pieform $form, $values) {
    global $USER, $SESSION, $group_data;

    $values['public'] = (isset($values['public'])) ? $values['public'] : 0;
    $values['usersautoadded'] = (isset($values['usersautoadded'])) ? $values['usersautoadded'] : 0;

    $newvalues = array(
        'name'           => $group_data->name == $values['name'] ? $values['name'] : trim($values['name']),
        'description'    => $values['description'],
        'grouptype'      => $values['grouptype'],
        'category'       => empty($values['category']) ? null : intval($values['category']),
        'open'           => intval($values['open']),
        'controlled'     => intval($values['controlled']),
        'request'        => intval($values['request']),
        'usersautoadded' => intval($values['usersautoadded']),
        'public'         => intval($values['public']),
        'viewnotify'     => intval($values['viewnotify']),
        'submittableto'  => intval($values['submittableto']),
        'editroles'      => $values['editroles'],
        'hidden'         => intval($values['hidden']),
        'hidemembers'    => intval(!empty($values['hidemembersfrommembers']) || !empty($values['hidemembers'])),
        'hidemembersfrommembers' => intval($values['hidemembersfrommembers']),
        'invitefriends'  => intval($values['invitefriends']),
        'suggestfriends' => intval($values['suggestfriends']),
    );

    db_begin();

    if ($group_data->id) {
        $newvalues['id'] = $group_data->id;
        group_update((object)$newvalues);
    }
    else {
        $newvalues['members'] = array($USER->get('id') => 'admin');
        $group_data->id = group_create($newvalues);
        $USER->reset_grouproles();
    }

    $SESSION->add_ok_msg(get_string('groupsaved', 'group'));

    db_commit();

    redirect('/group/view.php?id=' . $group_data->id);
}

$js = '
$j(function() {
    $j("#editgroup_controlled").click(function() {
        if ($(this).checked) {
            $j("#editgroup_request").removeAttr("disabled");
            $j("#editgroup_open").removeAttr("checked");
            if (!$j("#editgroup_request").attr("checked")) {
                $j("#editgroup_suggestfriends").removeAttr("checked");
                $j("#editgroup_suggestfriends").attr("disabled", true);
            }
        }
    });
    $j("#editgroup_open").click(function() {
        if ($(this).checked) {
            $j("#editgroup_controlled").removeAttr("checked");
            $j("#editgroup_request").removeAttr("checked");
            $j("#editgroup_request").attr("disabled", true);
            $j("#editgroup_suggestfriends").removeAttr("disabled");
        }
        else {
            $j("#editgroup_request").removeAttr("disabled");
            if (!$j("#editgroup_request").attr("checked")) {
                $j("#editgroup_suggestfriends").removeAttr("checked");
                $j("#editgroup_suggestfriends").attr("disabled", true);
            }
        }
    });
    $j("#editgroup_request").click(function() {
        if ($(this).checked) {
            $j("#editgroup_suggestfriends").removeAttr("disabled");
        }
        else {
            if (!$j("#editgroup_open").attr("checked")) {
                $j("#editgroup_suggestfriends").removeAttr("checked");
                $j("#editgroup_suggestfriends").attr("disabled", true);
            }
        }
    });
    $j("#editgroup_invitefriends").click(function() {
        if ($(this).checked) {
            if ($j("#editgroup_request").attr("checked") || $j("#editgroup_open").attr("checked")) {
                $j("#editgroup_suggestfriends").removeAttr("disabled");
            }
            $j("#editgroup_suggestfriends").removeAttr("checked");
        }
    });
    $j("#editgroup_suggestfriends").click(function() {
        if ($(this).checked) {
            $j("#editgroup_invitefriends").removeAttr("checked");
        }
    });
    $j("#editgroup_hidemembersfrommembers").click(function() {
        if ($(this).checked) {
            $j("#editgroup_hidemembers").attr("checked", true);
            $j("#editgroup_hidemembers").attr("disabled", true);
        }
        else {
            $j("#editgroup_hidemembers").removeAttr("disabled");
        }
    });
});
';

$smarty = smarty(array('jquery'));
$smarty->assign('form', $editgroup);
$smarty->assign('PAGEHEADING', TITLE);
$smarty->assign('INLINEJAVASCRIPT', $js);
$smarty->display('form.tpl');
