/*******************

Written by Frank Rimlinger, Jan 1993
*******************/

#ifndef Frank_FGLvarInitInfo
#define Frank_FGLvarInitInfo

#include "FGLvarTypes.h"

// This class is used for initializing a GLvar
// Just create a subclass CGLvarInitInfo
// and override the InitInfo method.  Templates are
// provided for this purpose.

// Sometimes it is useful to directly
// alter the object from time to time in order  to create
// GLvar's with a similar but not identical set of characteristics.

// To extract the InitInfo from an existing CGLvar, just create
// a CGLvarInitInfo and send it the InitInfoFromGLvar message,
// passing the CGLvar object.

// Be sure to dispose your nameInitInfo object when
// you are done using it.  

class FGLvar;

class FGLvarInitInfo: public FObject{
public:

// NAME	
	Str255 errorStr;			// name of GLvar (used by error handler)
	
// WALKS
	long IDactiveMax;		// number of simultaneously active walks 

// PACKET SIZES	
	long rNoEntries;		// real link of a real vertex	
	long iNoEntries;		// ideal link of a real or an ideal vertex 			
	long lutNoEntries;	// ideal vertex look-up table				
	long ChildNoEntries;	// child vertices generated by CGLwalkNode
	
// DATA	
	Boolean useD;
	long DtypeSize;
	Boolean useiD;
	long iDtypeSize;

// RECYCLING
	long recycleBlockSize;
	Boolean recycleReal;
	Boolean recycleIdeal;
	
// BACKYARDS
	long rBackYardSize;
	long irBackYardSize;
	long iBackYardSize;
	long lutBackYardSize;
	long rvBackYardSize;
	long ivBackYardSize;

// METHODS
	virtual void InitInfoFromGLvar(FGLvar *v);
};
#endif


