// Copyright (C) 1996 The New York Group Theory Cooperative
// See magnus/doc/COPYRIGHT for the full notice.

// Contents: Definition of class OneRelatorGroupWithTorsion,
//                               OneRelatorGroupWithTorsionRep.
//
// Principal Author: Dmitry Pechkin
//
// Status: in progress
//
// Revision History:
//

#ifndef _OR_GROUP_WITH_TORSION_H_
#define _OR_GROUP_WITH_TORSION_H_

#include "OneRelatorGroup.h"

class OneRelatorGroupWithTorsionRep : public OneRelatorGroupRep
{
public:

  ///////////////////////////////////////////////////////
  //                                                   //
  //  Constructors                                     //
  //                                                   //
  ///////////////////////////////////////////////////////
        
  OneRelatorGroupWithTorsionRep( int ngens, const Word& relator );
  // To construct a group of given number of unnamed generators and
  // a given relator.
  
  OneRelatorGroupWithTorsionRep( const VectorOf<Chars>& gennames, 
				 const Word& relator ); 
  // To construct a group with named generators, a given relator.  

  OneRelatorGroupWithTorsionRep( const FPGroup& G );
  
  // Copy ctor, operator= and dtor provided by compiler


  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Representation methods:                                             //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////
  
  PureRep* clone( ) const { return new OneRelatorGroupWithTorsionRep(*this); }
  // Overrides OneRelatorGroupRep::clone().

  static const Type theOneRelatorGroupWithTorsionType;

  static Type type( ) { return theOneRelatorGroupWithTorsionType; }
  // dominates OneRelatorGroupRep::type()

  Type actualType( ) const { return type(); }
  // overrides OneRelatorGroupRep::actualType();

  ///////////////////////////////////////////////////////
  //                                                   //
  //  Accessors / Modifiers                            //
  //                                                   //
  ///////////////////////////////////////////////////////

  ///////////////////////////////////////////////////////
  //                                                   //
  //  Methods dealing with group structure             //
  //                                                   //
  ///////////////////////////////////////////////////////

  Trichotomy isFreeProduct( ) const;

  ///////////////////////////////////////////////////////
  //                                                   //
  //  Methods which deal with subgroups structure      //
  //                                                   //
  ///////////////////////////////////////////////////////

  bool isProperMagnusSubgroup( const VectorOf<Generator>& gens ) const;
  // Returns true iff a subgroup generated by `gens' is a Magnus one.

  bool doesMagnusSubgroupContainElt( const VectorOf<Generator>& subgroup, 
    const Word& w, Word& wInSubgroupBasis ) const;
  // Determines whether the word is in the given Magnus subgroup
  // If it is true then it expresses the word in the generators of 
  // the subgroup.

  bool isPowerOfEltInMagnusSubgroup( const VectorOf<Generator>& subgroup, 
    const Word& w, Word& subgroupElt, int& powerOfElt ) const;
  // Determines whether the given word `w' is a power of an element of
  // the given Magnus subgroup.

  ///////////////////////////////////////////////////////
  //                                                   //
  //  Methods which deal with group elements           //
  //                                                   //
  ///////////////////////////////////////////////////////

  Trichotomy wordProblem( const Word& w, 
    ProductOfRelatorConjugates& productOfRelatorConjugates ) const;
  // Solves word problem for the given word.
  // If the word is identity then it expressed as a product of 
  // relator conjugates.

  Trichotomy wordProblem( const Word& w ) const;
  // Overrides pseudo-virtual OnerelatorGroupRep::wordProblem(const Word&).

  Trichotomy conjugacyProblem( const Word& u, const Word& v, Word& conjugator )
    const;
  // Solves the conjugacy problem. If the words are conjugated then it returns 
  // the conjugator of first word to get the second one.

  Trichotomy conjugacyProblem( const Word& u, const Word& w ) const 
  {
    Word dummyConjugator;
    return conjugacyProblem( u, w, dummyConjugator );
  }
  // Overrides pseudo-virtual OnerelatorGroupRep::conjugacyProblem().

  Trichotomy maximalRoot( const Word& w, Word& maxRoot, int& maxPower ) const;
  // Finds maximal root of given word w. The root word is stored in `maxRoot',
  // and its power in `maxPower'. If the function returns value `donknow'
  // the answer is cannot be determined.

  int powerOfElt(const Word& w, Word& st, Word& x, 
		 ProductOfRelatorConjugates& productOfRelatorConjugates) const;

  VectorOf<Word> centralizerOfElt( const Word& w ) const;
  // Computes a centralizer of the given element. Returns subgroup generated by
  // a single element (maximal root of w)  always. 
  // This fact is proved by B.B.Newman.

  ///////////////////////////////////////////////////////
  //                                                   //
  //  I/O                                              //
  //                                                   //
  ///////////////////////////////////////////////////////

  GroupRep* readFrom( istream& istr, Chars& errMesg ) const;

  ///////////////////////////////////////////////////////
  //                                                   //
  //  IPC tools:                                       //
  //                                                   //
  ///////////////////////////////////////////////////////

  ///////////////////////////////////////////////////////
  //                                                   //
  //  Data:                                            //
  //                                                   //
  ///////////////////////////////////////////////////////

};

class  OneRelatorGroupWithTorsion 
  : public DerivedObjectOf<OneRelatorGroup,OneRelatorGroupWithTorsionRep>
{
public:

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Constructors:                                                      //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  OneRelatorGroupWithTorsion( int ngens, const Word& relator ) 
    : DerivedObjectOf<OneRelatorGroup, OneRelatorGroupWithTorsionRep>( 
	new OneRelatorGroupWithTorsionRep( ngens, relator ) 
      ) {} 
  // To construct a group of given number of unnamed generators and
  // a given relator.
  
  OneRelatorGroupWithTorsion( const VectorOf<Chars>& gennames, 
			      const Word& relator )
    : DerivedObjectOf<OneRelatorGroup, OneRelatorGroupWithTorsionRep>( 
	new OneRelatorGroupWithTorsionRep( gennames, relator ) 
      ) {} 
  // To construct a group with named generators, a given relator.  

  OneRelatorGroupWithTorsion( const FPGroup& G )
    : DerivedObjectOf<OneRelatorGroup, OneRelatorGroupWithTorsionRep>( 
	new OneRelatorGroupWithTorsionRep( G )
      ) {} 
  
  // Copy constructor, operator=, and destructor supplied by compiler.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Accessors:                                                         //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Methods and operators which deal with the group:                   //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////
  
  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Methods and operators which deal with subgroups:                   //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  bool isProperMagnusSubgroup( const VectorOf<Generator>& subgroup ) const
  {
    return look()->isProperMagnusSubgroup( subgroup );
  }
  // Returns true iff a subgroup generated by `gens' is a Magnus one.

  bool doesMagnusSubgroupContainElt( const VectorOf<Generator>& subgroup, 
    const Word& w, Word& wInSubgroupBasis ) const
  {
    return look()->doesMagnusSubgroupContainElt( subgroup,w,wInSubgroupBasis );
  }
  // Determines whether the word is in the given Magnus subgroup
  // If it is true then it expresses the word in the generators of 
  // the subgroup.

  bool isPowerOfEltInMagnusSubgroup( const VectorOf<Generator>& subgroup, 
    const Word& w, Word& subgroupElt, int& powerOfElt ) const
  {
    return look()->isPowerOfEltInMagnusSubgroup( subgroup, w, subgroupElt, 
						 powerOfElt );
  }
  // Determines whether the given word `w' is a power of an element of
  // the given Magnus subgroup.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Methods which deal with group elements:                            //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  // Trichotomy wordProblem( const Word& w ) const;
  // Overrides pseudo-virtual OneRelatorGroup::wordProblem().

  Trichotomy wordProblem( const Word& w, 
    ProductOfRelatorConjugates& productOfRelatorConjugates ) const 
  {
    return look()->wordProblem( w, productOfRelatorConjugates );
  }
  // Solves word problem for the given word.
  // If the word is identity then it expressed as a product of 
  // relator conjugates.

  // @dp will be implemented soon. 
  // Trichotomy conjugacyProblem( const Word& u, const Word& w ) const;
  // Overrides pseudo-virtual OnerelatorGroupRep::conjugacyProblem().

  Trichotomy conjugacyProblem( const Word& u, const Word& v, Word& conjugator)
    const
  {
    return look()->conjugacyProblem( u, v, conjugator );
  }
  // Solves the conjugacy problem. If the words are conjugated then it returns 
  // the conjugator of first word to get the second one.


  Trichotomy maximalRoot( const Word& w, Word& maxRoot, int& maxPower ) const 
  {
    return look()->maximalRoot( w, maxRoot, maxPower );
  }
  // Finds maximal root of given word w. The root word is stored in `maxRoot',
  // and its power in `maxPower'. If the function returns value `donknow'
  // the answer is cannot be determined.


  int powerOfElt(const Word& w, Word& st, Word& x, 
		 ProductOfRelatorConjugates& productOfRelatorConjugates ) const
  {
    return look()->powerOfElt( w, st, x, productOfRelatorConjugates );
  }
  // Return finite order or 0 iff the element of infinite order.
  // If the one is of finite order then decomposition of w is
  //    w = (s^t)^x * R1^c1 * ... * Rm^cm
  // where G = < X | r = s^k = 1 > is the given group, 
  //       Ri is r or r^-1, st = s^t.
  

  VectorOf<Word> centralizerOfElt( const Word& w ) const {
    return look()->centralizerOfElt( w );
  }
  // Computes a centralizer of the given element. Returns subgroup generated by
  // a single element (maximal root of w) always. 
  // This fact is proved by B.B.Newman.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // I/O:                                                                //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // IPC tools:                                                          //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

protected:

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Protected functions:                                                //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  OneRelatorGroupWithTorsion( OneRelatorGroupWithTorsionRep *newrep ) 
    : DerivedObjectOf<OneRelatorGroup, OneRelatorGroupWithTorsionRep>(newrep){}

};

#endif
