/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file IsoShading.h
    \brief Definition of the Template class IsoShading.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 9-Mar-2004
    
    Changes:
*/

#ifndef IsoShading_H
#define IsoShading_H

#include "magics.h"
#include "Factory.h"
#include "Translator.h"

#include "IsoShadingAttributes.h"
#include "Colour.h"
#include "LevelSelection.h"
#include "Polyline.h"
#include "MatrixHandler.h"
namespace magics {

template <class P>
class IsoShading: public IsoShadingAttributes<P> {

public:
	IsoShading();
	virtual ~IsoShading();
	void set(const map<string, string>& map ) { IsoShadingAttributes<P>::set(map); }
	void set(const XmlNode& node ) { IsoShadingAttributes<P>::set(node); }
	virtual void operator()(Polyline*) const;
	
	virtual IsoShading<P>* clone() const {
		IsoShading<P>* object = new IsoShading<P>();
		object->copy(*this);
	    return object;
	}
	
	virtual void operator()(MatrixHandler<P>& data, BasicGraphicsObjectContainer& parent) 
		{ (*this->technique_)(data, parent); }

	virtual Colour colour(double value) { return this->colourMethod_->colour(value); }
	virtual Colour leftColour(double value) { return this->colourMethod_->left(value); }
	virtual Colour rightColour(double value) { return this->colourMethod_->right(value); }
	virtual bool operator()(const LevelSelection& list)
	{ 
		LevelSelection filter;
		for (LevelSelection::const_iterator level = list.begin(); level != list.end(); ++level) 
			if ( this->min_ <= *level && *level <= this->max_ ) 
			          filter.push_back(*level); 
		(*this->colourMethod_).prepare(filter); 
		return (*this->technique_).prepare(filter, *this->colourMethod_);
	}
	// returns true, if the contouring lines have to be created... False, is the shading is finished...
	virtual void visit(LegendVisitor& legend) 
		{ (*this->technique_).visit(legend, *this->colourMethod_); }
	virtual bool shadingMode() { return (*this->technique_).shadingMode(); }
    
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	vector<Colour> colours_;
	vector<Colour>::iterator colour_;

private:
	//! Copy constructor - No copy allowed
	IsoShading(const IsoShading<P>&);
	//! Overloaded << operator to copy - No copy allowed
	IsoShading& operator=(const IsoShading<P>&);

// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const IsoShading<P>& p)
		{ p.print(s); return s; }

};

template <class P>
class Translator<string, IsoShading<P> > { 
public:
	IsoShading<P>* operator()(const string& val )
	{
		 return SimpleObjectMaker<IsoShading<P> >::create(val);
	}     
	IsoShading<P>* magics(const string& param)
	{
		IsoShading<P>* object;
		ParameterManager::update(param, object);
		return object;
	}
};
} // namespace magics
#include "IsoShading.cc"

#endif
