/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file DateAxis.cc
    \brief Implementation of the Template class DateAxis.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/



#include "DateAxis.h"

using namespace magics;




DateAxis::DateAxis()
{
	update();
		
		
		
}


DateAxis::~DateAxis() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void DateAxis::print(ostream& out)  const
{
	out << "DateAxis[";
	out << "]";
}

double DateAxis::getMin() const
{
	update();
	return from_ - base_;
}


double DateAxis::getMax() const
{
	update();
	return to_  - base_;
}

void DateAxis::update() const
{ 
	from_ =  (date_min_ != "undef" ) ? DateTime(date_min_) : DateTime();
	to_ = (date_max_ != "undef" ) ? DateTime(date_max_) : DateTime();
    base_ = (DateAxisAttributes::reference_ != "undef" ) ? 
    		DateTime(DateAxisAttributes::reference_) : from_;

	
}

void DateAxis::prepare(double min, double max, AxisItems& items) const
{
	update();
	//Log::dev()<< "min..." << min << endl;
	//Log::dev()<< "max..." << max << endl; 
	
	Second smin(double(min));
	Second smax(double(max));
	DateTime left = base_ + Second(min);
	DateTime right = base_ + Second(max);
	(*method_).prepare(base_, left, right, items);
	
	vector<AxisItem*> dates;
	for ( AxisItems::const_iterator item = items.begin(); item != items.end(); ++item) {
		if ( (**item).date() )
			dates.push_back(*item);
	}
	int position = 0;
	(*hours_).position(position);
	(*days_).position(position);
	(*months_).position(position);
	(*years_).position(position);
	
	(*hours_).labels(dates);	
	(*days_).labels(dates);	
	(*months_).labels(dates);
	(*years_).labels(dates);
	std::copy((*hours_).begin(), (*hours_).end(), back_inserter(items));
	std::copy((*days_).begin(), (*days_).end(), back_inserter(items));
	std::copy((*months_).begin(), (*months_).end(), back_inserter(items));
	std::copy((*years_).begin(), (*years_).end(), back_inserter(items));
	for ( AxisItems::const_iterator item = items.begin(); item != items.end(); ++item) {
		Log::debug() << " found at " << (**item).position() << " --->" << (**item).label() << "\n";
	}
}



void DateAxis::updateX(const Transformation& transformation)
{
	
	double min = transformation.getMinX();
	double max = transformation.getMaxX();
	if ( transformation.getReferenceX().empty() ) {
		 base_ = DateTime(reference_);
	}
	else {
		base_ = DateTime(transformation.getReferenceX());
	}
	DateTime from = base_ + Second(min*3600);
	DateTime to   = base_ + Second(max*3600);
	
	DateAxisAttributes::setDate_min(from);
	DateAxisAttributes::setDate_max(to);
	DateAxisAttributes::setReference(base_);
}

void DateAxis::updateY(const Transformation& transformation)
{
	if ( transformation.getReferenceY().empty() ) {
      	update();
//		Log::dev()<< "DATE--->" << from_;
//		double max = to_ - from_;
//		transformation.setMinY(0);
//		transformation.setReferenceY(string(from_));
//		transformation.setMaxY(max);
//		
		return;
	}
	
	double min = transformation.getMinY();
	double max = transformation.getMaxY();	
	base_ = DateTime(transformation.getDataReferenceY());
	
	DateTime from = base_ + Second(min*3600);
	DateTime to   = base_ + Second(max*3600);
	
	DateAxisAttributes::setDate_min(from);
	DateAxisAttributes::setDate_max(to);
}
