/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotMedianAttributes.cc
    \brief Implemtation of BoxPlotMedian Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Oct 26 20:27:36 2009
*/    

#include "BoxPlotMedianAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotMedianAttributes::BoxPlotMedianAttributes():
	colour_(Translator<string, Colour>().magics("boxplot_median_colour")),
	thickness_(ParameterManager::getInt("boxplot_median_thickness")),
	style_(Translator<string, LineStyle>().magics("boxplot_median_line_style"))
{
} 



BoxPlotMedianAttributes::~BoxPlotMedianAttributes()
{
}

    
void BoxPlotMedianAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "boxplot_median";
	prefix[1] = "boxplot";

	setAttribute(prefix, "boxplot_median_colour", colour_, params);
	setAttribute(prefix, "boxplot_median_thickness", thickness_, params);
	setAttribute(prefix, "boxplot_median_line_style", style_, params);
}

void BoxPlotMedianAttributes::copy(const BoxPlotMedianAttributes& other)
{
	setColour(other.colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
} 


bool BoxPlotMedianAttributes::accept(const string& node)
{	
	if ( magCompare(node, "median")  )
		return true;
	return false;
}

void BoxPlotMedianAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "median") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void BoxPlotMedianAttributes::print(ostream& out)  const
{
	out << "BoxPlotMedianAttributes[";
	out << "colour = " << *colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << "]" << "\n";
}


void BoxPlotMedianAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tboxplot_median_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tboxplot_median_thickness = \'" << thickness_ << "\'\n";
	out << tab << "\tboxplot_median_line_style = \'" << style_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> boxplot_median_colour("boxplot_median_colour", "navy", "");
static MagicsParameter<int> boxplot_median_thickness("boxplot_median_thickness", 3, "");
static MagicsParameter<string> boxplot_median_line_style("boxplot_median_line_style", "solid", "");
