/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLStepNode.h
    \brief Definition of OpenGLStepNode.
    \author Graphics Section, ECMWF

    Started: May 2008
*/

#ifndef _OpenGLStepNode_H
#define _OpenGLStepNode_H

#include <magics.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include <OpenGLNode.h>

namespace magics {


class AnimationStep;
class OpenGLLayoutNode;


class OpenGLStepNode : public OpenGLNode
{
public:
	OpenGLStepNode();
	OpenGLStepNode(string n,AnimationStep *s);
	~OpenGLStepNode();
	string  name() {return name_;};

	int     id() {return id_;}
	void    id(int i) {id_=i;}
	bool    cached() {return cached_;}
	void    cached(bool b) {cached_=b;}
	AnimationStep*   step() {return step_;}
	OpenGLLayoutNode* parentLayout() {return parentLayout_;}
	void setParentLayout(OpenGLLayoutNode *p) {parentLayout_=p;}
	


protected:
	AnimationStep* step_;
	int         id_;
	bool        cached_;			
	OpenGLLayoutNode *parentLayout_;
};


}


#endif
