/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLPainter.h
    \brief Definition of OpenGLPainter.
    \author Graphics Section, ECMWF

    Started: May 2009
*/


#ifndef _OpenGLPainter_H
#define _OpenGLPainter_H

#include <magics.h>
#include <Colour.h>
#include <Label.h>

#include <GL/gl.h>

//#include <Colour.h>
//#include <OpenGLFont.h>

namespace magics 
{

class OpenGLFontHandler;
class Text; 

class PaperPoint;

class OpenGLPainter
{
public:
	~OpenGLPainter() {};
	static OpenGLPainter* instance();

	Colour interpolateColour(const Colour &, const Colour &, float);

	void renderText(const Text* text,float coordratioY=1.,float mfactor=1) const;		       
	void renderText(float,float, Colour &, float, string, float angle=0);
	
	void buildRoundedRectPolygon(int,int,int,int,int,vector<float> &, vector<float> &);
	void renderRoundedRect(int, int, int, int, int, Colour, float, bool);
	void renderFilledRoundedRect(int, int, int, int, int, Colour);

	void renderPolygon(vector<float>&,vector<float>&, Colour&,float, bool);
	void renderFilledPolygon(vector<float>&,vector<float>&, Colour&);
	void renderFilledPolygon(vector<float>&,vector<float>&, vector<Colour>&);

	void renderRect(float,float,float,float,Colour &);
	void renderFilledRect(float,float,float,float,Colour &);
	
protected:
	OpenGLPainter();

private:
	float convertCM(const float cm) const {return cm*cmScale_;}

	static OpenGLPainter* instance_;	
	static float cmScale_;

	static OpenGLFontHandler *fontHandler_;
	
};

}


#endif
