/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLNode.cc
    \brief Definition of a Tree template class.
    \author Graphics Section, ECMWF

    Started: August 2008
*/

#include <iostream>
#include <vector>
#include <map>

#include <OpenGLNode.h>

using namespace std;
using namespace magics;


OpenGLNode::~OpenGLNode()
{
	Log::dev()<< "delete: " << name_ << endl; 
	free();	
	Log::dev()<< "delete: " << name_ << "  OK!" << endl; 
}

bool OpenGLNode::accept(OpenGLNodeVisitor& v) 
{ 
         if(v.visitEnter(*this))
	 {	 
	 	v.visit(*this);
	 	 
	 	for (NodeIterator it = children_.begin(); it != children_.end(); it++) 
	 	{            
			if((*it)->accept(v) == false)
			{
				break;
			}	           
         	}	 	
	 }	 
	 return v.visitLeave(*this);	 
}
 
void OpenGLNode::addNode(OpenGLNode* t)
{
	children_.push_back(t);
	t->parent(this);
	t->level(level_+1);
}

void OpenGLNode::deleteNode(string name)
{
	for(NodeIterator it = children_.begin(); it != children_.end(); it++) 
	{  
		if( (*it)->name() == name)
		{
			(*it)->free();
			children_.erase(it);		
		}
		return;
	}
}

void OpenGLNode::deleteChildren()
{
	for(NodeIterator it = children_.begin(); children_.size() > 0 && it != children_.end(); it++) 
	{  		
			(*it)->free();
			children_.erase(it);		
	}
}

void OpenGLNode::print()
{
	printData();
	printChildren();		
}


void OpenGLNode::printData()
{
	for(int i=0; i < level_; i++)
	{
		Log::dev()<< "\t";
	}
	
	Log::dev()<< "(lev: " << level_  << ") ";		
	//Log::dev()<< "name: " << name_  << " status:" << status_ << " " ;
	Log::dev()<< "name: " << name_  << " (" <<  classType_ << ")" << endl ;
	//data_->print();	
}


void OpenGLNode::printChildren()
{		
	for(NodeIterator it=children_.begin(); it!=children_.end(); it++)
	{
		(*it)->print(); 
	}
}


void  OpenGLNode::find(string s,list<OpenGLNode*>& t)
{

	if(name_.find(s) != string::npos)
	{
		t.push_back(this);
	}
	

	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->find(s,t); 
	}	
}

void OpenGLNode::findLayout(list<OpenGLNode*>& t)
{
	if(classType_ == "OpenGLLayoutNode")
	{
		//Log::debug() << "Layout found: " << name_ << endl;
		t.push_back(this);
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findLayout(t); 
	}
}

void OpenGLNode::findMagnifierLayout(list<OpenGLNode*>& t)
{
	if(classType_ == "OpenGLMagnifierLayoutNode")
	{
		//Log::debug() << "Layout found: " << name_ << endl;
		t.push_back(this);
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findMagnifierLayout(t); 
	}
}

void OpenGLNode::findPreviewLayout(list<OpenGLNode*>& t)
{
	if(classType_ == "OpenGLPreviewLayoutNode")
	{
		//Log::debug() << "Layout found: " << name_ << endl;
		t.push_back(this);
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findPreviewLayout(t); 
	}
}


void OpenGLNode::findPage(list<OpenGLNode*>& t)
{
	//Log::dev()<< "type: " << typeid(*this).name() << endl;
	
	/*if(typeid(*this) == typeid(OpenGLPageNode))
	{
		Log::dev()<< "Page found: " << name_ << endl;
		t.push_back(data_);
	}
	
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findPage(t); 
	}*/	
}	

void OpenGLNode::findFrame(list<OpenGLNode*>& t)
{	
	if(classType_ == "OpenGLFrameNode")
	{
		//Log::debug() << "Frame found: " << name_ << endl;
		t.push_back(this);
		//A frame cannot contain another frame!!!
		return;
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findFrame(t); 
	}
	
}	

void OpenGLNode::findStep(list<OpenGLNode*>& t)
{	
	if(classType_ == "OpenGLStepNode")
	{
		//Log::debug() << "Frame found: " << name_ << endl;
		t.push_back(this);
		//A frame cannot contain another frame!!!
		return;
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findStep(t); 
	}
	
}	

void OpenGLNode::findLayer(list<OpenGLNode*>& t)
{
	if(classType_ == "OpenGLLayerNode")
	{
		t.push_back(this);
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findLayer(t); 
	}
}

void OpenGLNode::findLayer(OpenGLNode** ln,string layerName)
{
	if(classType_ == "OpenGLLayerNode")
	{
		if(name_ == layerName)
		{
			*ln=this;
			return;
		}
	}
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		(*it)->findLayer(ln,layerName); 
	}
	
}


void OpenGLNode::free()
{		
	//delete data_;
		
	for(NodeIterator it=firstNode(); it!=lastNode(); it++)
	{
		Log::dev()<< "  del ptr: " << (*it)->name() << "  "  << *it << endl;
		delete *it; 		
	}
}
