/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLLayoutNode.cc
    \brief Definition of OpenGLLayoutNode
    \author Graphics Section, ECMWF

    Started: November 2008
*/


#include <OpenGLLayoutNode.h>
#include <OpenGLAreaGroup.h>

using namespace magics;

/*OpenGLLayoutNode::OpenGLLayoutNode()
{
	classType_="OpenGLLayoutNode";
}*/

OpenGLLayoutNode::OpenGLLayoutNode(string n,const Layout &l) : OpenGLNode(n), layout_(l), 
							       projectedMinX_(0.),
							       projectedMinY_(0.),
							       areaGroup_(0)					
{
	classType_="OpenGLLayoutNode";
}

OpenGLLayoutNode::~OpenGLLayoutNode()
{	
	deleteAreaGroup();

	/*for(list<OpenGLBoxRenderObject*>::iterator it=begin(); it != end(); it++)
	{
		delete *it;
	}*/
}

bool OpenGLLayoutNode::layoutCoordToWinCoord(float lx, float ly, float &wx, float &wy)
{
	//Get layout coordinate range
	const float minX = layout_.minX();
	const float maxX = layout_.maxX();
	const float minY = layout_.minY();
	const float maxY = layout_.maxY();

	if(lx > maxX || lx < minX || ly > maxY || ly < minY)
	{
		return false;
	}

	wx=winX()+winWidth()*(lx-minX)/(maxX-minX);
	wy=winY()+winHeight()*(ly-minY)/(maxY-minY);

	return true;
}

bool OpenGLLayoutNode::winCoordToLayoutCoord(float wx, float wy, float &lx, float &ly)
{
	if(!checkPointInWindow(wx,wy))
	{
		return false;
	}

	//Get layout coordinate range
	const float minX = layout_.minX();
	const float maxX = layout_.maxX();
	const float minY = layout_.minY();
	const float maxY = layout_.maxY();

	lx=minX+(maxX-minX)*(wx-winX())/winWidth();
	ly=minY+(maxY-minY)*(wy-winY())/winHeight();	

	return true;
}

bool OpenGLLayoutNode::winCoordToLayoutCoordByFitting(float wx, float wy, float &lx, float &ly)
{
	float fepsx=winWidth()/100000;
	float fepsy=winHeight()/100000;

	if(wx < winX())  wx=winX()+fepsx;
	if(wx > winX() + winWidth())  wx=winX() + winWidth()-fepsx;
	if(wy < winY())  wy=winY()+fepsy;
	if(wy > winY() + winHeight())  wy=winY() + winHeight()-fepsy;

	if(winCoordToLayoutCoord(wx,wy,lx,ly) == true)
	{
		return true;
	}
	else
	{
		return false;
	}
}


bool OpenGLLayoutNode::winAreaToLayoutArea(float wx1, float wy1, float wx2, float wy2, vector<PaperPoint> &pp)
{
	//Get layout coordinate range
	const float minX = layout_.minX();
	const float maxX = layout_.maxX();
	const float minY = layout_.minY();
	const float maxY = layout_.maxY();

	const float feps=0.01;

	if(wx1 < winX())  wx1=winX()+feps;
	if(wx2 > winX() + winWidth())  wx2=winX() + winWidth()-feps;
	if(wy1 < winY())  wy1=winY()+feps;
	if(wy2 > winY() + winHeight())  wy2=winY() + winHeight()-feps;

	float lx,ly;

        if(winCoordToLayoutCoord(wx1,wy1,lx,ly) == true)
	{
		pp.push_back(PaperPoint(lx,ly));
	}

        if(winCoordToLayoutCoord(wx2,wy1,lx,ly) == true)
	{
		pp.push_back(PaperPoint(lx,ly));
	}
	
  	if(winCoordToLayoutCoord(wx2,wy2,lx,ly) == true)
	{
		pp.push_back(PaperPoint(lx,ly));
	}

	if(winCoordToLayoutCoord(wx1,wy2,lx,ly) == true)
	{
		pp.push_back(PaperPoint(lx,ly));
	}

	if(pp.size() != 4)
	{
		return false;
	}

	return true;
}

void OpenGLLayoutNode::winSizeToLayoutSize(float ws, float &ls,bool horizontal)
{
	float lx1,lx2,ly1,ly2;

	if(horizontal)
	{
		winCoordToLayoutCoord(winX(),winY(),lx1,ly1);
		winCoordToLayoutCoord(winX()+ws,winY(),lx2,ly2);

		ls=lx2-lx1;	

	}
	else
	{
		winCoordToLayoutCoord(winX(),winY(),lx1,ly1);
		winCoordToLayoutCoord(winX(),winY()+ws,lx2,ly2);

		ls=ly2-ly1;

	}
}

OpenGLAreaGroup* OpenGLLayoutNode::createAreaGroup(int nx, int ny)
{
	deleteAreaGroup();
	areaGroup_= new OpenGLAreaGroup(winX(),winX()+winWidth(),winY(),winY()+winHeight(),nx,ny);
	return areaGroup_;	
}

/*
OpenGLBoxRenderObject* OpenGLLayoutNode::getBox(const string &bname)
{
	for(list<OpenGLBoxRenderObject*>::iterator it=begin(); it != end(); it++)
	{
		if((*it)->name() == bname)
		{
			return *it;
		}
	}
	return 0;
}


void OpenGLLayoutNode::addBox(OpenGLBoxRenderObject* b)
{
	push_back(b);
}

OpenGLBoxRenderObject* OpenGLLayoutNode::getEditableBox(int x, int y)
{
	for(list<OpenGLBoxRenderObject*>::iterator it=begin(); it != end(); it++)
	{
		if((*it)->editable() == true && (*it)->checkPointInWindow(x,y) == true)
		{
			return (*it);
		}
	}

	return 0;
}		

OpenGLBoxRenderObject* OpenGLLayoutNode::getEditableBox()
{
	for(list<OpenGLBoxRenderObject*>::iterator it=begin(); it != end(); it++)
	{
		if((*it)->editable() == true)
		{
			return (*it);
		}
	}

	return 0;
}		
*/
