/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLCore.cc
    \brief Definition of OpenGLCore
    \author Graphics Section, ECMWF

    Started: July 2009
*/


#include <OpenGLCore.h>
#include <OpenGLTextureItem.h>
#include <OpenGLFboItem.h>

using namespace magics;

OpenGLCore* OpenGLCore::instance_ = 0;
OpenGLCore::RenderMode renderMode_ = OpenGLCore::InvalidMode;

OpenGLCore::OpenGLCore()
{
	texMag_=0;
	fboMag_=0;

}

OpenGLCore* OpenGLCore::instance()
{
	if(instance_ == 0)	
	{
		instance_= new OpenGLCore;
		return instance_;
	}
	else
	{
		return instance_;
	}
}

void OpenGLCore::init(int fbWidth,int fbHeight)
{
	width_=fbWidth;
	height_=fbHeight;

	//Search for extensions	
	const GLubyte* extstr=glGetString(GL_EXTENSIONS);	

	/*Log::dev()<< "Available OpenGL extensions:" << endl << extstr << endl;	
	
	if(gluCheckExtension(reinterpret_cast<const GLubyte*>("GL_EXT_framebuffer_object")
	                     ,extstr) == GL_TRUE)
	{
	    Log::dev()<< "Extension: GL_EXT_framebuffer_object found!!!"  << endl; 
	}
	
	*/
 
	renderMode_=FboMode;
	//renderMode_=BackBufferMode;

	texBg_=new OpenGLTextureItem;
	texBg_->transparent(false);
	texBg_->generateFromImage(0,width_,height_,GL_RGBA);

	texFb_=new OpenGLTextureItem;
	texFb_->transparent(false);
	texFb_->generateFromImage(0,width_,height_,GL_RGBA);

	if(renderMode_ == FboMode)
	{
		fboBg_=new OpenGLFboItem;
		fboBg_->bind();
		fboBg_->attachTexture(texBg_->id());
		fboBg_->checkStatus();
		fboBg_->unBind();

		fboFb_=new OpenGLFboItem;
		fboFb_->bind();
		fboFb_->attachTexture(texFb_->id());
		fboFb_->checkStatus();
		glClear(GL_COLOR_BUFFER_BIT);
		fboFb_->unBind();		
	}
}

void OpenGLCore::initMag()
{
	if(texMag_) return;
 
	texMag_=new OpenGLTextureItem;
	texMag_->transparent(false);
	texMag_->generateFromImage(0,width_,height_,GL_RGBA);

	if(renderMode_ == FboMode)
	{
		fboMag_=new OpenGLFboItem;
		fboMag_->bind();
		fboMag_->attachTexture(texMag_->id());
		fboMag_->checkStatus();
		fboMag_->unBind();	
	}
}



void OpenGLCore::buildFb()
{
	if(renderMode_ == FboMode)
	{
		texFb_->mapTexture(0,0,width_,height_);
	}	
}

void OpenGLCore::bgToFb()
{
	if(renderMode_ == FboMode)
	{
		fboFb_->bind();
		texBg_->mapTexture(0,0,width_,height_);
		fboFb_->unBind();
	}
	else if(renderMode_ == BackBufferMode)
	{
		texBg_->mapTexture(0,0,width_,height_);
	}
}

void OpenGLCore::bgToFb(int x1, int y1, int x2, int y2)
{
	float sx1=static_cast<float>(x1)/static_cast<float>(width_);
	float sy1=static_cast<float>(y1)/static_cast<float>(height_);
	float sx2=static_cast<float>(x2)/static_cast<float>(width_);
	float sy2=static_cast<float>(y2)/static_cast<float>(height_);

	if(renderMode_ == FboMode)
	{
		fboFb_->bind();
		texBg_->mapTexture(sx1,sy1,sx2,sy2,x1,y1,x2,y2);
		fboFb_->unBind();
	}
	else if(renderMode_ == BackBufferMode)
	{
		texBg_->mapTexture(sx1,sy1,sx2,sy2,x1,y1,x2,y2);
	}
}

void OpenGLCore::fbToBg()
{
	if(renderMode_ == FboMode)
	{
		//fboFb_->bind();
		//texBg_->mapTexture(0,0,width_,height_);
		//fboFb_->unBind();
	}
	else if(renderMode_ == BackBufferMode)
	{
		texBg_->modifyFromFb(0,0,width_,height_,0.,0.);
	}
} 					    	