/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLBox.h
    \brief Definition of OpenGLBox.
    \author Graphics Section, ECMWF

    Started: May 2008
*/

#ifndef _OpenGLBox_H
#define _OpenGLBox_H

#include <magics.h>

namespace magics 
{

class OpenGLPoint
{
public:
	OpenGLPoint(float x=0.,float y=0.) : x_(x), y_(y) {};

	float x() {return x_;};
	float y() {return y_;};
	
	void x(float x) {x_=x;};
	void y(float y) {y_=y;};

protected:
	float x_;
	float y_;
};


class OpenGLBox
{
public:
	OpenGLBox(float x=0.,float y=0.,float w=0.,float h=0.) :
                         x_(x), y_(y), width_(w), height_(h) {};

	float x() {return x_;};
	float y() {return y_;};
	float width() {return width_;};
	float height() {return height_;};

	void x(float x) {x_=x;};
	void y(float y) {y_=y;};
	void width(float w) {width_=w;};
	void height(float h) {height_=h;};

	void set(OpenGLBox *b)
	{
		set(b->x(),b->y(),b->width(),b->height());
	}

	void set(float x, float y, float w, float h) 
	{
		x_=x; y_=y; width_=w; height_=h;
	}

	bool checkPointInBox(float, float y); 
	bool checkBoxSection(OpenGLBox *);
	bool checkBoxContained(OpenGLBox*);
	bool computeBoxSection(OpenGLBox *, OpenGLBox *);

protected:
	float x_;
	float y_;
	float width_;
	float height_;

};
}


#endif 
