/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLBaseRenderObject.h
    \brief Definition of an OpenGLBaseRenderObject  class.
    \author Graphics Section, ECMWF

    Started: November 2008
*/

#ifndef _OpenGLBaseRenderObject_H
#define _OpenGLBaseRenderObject_H

#include <iostream>
#include <vector>
#include <map>
#include <list>

#include <OpenGLDplManager.h>
#include <OpenGLBox.h>

using namespace std;

namespace magics {


class OpenGLBaseRenderObject
{
public:
	OpenGLBaseRenderObject() {};
	OpenGLBaseRenderObject(string);
	~OpenGLBaseRenderObject();

	string name() {return name_;};
	
	void window(float, float, float, float); 
	OpenGLBox*  window() {return &win_;};	
	float winX() {return win_.x();};
	float winY() {return win_.y();};
	float winWidth() {return win_.width();};
	float winHeight() {return win_.height();};
			
	OpenGLDplItem* addDpl(mglDplType);
	OpenGLDplItem* addPreTransformDpl();
	OpenGLDplItem* addPostTransformDpl();

	OpenGLDplManager& dpl() {return dpl_;};
	OpenGLDplManager& preTransformDpl() {return preTransformDpl_;};
	OpenGLDplManager& postTransformDpl() {return postTransformDpl_;};

	bool checkPointInWindow(float,float);	

protected:		
	string name_;

	OpenGLBox		win_;
	
	OpenGLDplManager	preTransformDpl_;
	OpenGLDplManager	postTransformDpl_;
	OpenGLDplManager	dpl_;	
};

}
#endif
