/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisMinorTickAttributes.h
    \brief Definition of AxisMinorTick Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:40 2011
*/
   

#ifndef AxisMinorTickAttributes_H
#define AxisMinorTickAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class AxisMinorTickAttributes 
{
public:
//  --  constructor
    AxisMinorTickAttributes();
    
//  --  destructor
    virtual ~AxisMinorTickAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisMinorTickAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Colour of minor ticks
    \param colour Setting axis_minor_tick_colour - default=automatic
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Size of minor ticks (cm)
    \param size Setting axis_minor_tick_size - default=0.1
*/
	void setSize(double size) 
		{ size_ =  size; } 
	double getSize() const 
		{ return size_; } 
        
/*!
    Magics Information:
    \brief  Thickness of minor ticks
    \param thickness Setting axis_minor_tick_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	double size_;
	int thickness_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisMinorTickAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
