/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file NoGridPlottingAttributes.h
    \brief Definition of NoGridPlotting Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef NoGridPlottingAttributes_H
#define NoGridPlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class NoGridPlottingAttributes 
{
public:
//  --  constructor
    NoGridPlottingAttributes();
    
//  --  destructor
    virtual ~NoGridPlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NoGridPlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief 
            Reference Latitude from which all latitude lines are drawn
           
    \param latreference Setting map_grid_latitude_reference - default=0
*/
	void setLatReference(double latreference) 
		{ latReference_ =  latreference; } 
	double getLatReference() const 
		{ return latReference_; } 
        
/*!
    Magics Information:
    \brief 
            Interval between latitude grid lines
           
    \param latincrement Setting map_grid_latitude_increment - default=10
*/
	void setLatIncrement(double latincrement) 
		{ latIncrement_ =  latincrement; } 
	double getLatIncrement() const 
		{ return latIncrement_; } 
        
/*!
    Magics Information:
    \brief 
            Reference Longitude from which all longitude lines are drawn
           
    \param lonreference Setting map_grid_longitude_reference - default=0
*/
	void setLonReference(double lonreference) 
		{ lonReference_ =  lonreference; } 
	double getLonReference() const 
		{ return lonReference_; } 
        
/*!
    Magics Information:
    \brief 
            Interval between longitude grid lines
           
    \param lonincrement Setting map_grid_longitude_increment - default=20
*/
	void setLonIncrement(double lonincrement) 
		{ lonIncrement_ =  lonincrement; } 
	double getLonIncrement() const 
		{ return lonIncrement_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double latReference_;
	double latIncrement_;
	double lonReference_;
	double lonIncrement_;

private:
  
	friend ostream& operator<<(ostream& s,const NoGridPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
