/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisMinorTickAttributes.cc
    \brief Implemtation of AxisMinorTick Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "AxisMinorTickAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisMinorTickAttributes::AxisMinorTickAttributes():
	colour_(Translator<string, Colour>().magics("axis_minor_tick_colour")),
	size_(ParameterManager::getDouble("axis_minor_tick_size")),
	thickness_(ParameterManager::getInt("axis_minor_tick_thickness"))
{
} 



AxisMinorTickAttributes::~AxisMinorTickAttributes()
{
}

    
void AxisMinorTickAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_minor_tick";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_minor_tick_colour", colour_, params);
	setAttribute(prefix, "axis_minor_tick_size", size_, params);
	setAttribute(prefix, "axis_minor_tick_thickness", thickness_, params);
}

void AxisMinorTickAttributes::copy(const AxisMinorTickAttributes& other)
{
	setColour(other.colour_->clone());
	size_ = other.size_;
	thickness_ = other.thickness_;
} 


bool AxisMinorTickAttributes::accept(const string& node)
{	
	if ( magCompare(node, "minortick")  )
		return true;
	return false;
}

void AxisMinorTickAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "minortick") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisMinorTickAttributes::print(ostream& out)  const
{
	out << "AxisMinorTickAttributes[";
	out << "colour = " << *colour_;
	out << ", size = " << size_;
	out << ", thickness = " << thickness_;
	out << "]" << "\n";
}


void AxisMinorTickAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_minor_tick_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_minor_tick_size = \'" << size_ << "\'\n";
	out << tab << "\taxis_minor_tick_thickness = \'" << thickness_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_minor_tick_colour("axis_minor_tick_colour", "automatic", " New Magics: Parameter axis_minor_tick_colour sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_minor_tick_size("axis_minor_tick_size", 0.1, " New Magics: Parameter axis_minor_tick_size sent to new Magics[XYSystem].  ");
static MagicsParameter<int> axis_minor_tick_thickness("axis_minor_tick_thickness", 1, " New Magics: Parameter axis_minor_tick_thickness sent to new Magics[XYSystem].  ");
