/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisGridAttributes.cc
    \brief Implemtation of AxisGrid Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "AxisGridAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisGridAttributes::AxisGridAttributes():
	colour_(Translator<string, Colour>().magics("axis_grid_colour")),
	thickness_(ParameterManager::getInt("axis_grid_thickness")),
	style_(Translator<string, LineStyle>().magics("axis_grid_line_style"))
{
} 



AxisGridAttributes::~AxisGridAttributes()
{
}

    
void AxisGridAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_grid";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_grid_colour", colour_, params);
	setAttribute(prefix, "axis_grid_thickness", thickness_, params);
	setAttribute(prefix, "axis_grid_line_style", style_, params);
}

void AxisGridAttributes::copy(const AxisGridAttributes& other)
{
	setColour(other.colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
} 


bool AxisGridAttributes::accept(const string& node)
{	
	if ( magCompare(node, "grid")  )
		return true;
	return false;
}

void AxisGridAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "grid") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisGridAttributes::print(ostream& out)  const
{
	out << "AxisGridAttributes[";
	out << "colour = " << *colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << "]" << "\n";
}


void AxisGridAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_grid_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_grid_thickness = \'" << thickness_ << "\'\n";
	out << tab << "\taxis_grid_line_style = \'" << style_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_grid_colour("axis_grid_colour", "yellow", " New Magics: Parameter axis_grid_colour sent to new Magics[XYSystem].  ");
static MagicsParameter<int> axis_grid_thickness("axis_grid_thickness", 1, " New Magics: Parameter axis_grid_thickness sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_grid_line_style("axis_grid_line_style", "solid", " New Magics: Parameter axis_grid_line_style sent to new Magics[XYSystem].  ");
