
import os
import Magics
import numpy

class Context(object):
	def __init__(self):
		pass

global context
context  = Context()

class Action(object):
	def __init__(self, verb, action, args):
		self.verb = verb
		self.action = action
		self.args = args

	def __repr__(self):
		x = ""
		for key in self.args.keys():
			item = self.args[key]
			x = x + " %s = '%s'\n" % (key, self.args[key])
		return x

	def inspect(self):
		print self

	def tofortran(self):
		for key in self.args.keys():
			item = self.args[key]
			if isinstance(self.args[key], str):
				print "Magics.setc(key, self.args[key])"
			elif isinstance(self.args[key], int):
				print "Magics.seti(key, self.args[key])"
			elif isinstance(self.args[key], float):
				print "Magics.setr(key, self.args[key])"
			elif isinstance(self.args[key], list) :
				if isinstance(self.args[key][0], str):
				   print "Magics.set1c(key, self.args[key])"
				elif isinstance(self.args[key][0], int):
				   print "Magics.set1i(key, numpy.array(self.args[key]))"
				elif isinstance(self.args[key][0], float):
					print "Magics.set1r(key, numpy.array(self.args[key]))"
			else:
				self.args[key].execute(key)

		if self.action != None :
			print "self.action()"


	def execute(self):
		for key in self.args.keys():
			item = self.args[key]
			if isinstance(self.args[key], str):
				Magics.setc(key, self.args[key])
			elif isinstance(self.args[key], int):
				Magics.seti(key, self.args[key])
			elif isinstance(self.args[key], float):
				Magics.setr(key, self.args[key])
			elif isinstance(self.args[key], list) :
				if isinstance(self.args[key][0], str):
				   Magics.set1c(key, self.args[key])
				elif isinstance(self.args[key][0], int):
				   Magics.set1i(key, numpy.array(self.args[key]))
				elif isinstance(self.args[key][0], float):
				   Magics.set1r(key, numpy.array(self.args[key]))
			elif isinstance(self.args[key], numpy.ndarray) :
				if isinstance(self.args[key][0], int):
				   Magics.set1i(key, self.args[key])
				elif isinstance(self.args[key][0], float):
				   Magics.set1r(key, self.args[key])
			else:
				self.args[key].execute(key)

		if self.action != None :
			if self.action != Magics.new_page :
				self.action()
				for key in self.args.keys():
					Magics.reset(key)
			else:
				self.action("page")

def make_action(verb, action):
	def f(_m = None,**kw):
		args = {}
		if _m is not None: 
			args.update(_m)

		return Action(verb, action, args)
		
	return f

pcoast = make_action("pcoast", Magics.coast)
pcont = make_action("pcont", Magics.cont)
psymb = make_action("psymb", Magics.symb)
pgeo = make_action("pgeo", Magics.geo)
pgrib = make_action("pgrib", Magics.grib)
podb = make_action("podb", Magics.odb)
pmap = make_action("pmap", None)
plegend = make_action("plegend", None)
ptext = make_action("ptext", Magics.text)
output = make_action("output", None)
pwind = make_action("pwind", Magics.wind)
page = make_action("page", Magics.new_page)



def inspect(*args):
	for n in args:
		try :
			n.inspect()
		except:
			break


def plot(*args):
	Magics.init()
	for n in args:
		if isinstance(n, list):
			for nn in n:
				nn.execute()
		else:
				n.execute()
	
	#Collect the drivers!
	Magics.finalize()


def tofortran(*args):
	print "Magics.init()"

	for n in args:
		n.tofortran()

	print "Magics.finalize()"
	
	#Collect the drivers!

class  odbfilter(object):
	def __init__(self, _m = None,**kw):
		args = {}
		self.verb = "odbfilter"
		if _m is not None:
			args.update(_m)
		self.args = args
	def execute(self, key):
		file = "data%d" % random.randint(1,1000)
		odb = "%s.odb" % file 
		cmd = "odbsql -q \"" + self.args["odb_sql"] + "\" -i " + self.args["odb_directory"] + " -f newodb -o " + file
		print cmd 
		if (os.system(cmd)) :
			print "Error in filtering ODB data... Aborting"
			os.abort();

		Magics.setc(key, odb)
	def inspect(self):
		cmd = "odbsql -q \"" + self.args["odb_sql"] + "\" -i " + self.args["odb_directory"] + " -o data.ascii"
		if (os.system(cmd)) :
			print "Error in filtering ODB data... Aborting"
			os.abort();
		cmd =  os.environ['ODB_EDITOR'] + " %s" % "data.ascii"
		if (os.system(cmd)) :
			print "Error in viewing ODB data... Aborting"
			os.abort();




