/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file IsoHighlight.h
    \brief Definition of the Template class IsoHighlight.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 25-Aug-2004
    
    Changes:
    
*/

#ifndef IsoHighlight_H
#define IsoHighlight_H

#include "magics.h"

#include "IsoHighlightAttributes.h"
#include "Factory.h"
#include "Translator.h"
#include "Polyline.h"
#include "LevelSelection.h"

namespace magics {


class IsoHighlight: public map<double, double>, public IsoHighlightAttributes {

public:
	IsoHighlight() {}
	virtual ~IsoHighlight() {}
	virtual IsoHighlight* clone() const {
    	IsoHighlight* plot = new IsoHighlight();
    	plot->copy(*this);
    	return plot;
    }
    virtual void set(const map<string, string>& map ) { IsoHighlightAttributes::set(map); }
    virtual void set(const XmlNode& node ) { IsoHighlightAttributes::set(node); }
    virtual void prepare(const LevelSelection& levels) 
    { 
        int high = 0;
        // first the refrence level is not in the list!
        bool ref = false;
        
        for (LevelSelection::const_iterator level = levels.begin(); level != levels.end(); ++level)
        	if (*level == reference_ ) {
        		ref = true;
        		break;
        	}
        if (!ref) {
        	for (LevelSelection::const_iterator level = levels.begin(); level != levels.end(); ++level) {
        		if (high++ == 0) {
        			(*this)[*level] = *level;
        		}
        		if (high == frequency_) high = 0;
        	}
        }
        else {
        	for (LevelSelection::const_iterator level = levels.begin(); level != levels.end(); ++level) {
                if (*level < reference_) continue;	
        		if (high++ == 0) {
                			(*this)[*level] = *level;
                		}
                		if (high == frequency_) high = 0;
             }
        	high = 1;
        	for (LevelSelection::const_reverse_iterator level = levels.rbegin(); level != levels.rend(); ++level) {
        	                if (*level >= reference_) continue;	
        	        		if (high++ == 0) {
        	                			(*this)[*level] = *level;
        	                		}
        	                		if (high == frequency_) high = 0;
        	   }
        }
           

    }
    
    virtual void operator()(Polyline& poly) {
    	if (poly.empty()) return;
        PaperPoint point = poly.back();
        //Log::dev() << "HIGHTLIGHT?--->" << point << "=" << point.value() << "\n";
        const_iterator high = find(poly.back().value());
        if ( high == end() ) return;
        poly.setColour(*colour_);
        poly.setLineStyle(style_);
        //Log::dev() << "set--->" << thickness_ << "\n";
        poly.setThickness(thickness_);
    }
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const {}

private:
    //! Copy constructor - No copy allowed
	IsoHighlight(const IsoHighlight&);
    //! Overloaded << operator to copy - No copy allowed
	IsoHighlight& operator=(const IsoHighlight&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const IsoHighlight& p)
		{ p.print(s); return s; }

};

class NoIsoHighlight: public IsoHighlight {

public:
	NoIsoHighlight() {}
	virtual ~NoIsoHighlight() {}
	virtual IsoHighlight* clone() const {
    	IsoHighlight* plot = new NoIsoHighlight();
    	return plot;
    }
    void set(const map<string, string>&) {}
    virtual void prepare(const LevelSelection&) {} 
  
    
    virtual void operator()(Polyline&) {}
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const {}

private:
    //! Copy constructor - No copy allowed
	NoIsoHighlight(const NoIsoHighlight&);
    //! Overloaded << operator to copy - No copy allowed
	NoIsoHighlight& operator=(const NoIsoHighlight&);
  
};

template<>
class Translator<string, IsoHighlight> { 
public:
	IsoHighlight* operator()(const string& val ) {
		 return SimpleObjectMaker<IsoHighlight>::create(val);
	}     
    IsoHighlight* magics(const string& param)
    {
        IsoHighlight* object;
		ParameterManager::update(param, object);
		return object;
    }
};

} // namespace magics
#endif
