/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file OdaDecoder.h
    \brief Definition of the Template class OdaDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Fri 16-Jan-2004
    
    Changes:
    
*/

#ifndef OdaDecoder_H
#define OdaDecoder_H

#include "magics.h"

#include "OdaDecoderAttributes.h"
#include "../common/Decoder.h"
#include "Data.h"
#include "GeoPoint.h"


namespace magics {


class OdaException : public MagicsException
{
public:
	 OdaException( const string& why ):
		MagicsException("Oda Exception :  " + why ) {}
};  

class OdaDecoder: public OdaDecoderAttributes, 
                  public Decoder, 
                  public Data<GeoPoint>, 
                  public PointsList<GeoPoint>
{

public:
	OdaDecoder();
	virtual ~OdaDecoder();
    
    //! Decoder interface
    virtual void decode(const Transformation&);
    virtual void decode() {}
    virtual void set(const map<string, string>& map ) { OdaDecoderAttributes::set(map); }
    virtual void set(const XmlNode& node ) { OdaDecoderAttributes::set(node); }
    
   PointsHandler<GeoPoint>& points(const Transformation& transformation) { 
    	decode(transformation);
    	pointsHandlers_.push_back(new PointsHandler<GeoPoint>(*this));
    	return *(pointsHandlers_.back());
    } 
    void customisedPoints(const Transformation&, const std::set<string>&, CustomisedPointsList& ); 
    void customisedPoints(const std::set<string>&, CustomisedPointsList&);
    // implements Automatic title
    void visit(TextVisitor&);

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	 vector<double> statistics_;
    

private:
    //! Copy constructor - No copy allowed
	OdaDecoder(const OdaDecoder&);
    //! Overloaded << operator to copy - No copy allowed
	OdaDecoder& operator=(const OdaDecoder&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const OdaDecoder& p)
		{ p.print(s); return s; }

};

} // namespace magics

#endif
