/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.DOMBuilder;
import com.jclark.xsl.dom.DOMExtensions;
import com.jclark.xsl.dom.NodeBase;
import com.jclark.xsl.dom.RootNode;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLProcessorImpl
implements XMLProcessorEx,
DOMExtensions {
    private ErrorHandler errorHandler;

    public Node load(URL url, int documentIndex, LoadContext context, NameTable nameTable) throws IOException, XSLException {
        return this.load(new InputSource(url.toString()), documentIndex, context, nameTable);
    }

    public Node load(InputSource source, int documentIndex, LoadContext context, NameTable nameTable) throws IOException, XSLException {
        try {
            Document doc = this.load(source);
            return new RootNode(doc, this, context, nameTable, source.getSystemId(), documentIndex);
        }
        catch (SAXParseException e) {
            throw new XSLException(e);
        }
        catch (SAXException e) {
            Exception wrapped = e.getException();
            if (wrapped == null) {
                throw new XSLException(e.getMessage());
            }
            if (wrapped instanceof XSLException) {
                throw (XSLException)e.getException();
            }
            throw new XSLException(wrapped);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public abstract Document load(InputSource var1) throws IOException, SAXException;

    public Element getElementById(Document doc, String str) {
        return null;
    }

    public Result createResult(Node baseNode, int documentIndex, LoadContext loadContext, Node[] rootNodeRef) throws XSLException {
        if (baseNode == null) {
            throw new XSLException("cannot convert result tree fragment returned by extension function to a node-set with the DOM");
        }
        RootNode root = ((NodeBase)baseNode).root;
        DocumentFragment docFrag = root.ownerDocument.createDocumentFragment();
        String base = null;
        URL baseURL = baseNode.getURL();
        if (baseURL != null) {
            base = baseURL.toString();
        }
        rootNodeRef[0] = new RootNode(docFrag, this, loadContext, baseNode.getNamespacePrefixMap().getNameTable(), base, documentIndex);
        return new MultiNamespaceResult(new DOMBuilder(docFrag), this.errorHandler);
    }
}

