#!/bin/sh

PERL=$(which perl)
MAKE=$(which make)
PERL5LIB="$DESTDIR/usr/share/perl5/"
PERL="$PERL -I$PERL5LIB"

echo "=========================================================================="
echo "Make $1"
echo "PERL5LIB = $PERL5LIB"
echo "DESTDIR = $DESTDIR"
echo "=========================================================================="

if [ "$1" = "check" ]; then
    if [ -f runtests ]; then
        if [ "$(dpkg-parsechangelog  | awk '/^Distribution: /{print $2}')" != "UNRELEASED" ]; then
            echo "Do not release this package with runtests"
            exit 1
        fi
        for i in $(grep X-Test-Requires: debian/control  | cut -d: -f2- | sed -e 's/^ //' -e 's/,//g'); do perl -M$i -e '' 2>/dev/null >/dev/null || { echo "Missing: $i, install $(echo $i | awk '{print tolower($0);}' | sed -e 's/^/lib/' -e 's/$/-perl/' -e 's/::/-/g') or package it"; exit 1; }; done
    fi
fi

#--- unpacking tar.gz in proper folders
if [ "$1" = "unpack" ]; then
    test -d build-area || mkdir build-area
    
    cd tarballs
    for dir in *
    do
    	if [ -d $dir ]; then
    		cd $dir
			for file in *.tar.gz
			do 
				test -d ../../build-area/$dir || mkdir ../../build-area/$dir
				tar -C ../../build-area/$dir -xzf $file
			done
			cd ..
		fi
    done
    cd ..
fi

if [ ! -f runtests ]; then
    if [ -z "$DEB_BUILD_OPTIONS" ]; then
        DEB_BUILD_OPTIONS=nocheck
    else
        DEB_BUILD_OPTIONS="$DEB_BUILD_OPTIONS nocheck"
    fi
    export DEB_BUILD_OPTIONS
fi

if [ "$1" = "configure" -o "$1" = "install" -o "$1" = "test" -o "$1" = "build" ]; then
	cd build-area
	for dir in *
	do
		if [ -d $dir ]; then
    		cd $dir
			for module in *
			do 
				cd $module
                                ln -sf ../../../debian
                                dh_auto_$1 || exit 1
                                rm debian
				cd ..
			done
			cd ..
		fi
	done
cd ..
fi
