/* Hey EMACS -*- linux-c -*- */
/* $Id: keys83p.h 1179 2005-06-06 14:42:32Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2005  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TICALCS_KEYS83__
#define __TICALCS_KEYS83__

// Scan codes of the TI83 (thanks to B. Moody)

#define KEY83_Right            01
#define KEY83_Left             02
#define KEY83_Up               03
#define KEY83_Down             04
#define KEY83_Enter            05
#define KEY83_AlphaEnter       06
#define KEY83_AlphaUp          07
#define KEY83_AlphaDown        08
#define KEY83_Clear            09
#define KEY83_Del              0A
#define KEY83_Ins              0B
#define KEY83_Recall           0C
#define KEY83_LastEnt          0D
#define KEY83_BOL              0E
#define KEY83_EOL              0F
#define KEY83_SelAll           10
#define KEY83_UnselAll         11
#define KEY83_LtoTI82          12
#define KEY83_Backup           13
#define KEY83_Recieve          14
#define KEY83_LnkQuit          15
#define KEY83_Trans            16
#define KEY83_Rename           17
#define KEY83_Overw            18
#define KEY83_Omit             19
#define KEY83_Cont             1A
#define KEY83_SendID           1B
#define KEY83_SendSW           1C
#define KEY83_Yes              1D
#define KEY83_NoWay            1E
#define KEY83_vSendType        1F
#define KEY83_OverWAll         20
#define KEY83_No               25
#define KEY83_KReset           26
#define KEY83_App              27
#define KEY83_Doug             28
#define KEY83_Listflag         29
#define KEY83_AreYouSure       2B
#define KEY83_AppsMenu         2C
#define KEY83_Prgm             2D
#define KEY83_Zoom             2E
#define KEY83_Draw             2F
#define KEY83_SPlot            30
#define KEY83_Stat             31
#define KEY83_Math             32
#define KEY83_Test             33
#define KEY83_Char             34
#define KEY83_Vars             35
#define KEY83_Mem              36
#define KEY83_Matrix           37
#define KEY83_Dist             38
#define KEY83_Angle            39
#define KEY83_List             3A
#define KEY83_Calc             3B
#define KEY83_Fin              3C
#define KEY83_Catalog          3E
#define KEY83_Off              3F
#define KEY83_Quit             40
#define KEY83_LinkIO           41
#define KEY83_MatrixEd         42
#define KEY83_StatEd           43
#define KEY83_Graph            44
#define KEY83_Mode             45
#define KEY83_PrgmEd           46
#define KEY83_PrgmCr           47
#define KEY83_Window           48
#define KEY83_Yequ             49
#define KEY83_Table            4A
#define KEY83_TblSet           4B
#define KEY83_ChkRAM           4C
#define KEY83_DelMem           4D
#define KEY83_ResetMem         4E
#define KEY83_ResetDef         4F
#define KEY83_PrgmInput        50
#define KEY83_ZFactEd          51
#define KEY83_Error            52
#define KEY83_SolveTVM         53
#define KEY83_SolveRoot        54
#define KEY83_StatP            55
#define KEY83_InfStat          56
#define KEY83_Format           57
#define KEY83_ExtApps          58
#define KEY83_NewApps          59
#define KEY83_Trace            5A
#define KEY83_ZFit             5B
#define KEY83_ZIn              5C
#define KEY83_ZOut             5D
#define KEY83_ZPrev            5E
#define KEY83_Box              5F
#define KEY83_Decml            60
#define KEY83_SetZm            61
#define KEY83_Squar            62
#define KEY83_Std              63
#define KEY83_Trig             64
#define KEY83_UsrZm            65
#define KEY83_ZSto             66
#define KEY83_ZInt             67
#define KEY83_ZStat            68
#define KEY83_Select           69
#define KEY83_Circl            6A
#define KEY83_ClDrw            6B
#define KEY83_Line             6C
#define KEY83_Pen              6D
#define KEY83_PtChg            6E
#define KEY83_PtOff            6F
#define KEY83_PtOn             70
#define KEY83_Vert             71
#define KEY83_Horiz            72
#define KEY83_Text             73
#define KEY83_TanLn            74
#define KEY83_Eval             75
#define KEY83_Inters           76
#define KEY83_DYDX             77
#define KEY83_FnIntg           78
#define KEY83_RootG            79
#define KEY83_DYDT             7A
#define KEY83_DXDT             7B
#define KEY83_DRDo             7C
#define KEY83_GFMin            7D
#define KEY83_GFMax            7E
#define KEY83_ListName         7F
#define KEY83_Add              80
#define KEY83_Sub              81
#define KEY83_Mul              82
#define KEY83_Div              83
#define KEY83_Expon            84
#define KEY83_LParen           85
#define KEY83_RParen           86
#define KEY83_LBrack           87
#define KEY83_RBrack           88
#define KEY83_Shade            89
#define KEY83_Store            8A
#define KEY83_Comma            8B
#define KEY83_Chs              8C
#define KEY83_DecPnt           8D
#define KEY83_0                8E
#define KEY83_1                8F
#define KEY83_2                90
#define KEY83_3                91
#define KEY83_4                92
#define KEY83_5                93
#define KEY83_6                94
#define KEY83_7                95
#define KEY83_8                96
#define KEY83_9                97
#define KEY83_EE               98
#define KEY83_Space            99
#define KEY83_CapA             9A
#define KEY83_CapB             9B
#define KEY83_CapC             9C
#define KEY83_CapD             9D
#define KEY83_CapE             9E
#define KEY83_CapF             9F
#define KEY83_CapG             A0
#define KEY83_CapH             A1
#define KEY83_CapI             A2
#define KEY83_CapJ             A3
#define KEY83_CapK             A4
#define KEY83_CapL             A5
#define KEY83_CapM             A6
#define KEY83_CapN             A7
#define KEY83_CapO             A8
#define KEY83_CapP             A9
#define KEY83_CapQ             AA
#define KEY83_CapR             AB
#define KEY83_CapS             AC
#define KEY83_CapT             AD
#define KEY83_CapU             AE
#define KEY83_CapV             AF
#define KEY83_CapW             B0
#define KEY83_CapX             B1
#define KEY83_CapY             B2
#define KEY83_CapZ             B3
#define KEY83_Varx             B4
#define KEY83_Pi               B5
#define KEY83_Inv              B6
#define KEY83_Sin              B7
#define KEY83_ASin             B8
#define KEY83_Cos              B9
#define KEY83_ACos             BA
#define KEY83_Tan              BB
#define KEY83_ATan             BC
#define KEY83_Square           BD
#define KEY83_Sqrt             BE
#define KEY83_Ln               BF
#define KEY83_Exp              C0
#define KEY83_Log              C1
#define KEY83_ALog             C2
#define KEY83_ToABC            C3
#define KEY83_ClrTbl           C4
#define KEY83_Ans              C5
#define KEY83_Colon            C6
#define KEY83_NDeriv           C7
#define KEY83_FnInt            C8
#define KEY83_Root             C9
#define KEY83_Quest            CA
#define KEY83_Quote            CB
#define KEY83_Theta            CC
#define KEY83_If               CD
#define KEY83_Then             CE
#define KEY83_Else             CF
#define KEY83_For              D0
#define KEY83_While            D1
#define KEY83_Repeat           D2
#define KEY83_End              D3
#define KEY83_Pause            D4
#define KEY83_Lbl              D5
#define KEY83_Goto             D6
#define KEY83_ISG              D7
#define KEY83_DSL              D8
#define KEY83_Menu             D9
#define KEY83_Exec             DA
#define KEY83_Return           DB
#define KEY83_Stop             DC
#define KEY83_Input            DD
#define KEY83_Prompt           DE
#define KEY83_Disp             DF
#define KEY83_DispG            E0
#define KEY83_DispT            E1
#define KEY83_Output           E2
#define KEY83_GetKey           E3
#define KEY83_ClrHome          E4
#define KEY83_PrtScr           E5
#define KEY83_SinH             E6
#define KEY83_CosH             E7
#define KEY83_TanH             E8
#define KEY83_ASinH            E9
#define KEY83_ACosH            EA
#define KEY83_ATanH            EB
#define KEY83_LBrace           EC
#define KEY83_RBrace           ED
#define KEY83_I                EE
#define KEY83_CONSTeA          EF
#define KEY83_Plot3            F0
#define KEY83_FMin             F1
#define KEY83_FMax             F2
#define KEY83_L1A              F3
#define KEY83_L2A              F4
#define KEY83_L3A              F5
#define KEY83_L4A              F6
#define KEY83_L5A              F7
#define KEY83_L6A              F8
#define KEY83_unA              F9
#define KEY83_vnA              FA
#define KEY83_wnA              FB

// FE (ExtendEcho) prefixed keys:

#define KEY83_DrawInv          fe00
#define KEY83_DrawF            fe01
#define KEY83_PixelOn          fe02
#define KEY83_PixelOff         fe03
#define KEY83_PxlTest          fe04
#define KEY83_RCGDB            fe05
#define KEY83_RCPic            fe06
#define KEY83_STGDB            fe07
#define KEY83_STPic            fe08
#define KEY83_Abs              fe09
#define KEY83_TEqu             fe0a
#define KEY83_TNoteQ           fe0b
#define KEY83_TGT              fe0c
#define KEY83_TGTE             fe0d
#define KEY83_TLT              fe0e
#define KEY83_TLTE             fe0f
#define KEY83_And              fe10
#define KEY83_Or               fe11
#define KEY83_Xor              fe12
#define KEY83_Not              fe13
#define KEY83_LR1              fe14
#define KEY83_XRoot            fe15
#define KEY83_Cube             fe16
#define KEY83_CbRt             fe17
#define KEY83_ToDec            fe18
#define KEY83_CubicR           fe19
#define KEY83_QuartR           fe1a
#define KEY83_Plot1            fe1b
#define KEY83_Plot2            fe1c
#define KEY83_Round            fe1d
#define KEY83_IPart            fe1e
#define KEY83_FPart            fe1f
#define KEY83_Int              fe20
#define KEY83_Rand             fe21
#define KEY83_NPR              fe22
#define KEY83_NCR              fe23
#define KEY83_XFactorial       fe24
#define KEY83_Rad              fe25
#define KEY83_Degr             fe26
#define KEY83_APost            fe27
#define KEY83_ToDMS            fe28
#define KEY83_RToPo            fe29
#define KEY83_RToPr            fe2a
#define KEY83_PToRx            fe2b
#define KEY83_PToRy            fe2c
#define KEY83_RowSwap          fe2d
#define KEY83_RowPlus          fe2e
#define KEY83_TimRow           fe2f
#define KEY83_TRowP            fe30
#define KEY83_SortA            fe31
#define KEY83_SortD            fe32
#define KEY83_Seq              fe33
#define KEY83_Min              fe34
#define KEY83_Max              fe35
#define KEY83_Mean             fe36
#define KEY83_Median           fe37
#define KEY83_Sum              fe38
#define KEY83_Prod             fe39
#define KEY83_Det              fe3a
#define KEY83_Transp           fe3b
#define KEY83_Dim              fe3c
#define KEY83_Fill             fe3d
#define KEY83_Ident            fe3e
#define KEY83_Randm            fe3f
#define KEY83_Aug              fe40
#define KEY83_OneVar           fe41
#define KEY83_TwoVar           fe42
#define KEY83_LR               fe43
#define KEY83_LRExp            fe44
#define KEY83_LRLn             fe45
#define KEY83_LRPwr            fe46
#define KEY83_MedMed           fe47
#define KEY83_Quad             fe48
#define KEY83_ClrLst           fe49
#define KEY83_Hist             fe4a
#define KEY83_xyLine           fe4b
#define KEY83_Scatter          fe4c
#define KEY83_mRad             fe4d
#define KEY83_mDeg             fe4e
#define KEY83_mNormF           fe4f
#define KEY83_mSci             fe50
#define KEY83_mEng             fe51
#define KEY83_mFloat           fe52
#define KEY83_Fix              fe53
#define KEY83_SplitOn          fe54
#define KEY83_FullScreen       fe55
#define KEY83_Stndrd           fe56
#define KEY83_Param            fe57
#define KEY83_Polar            fe58
#define KEY83_SeqG             fe59
#define KEY83_AFillOn          fe5a
#define KEY83_AFillOff         fe5b
#define KEY83_ACalcOn          fe5c
#define KEY83_ACalcOff         fe5d
#define KEY83_FNOn             fe5e
#define KEY83_FNOff            fe5f
#define KEY83_PlotsOn          fe60
#define KEY83_PlotsOff         fe61
#define KEY83_PixelChg         fe62
#define KEY83_SendMBL          fe63
#define KEY83_RecvMBL          fe64
#define KEY83_BoxPlot          fe65
#define KEY83_BoxIcon          fe66
#define KEY83_CrossIcon        fe67
#define KEY83_DotIcon          fe68
#define KEY83_Seqential        fe69
#define KEY83_SimulG           fe6a
#define KEY83_PolarG           fe6b
#define KEY83_RectG            fe6c
#define KEY83_CoordOn          fe6d
#define KEY83_CoordOff         fe6e
#define KEY83_DrawLine         fe6f
#define KEY83_DrawDot          fe70
#define KEY83_AxisOn           fe71
#define KEY83_AxisOff          fe72
#define KEY83_GridOn           fe73
#define KEY83_GridOff          fe74
#define KEY83_LblOn            fe75
#define KEY83_LblOff           fe76
#define KEY83_L1               fe77
#define KEY83_infData          fe77
#define KEY83_L2               fe78
#define KEY83_infStats         fe78
#define KEY83_L3               fe79
#define KEY83_infYes           fe79
#define KEY83_L4               fe7a
#define KEY83_infNo            fe7a
#define KEY83_L5               fe7b
#define KEY83_infCalc          fe7b
#define KEY83_L6               fe7c
#define KEY83_infDraw          fe7c
#define KEY83_MatA             fe7d
#define KEY83_infAlt1ne        fe7d
#define KEY83_MatB             fe7e
#define KEY83_infAlt1lt        fe7e
#define KEY83_MatC             fe7f
#define KEY83_infAlt1gt        fe7f
#define KEY83_MatD             fe80
#define KEY83_infAlt2ne        fe80
#define KEY83_MatE             fe81
#define KEY83_infAlt2lt        fe81
#define KEY83_Xmin             fe82
#define KEY83_infAlt2gt        fe82
#define KEY83_Xmax             fe83
#define KEY83_infAlt3ne        fe83
#define KEY83_Xscl             fe84
#define KEY83_infAlt3lt        fe84
#define KEY83_Ymin             fe85
#define KEY83_infAlt3gt        fe85
#define KEY83_Ymax             fe86
#define KEY83_infAlt4ne        fe86
#define KEY83_Yscl             fe87
#define KEY83_infAlt4lt        fe87
#define KEY83_Tmin             fe88
#define KEY83_infAlt4gt        fe88
#define KEY83_Tmax             fe89
#define KEY83_infAlt5ne        fe89
#define KEY83_TStep            fe8a
#define KEY83_infAlt5lt        fe8a
#define KEY83_Omin             fe8b
#define KEY83_infAlt5gt        fe8b
#define KEY83_Omax             fe8c
#define KEY83_infAlt6ne        fe8c
#define KEY83_OStep            fe8d
#define KEY83_infAlt6lt        fe8d
#define KEY83_infAlt6gt        fe8e
#define KEY83_u0               fe8e
#define KEY83_v0               fe8f
#define KEY83_nMin             fe90
#define KEY83_nMax             fe91
#define KEY83_DeltaY           fe92
#define KEY83_DeltaX           fe93
#define KEY83_ZXmin            fe94
#define KEY83_ZXmax            fe95
#define KEY83_ZXscl            fe96
#define KEY83_ZYmin            fe97
#define KEY83_ZYmax            fe98
#define KEY83_ZYscl            fe99
#define KEY83_ZTmin            fe9a
#define KEY83_ZTmax            fe9b
#define KEY83_ZTStep           fe9c
#define KEY83_ZOmin            fe9d
#define KEY83_ZOmax            fe9e
#define KEY83_ZOStep           fe9f
#define KEY83_Zu0              fea0
#define KEY83_Zv0              fea1
#define KEY83_ZnMin            fea2
#define KEY83_ZnMax            fea3
#define KEY83_DelLast          fea4
#define KEY83_SinReg           fea5
#define KEY83_ConstE           fea6
#define KEY83_Pic1             fea7
#define KEY83_Pic2             fea8
#define KEY83_Pic3             fea9
#define KEY83_DelVar           feaa
#define KEY83_GetCalc          feab
#define KEY83_RealM            feac
#define KEY83_PolarM           fead
#define KEY83_RectM            feae
#define KEY83_uv               feaf
#define KEY83_vw               feb0
#define KEY83_uw               feb1
#define KEY83_FinPMTend        feb2
#define KEY83_FinPMTbeg        feb3
#define KEY83_GraphStyle       feb4
#define KEY83_ExprOn           feb5
#define KEY83_ExprOff          feb6
#define KEY83_StatA            feb7
#define KEY83_StatB            feb8
#define KEY83_StatC            feb9
#define KEY83_Corr             feba
#define KEY83_StatD            febb
#define KEY83_StatE            febc
#define KEY83_RegEq            febd
#define KEY83_MinX             febe
#define KEY83_Q1               febf
#define KEY83_MD               fec0
#define KEY83_Q3               fec1
#define KEY83_MaxX             fec2
#define KEY83_StatX1           fec3
#define KEY83_StatY1           fec4
#define KEY83_StatX2           fec5
#define KEY83_StatY2           fec6
#define KEY83_StatX3           fec7
#define KEY83_StatY3           fec8
#define KEY83_TblMin           fec9
#define KEY83_TblStep          feca
#define KEY83_SetupLst         fecb
#define KEY83_ClrAllLst        fecc
#define KEY83_Logistic         fecd
#define KEY83_ZTest            fece
#define KEY83_TTest            fecf
#define KEY83_2SampZTest       fed0
#define KEY83_2SampTTest       fed1
#define KEY83_1PropZTest       fed2
#define KEY83_2PropZTest       fed3
#define KEY83_ChiTest          fed4
#define KEY83_2SampFTest       fed5
#define KEY83_ZIntVal          fed6
#define KEY83_TIntVal          fed7
#define KEY83_2SampTInt        fed8
#define KEY83_2SampZInt        fed9
#define KEY83_1PropZInt        feda
#define KEY83_2PropZInt        fedb
#define KEY83_DNormal          fedc
#define KEY83_InvNorm          fedd
#define KEY83_DT               fede
#define KEY83_Chi              fedf
#define KEY83_DF               fee0
#define KEY83_BinPDF           fee1
#define KEY83_BinCDF           fee2
#define KEY83_PoiPDF           fee3
#define KEY83_PoiCDF           fee4
#define KEY83_un               fee5
#define KEY83_vn               fee6
#define KEY83_wn               fee7
#define KEY83_Recn             fee8
#define KEY83_PlotStart        fee9
#define KEY83_ZPlotStart       feea
#define KEY83_XFact            feeb
#define KEY83_YFact            feec
#define KEY83_ANOVA            feed
#define KEY83_MaxY             feee
#define KEY83_WebOn            feef
#define KEY83_WebOff           fef0
#define KEY83_TblInput         fef1
#define KEY83_GeoPDF           fef2
#define KEY83_GeoCDF           fef3
#define KEY83_ShadeNorm        fef4
#define KEY83_ShadeT           fef5
#define KEY83_ShadeChi         fef6
#define KEY83_ShadeF           fef7
#define KEY83_PlotStep         fef8
#define KEY83_ZPlotStep        fef9
#define KEY83_LinRegtTest      fefa
#define KEY83_MGT              fefb
#define KEY83_SelectA          fefc
#define KEY83_ZFitA            fefd

// FC (ExtendEcho2) prefixed keys:

#define KEY83_GDB1             fc00
#define KEY83_GDB2             fc01
#define KEY83_GDB3             fc02
#define KEY83_Y1               fc03
#define KEY83_Y2               fc04
#define KEY83_Y3               fc05
#define KEY83_Y4               fc06
#define KEY83_Y5               fc07
#define KEY83_Y6               fc08
#define KEY83_Y7               fc09
#define KEY83_Y8               fc0a
#define KEY83_Y9               fc0b
#define KEY83_Y0               fc0c
#define KEY83_X1T              fc0d
#define KEY83_Y1T              fc0e
#define KEY83_X2T              fc0f
#define KEY83_Y2T              fc10
#define KEY83_X3T              fc11
#define KEY83_Y3T              fc12
#define KEY83_X4T              fc13
#define KEY83_Y4T              fc14
#define KEY83_X5T              fc15
#define KEY83_Y5T              fc16
#define KEY83_X6T              fc17
#define KEY83_Y6T              fc18
#define KEY83_R1               fc19
#define KEY83_R2               fc1a
#define KEY83_R3               fc1b
#define KEY83_R4               fc1c
#define KEY83_R5               fc1d
#define KEY83_R6               fc1e
#define KEY83_GDB4             fc1f
#define KEY83_GDB5             fc20
#define KEY83_GDB6             fc21
#define KEY83_Pic4             fc22
#define KEY83_Pic5             fc23
#define KEY83_Pic6             fc24
#define KEY83_GDB7             fc25
#define KEY83_GDB8             fc26
#define KEY83_GDB9             fc27
#define KEY83_GDB0             fc28
#define KEY83_Pic7             fc29
#define KEY83_Pic8             fc2a
#define KEY83_Pic9             fc2b
#define KEY83_Pic0             fc2c
#define KEY83_StatN            fc2d
#define KEY83_XMean            fc2e
#define KEY83_Conj             fc2f
#define KEY83_Real             fc30
#define KEY83_FAngle           fc31
#define KEY83_LCM              fc32
#define KEY83_GCD              fc33
#define KEY83_RandInt          fc34
#define KEY83_RandNorm         fc35
#define KEY83_ToPolar          fc36
#define KEY83_ToRect           fc37
#define KEY83_YMean            fc38
#define KEY83_StdX             fc39
#define KEY83_StdX1            fc3a
#define KEY83_w0               fc3b
#define KEY83_MatF             fc3c
#define KEY83_MatG             fc3d
#define KEY83_MatRH            fc3e
#define KEY83_MatI             fc3f
#define KEY83_MatJ             fc40
#define KEY83_YMean1           fc41
#define KEY83_StdY             fc42
#define KEY83_StdY1            fc43
#define KEY83_MatToLst         fc44
#define KEY83_LstToMat         fc45
#define KEY83_CumSum           fc46
#define KEY83_DeltaLst         fc47
#define KEY83_StdDev           fc48
#define KEY83_Variance         fc49
#define KEY83_Length           fc4a
#define KEY83_EquToStrng       fc4b
#define KEY83_StrngToEqu       fc4c
#define KEY83_Expr             fc4d
#define KEY83_SubStrng         fc4e
#define KEY83_InStrng          fc4f
#define KEY83_Str1             fc50
#define KEY83_Str2             fc51
#define KEY83_Str3             fc52
#define KEY83_Str4             fc53
#define KEY83_Str5             fc54
#define KEY83_Str6             fc55
#define KEY83_Str7             fc56
#define KEY83_Str8             fc57
#define KEY83_Str9             fc58
#define KEY83_Str0             fc59
#define KEY83_FinN             fc5a
#define KEY83_FinI             fc5b
#define KEY83_FinPV            fc5c
#define KEY83_FinPMT           fc5d
#define KEY83_FinFV            fc5e
#define KEY83_FinPY            fc5f
#define KEY83_FinCY            fc60
#define KEY83_FinFPMT          fc61
#define KEY83_FinFI            fc62
#define KEY83_FinFPV           fc63
#define KEY83_FinFN            fc64
#define KEY83_FinFFV           fc65
#define KEY83_FinNPV           fc66
#define KEY83_FinIRR           fc67
#define KEY83_FinBAL           fc68
#define KEY83_FinPRN           fc69
#define KEY83_FinINT           fc6a
#define KEY83_SumX             fc6b
#define KEY83_SumX2            fc6c
#define KEY83_FinToNom         fc6d
#define KEY83_FinToEff         fc6e
#define KEY83_FinDBD           fc6f
#define KEY83_StatVP           fc70
#define KEY83_StatZ            fc71
#define KEY83_StatT            fc72
#define KEY83_StatChi          fc73
#define KEY83_StatF            fc74
#define KEY83_StatDF           fc75
#define KEY83_StatPhat         fc76
#define KEY83_StatPhat1        fc77
#define KEY83_StatPhat2        fc78
#define KEY83_StatMeanX1       fc79
#define KEY83_StatMeanX2       fc7a
#define KEY83_StatStdX1        fc7b
#define KEY83_StatStdX2        fc7c
#define KEY83_StatStdXP        fc7d
#define KEY83_StatN1           fc7e
#define KEY83_StatN2           fc7f
#define KEY83_StatLower        fc80
#define KEY83_StatUpper        fc81
#define KEY83_uw0              fc82
#define KEY83_Imag             fc83
#define KEY83_SumY             fc84
#define KEY83_Xres             fc85
#define KEY83_Stat_s           fc86
#define KEY83_SumY2            fc87
#define KEY83_SumXY            fc88
#define KEY83_uXres            fc89
#define KEY83_ModBox           fc8a
#define KEY83_NormProb         fc8b
#define KEY83_NormalPDF        fc8c
#define KEY83_TPDF             fc8d
#define KEY83_ChiPDF           fc8e
#define KEY83_FPDF             fc8f
#define KEY83_MinY             fc90
#define KEY83_RandBin          fc91
#define KEY83_Ref              fc92
#define KEY83_RRef             fc93
#define KEY83_LRSqr            fc94
#define KEY83_BRSqr            fc95
#define KEY83_DiagOn           fc96
#define KEY83_DiagOff          fc97
#define KEY83_un1              fc98
#define KEY83_vn1              fc99
 
#endif

