/* Hey EMACS -*- linux-c -*- */
/* $Id: keys83p.c 3175 2007-02-19 17:54:59Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2007  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ticalcs.h"
#include "keys83p.h"

/*
  Conversion of an ASCII code into a TI key
  This table is very incomplete. It contains most of ASCII chars only.
*/
const OldCalcKeys_ TI83P_KEYS[] = 
{
/* 0x00 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"Enter", "Enter", KEY83P_Enter, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x10 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"ESC", "Quit", KEY83P_Quit, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x20 */
  {" ", "Space", KEY83P_Space, "", 0, "", 0, "", 0, "", 0},
  {"!", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"\"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"#", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"$", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"%", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"&", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"'", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"(", "LParen", KEY83P_LParen, "", 0, "", 0, "", 0, "", 0},
  {")", "RParen", KEY83P_RParen, "", 0, "", 0, "", 0, "", 0},
  {"*", "Mul", KEY83P_Mul, "", 0, "", 0, "", 0, "", 0},
  {"+", "Add", KEY83P_Add, "", 0, "", 0, "", 0, "", 0},
  {",", "Comma", KEY83P_Comma, "", 0, "", 0, "", 0, "", 0},
  {"-", "Sub", KEY83P_Sub, "", 0, "", 0, "", 0, "", 0},
  {".", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"/", "Div", KEY83P_Div, "", 0, "", 0, "", 0, "", 0},
/* 0x30 */
  {"0", "0", KEY83P_0, "", 0, "", 0, "", 0, "", 0},
  {"1", "1", KEY83P_1, "", 0, "", 0, "", 0, "", 0},
  {"2", "2", KEY83P_2, "", 0, "", 0, "", 0, "", 0},
  {"3", "3", KEY83P_3, "", 0, "", 0, "", 0, "", 0},
  {"4", "4", KEY83P_4, "", 0, "", 0, "", 0, "", 0},
  {"5", "5", KEY83P_5, "", 0, "", 0, "", 0, "", 0},
  {"6", "6", KEY83P_6, "", 0, "", 0, "", 0, "", 0},
  {"7", "7", KEY83P_7, "", 0, "", 0, "", 0, "", 0},
  {"8", "8", KEY83P_8, "", 0, "", 0, "", 0, "", 0},
  {"9", "9", KEY83P_9, "", 0, "", 0, "", 0, "", 0},
  {":", "", 0, "", 0, "", 0, "", 0, "", 0},
  {";", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"<", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"=", "", 0, "", 0, "", 0, "", 0, "", 0},
  {">", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"?", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x40 */
  {"@", "@", 0, "", 0, "", 0, "", 0, "", 0},
  {"A", "A", KEY83P_CapA, "", 0, "", 0, "", 0, "", 0},
  {"B", "B", KEY83P_CapB, "", 0, "", 0, "", 0, "", 0},
  {"C", "C", KEY83P_CapC, "", 0, "", 0, "", 0, "", 0},
  {"D", "D", KEY83P_CapD, "", 0, "", 0, "", 0, "", 0},
  {"E", "E", KEY83P_CapE, "", 0, "", 0, "", 0, "", 0},
  {"F", "F", KEY83P_CapF, "", 0, "", 0, "", 0, "", 0},
  {"G", "G", KEY83P_CapG, "", 0, "", 0, "", 0, "", 0},
  {"H", "H", KEY83P_CapH, "", 0, "", 0, "", 0, "", 0},
  {"I", "I", KEY83P_CapI, "", 0, "", 0, "", 0, "", 0},
  {"J", "J", KEY83P_CapJ, "", 0, "", 0, "", 0, "", 0},
  {"K", "K", KEY83P_CapK, "", 0, "", 0, "", 0, "", 0},
  {"L", "L", KEY83P_CapL, "", 0, "", 0, "", 0, "", 0},
  {"M", "M", KEY83P_CapM, "", 0, "", 0, "", 0, "", 0},
  {"N", "N", KEY83P_CapN, "", 0, "", 0, "", 0, "", 0},
  {"O", "O", KEY83P_CapO, "", 0, "", 0, "", 0, "", 0},
/* 0x50 */
  {"P", "P", KEY83P_CapP, "", 0, "", 0, "", 0, "", 0},
  {"Q", "Q", KEY83P_CapQ, "", 0, "", 0, "", 0, "", 0},
  {"R", "R", KEY83P_CapR, "", 0, "", 0, "", 0, "", 0},
  {"S", "S", KEY83P_CapS, "", 0, "", 0, "", 0, "", 0},
  {"T", "T", KEY83P_CapT, "", 0, "", 0, "", 0, "", 0},
  {"U", "U", KEY83P_CapU, "", 0, "", 0, "", 0, "", 0},
  {"V", "V", KEY83P_CapV, "", 0, "", 0, "", 0, "", 0},
  {"W", "W", KEY83P_CapW, "", 0, "", 0, "", 0, "", 0},
  {"X", "X", KEY83P_CapX, "", 0, "", 0, "", 0, "", 0},
  {"Y", "Y", KEY83P_CapY, "", 0, "", 0, "", 0, "", 0},
  {"Z", "Z", KEY83P_CapZ, "", 0, "", 0, "", 0, "", 0},
  {"[", "LBrack", KEY83P_LBrack, "", 0, "", 0, "", 0, "", 0},
  {"\\", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"]", "RBrack", KEY83P_RBrack, "", 0, "", 0, "", 0, "", 0},
  {"^", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"_", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x60 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"a", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"b", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"c", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"d", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"e", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"f", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"g", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"h", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"i", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"j", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"k", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"l", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"m", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"n", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"o", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x70 */
  {"p", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"q", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"r", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"s", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"t", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"u", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"v", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"w", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"x", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"y", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"z", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"{", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"|", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"}", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"~", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x80 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"\173", "Ans", KEY83P_Ans, "\173", 173, "ANS", 4372, "", 8365, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x90 */
};
