
// C++ header file partially generated from Ada using cproto.adb

#ifndef CONTROLS_H
#deifne CONTROLS_H

extern "C" {

//----------------------------------------------------------------------------
// CONTROLS - Texttools control (widget) definitions                        --
//                                                                          --
// Developed by Ken O. Burtch                                               --
//----------------------------------------------------------------------------
//                                                                          --
//              Copyright (C) 1999-2001 PegaSoft Canada                     --
//                                                                          --
// This is free software;  you can  redistribute it  and/or modify it under --
// terms of the  GNU General Public License as published  by the Free Soft- --
// ware  Foundation;  either version 2,  or (at your option) any later ver- --
// sion.  This is distributed in the hope that it will be useful, but WITH- --
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
// for  more details.  You should have  received  a copy of the GNU General --
// Public License  distributed with this;  see file COPYING.  If not, write --
// to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
// MA 02111-1307, USA.                                                      --
//                                                                          --
// As a special exception,  if other files  instantiate  generics from this --
// unit, or you link  this unit with other files  to produce an executable, --
// this  unit  does not  by itself cause  the resulting  executable  to  be --
// covered  by the  GNU  General  Public  License.  This exception does not --
// however invalidate  any other reasons why  the executable file  might be --
// covered by the  GNU Public License.                                      --
//                                                                          --
// This is maintained at http://www.vaxxine.com/pegasoft                    --
//                                                                          --
//----------------------------------------------------------------------------


//-> Housekeeping

extern void startup_controls( void );
extern void idle_controls( a_time_stamp idle_period );
extern void shutdown_controls( void );

//-> Window Control Definitions
//
// A control is an object in a window that performs input/output.
// RootControl is the elementary pseudo-control.  All controls
// inherit a frame, internal cursor location, a hot key, and a status.
// There is also a NeedsRedrawing flag which indicates if the control
// dirty.
//
// Controls must support the following subprograms:
// 1. a Hear procedure which handles input and determines how
//    the dialog manager should respond (go to next control, etc.).
// 2. a Draw procedure to draw the control.  (Draw should take into
//    account the NeedsRedrawing flag, need not save colour/styles.)
// 3. an Init procedure to setup the frame, hot key (if any) and to
//    initialize any defaults. (the constructor)
// 4. Encode/Decode to save control info to a file.
// 5. SetStatus for activating the control, etc.
// 6. a Clear procedure to shutdown the control (and deallocate any
//    memory). (the destructor)
//
// All controls inherit:
// 1. an Invalid procedure to force a control to be redrawn (usually
//    when obscured by an overlapping window).
// 2. GetStatus to return the control's status.
// 3. a NeedsRedrawing function to reutnr the NeedsRedrawing flag.
// 4. Free, the unchecked deallocation procedure.
// ...and a few others.  See RootControl below.
//
// Dialog Actions:
//   None - Remain on this control
//   Next - Go to next control
//   Back - Go to control before this one
//   ScanNext - Forward to next control with key as hotkey
//          (the usual result for a key with no meaning for control)
//   Up    - move up to next control
//   Down  - move down to next control
//   Left  - move left to next control
//   Right - move right to next control
//   Complete - this control completes a dialog (simple buttons)
//   FollowLink - follow the link; open a new subwindow
//   Fix Family - turn off/redraw the radio button's family members

enum a_dialog_action {none, next, back, scan_next, up, down, left, right, complete, follow_link, fix_family};

// Control Status:
//   Off       - control will never be selected
//   Standby   - control not currently selected
//   On        - control selected and is accepting input

enum a_control_status {off, standby, on};
typedef str255 a_control_name;

//-> Control Numbers
//
// Maximum number of controls is AControlNumber'Last; 0 = no control #

typedef short a_control_number; // range 0..63

//-> Control Definitions
//
// RootControl, the elementary pseudo-control
//
// GetHotKey - return hot key for this control (or NullKey)
// SetInfo - set info bar text for this control
// GetInfo - return same
// HasInfo - true if info bar text was assigned

class root_control {

protected:
  a_rect frame;                  // frame surrounding control
  a_control_status status;       // Off / Standby / On
  a_control_name name;           // name of the control
  unsigned char stick_left;      // frame.left should adhere to window's left
  unsigned char stick_top;       // frame.top  should adhere to window's top
  unsigned char stick_right;     // frame.right should adhere to w's right
  unsigned char stick_bottom;    // frame.top should adhere to w's bottom
  int cursor_x;                  // cursor location
  int cursor_y;
  unsigned char scrollable;      // true if ScrollWindow should ignore
  unsigned char needs_redrawing; // true if needs redrawing
  char hot_key;                  // key to jump to this item (else NullKey)
  unsigned char has_info;        // true if text is valid for info bar
  str255 info_text;              // string to show in info bar if hilighted

  root_control( int left, int top, int right, int bottom,
    char hot_key );
  ~root_control();

  virtual void hear( root_control *c, an_input_record i, a_dialog_action *d );
  virtual void move( int dx, int dy );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual void draw( void );                                  /* class-wide */
  virtual void set_status( a_control_status status );
  virtual a_control_status get_status( void );                /* class-wide */
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual void invalid( void );                               /* class-wide */
  virtual unsigned char needs_redrawing( void );              /* class-wide */
  virtual char get_hot_key( void );                           /* class-wide */
  virtual void set_info( str255 text );                       /* class-wide */
  virtual str255 get_info( void );                            /* class-wide */
  virtual unsigned char has_info( void );                     /* class-wide */
  virtual void get_stickyness( unsigned char *left, int *top,
     int *right, *int bottom );                               /* class-wide */
  virtual void set_stickyness( unsigned char left, int top,
     int right, int bottom );                                 /* class-wide */
  virtual unsigned char in_control( int x, int y );           /* class-wide */
  virtual a_rect get_frame( void );                           /* class-wide */
  virtual void scrollable( unsigned char b );                 /* class-wide */
  virtual unsigned char can_scroll( void );                   /* class-wide */
  // virtual void free( a_control_ptr *cp );
  virtual make_me_abstract( void ) = 0;
  // fake function to make root control abstract.

};

typedef *root_control a_control_ptr;
// root_control or its child classes pointer

// In Ada, aControlPtr and a pointer to a rootControl are different.  In C++,
// this is just a renaming.

//-> General Classes
//
// All controls fall into one of two classes:
//
// Iconic Controls: controls that represent information or another
//                  (auto) window (if a link is provided)
//                  (eg. a picture, a static line)
//
// Gnat 2.03 bug: Compiler overlaps link with first variable in
// derived class, so links don't work!
//
// Window Controls: controls that change the environment of the current
//                  window; controls whose value can be edited/changed
//                  (eg. a checkbox, an edit list )
//

typedef *an_iconic_control an_iconic_control_ptr;
// an_iconic_control or its child classes pointer

protected:

  an_iconic_control( int left, int top, int right, int bottom,
    char hot_key );
  ~an_iconic_control();

  virtual void draw( void );
  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void set_status( a_control_status status );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual void set_link( str255 link );                       /* class-wide */
  virtual str255 get_link( void );                            /* class-wide */
  virtual void set_close_before_follow( unsigned char close = true );
                                                              /* class-wide */
  virtual unsigned char get_close_before_follow( void );      /* class-wide */

};

typedef *a_window_control a_window_control_ptr;
// a_window_control or its child classes pointer

class a_window_control : root_control {

protected:

  a_window_control( int left, int top, int right, int bottom,
    char hot_key );
  ~a_window_control();

  virtual void draw( void );
  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void set_status( a_control_status status );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  // nothing special for window controls since they can't link to anything

};

//-> Thermometers
//
// SetMax - indicated the value associated with 100%
// GetMax - return same
// SetValue - set the thermometer value (0..Max)
// GetValue - return same

class a_thermometer : a_window_control {

private:

  long max;   // ranges 0..max
  long value; // current value

public:

  a_thermometer( a_thermometer *c, int left, int top, int right,
     int bottom, char hot_key = null_key );
  ~a_thermometer();

  virtual extern void hear( an_input_record i, a_dialog_action *d );
  virtual extern void draw( void );
  virtual extern void resize( int dleft, int dtop, int dright, int dbottom );
  virtual extern void set_status( a_control_status status );
  virtual extern encoded_string encode( void );
  virtual extern void decode( encoded_string *estr );

  virtual extern long get_max( void );
  virtual extern long get_value( void );
  virtual extern void set_max( long max );
  virtual extern void set_value( long value );

};


//-> Scroll Bars
//
// SetMax   - set the value associated with the end of the bar
// GetMax   - return same
// SetThumb - set the position of the thumb (0...Max)
// GetThumb - return same
// SetOwner - indicate the list control associated with this bar
// GetOwner - return same

class a_scroll_bar : a_window_control {
private:

  long max;                          // ranges 0..Max
  long thumb;                        // current position
  a_control_number owner;            // related control (for window manager)

  // optimizations for text screen
  unsigned char dirty_thumb;         // true if only thumb needs redrawing
  int old_thumb;                     // old drawing position for thumb

  a_scroll_bar( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_scroll_bar();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual long get_max( void );
  virtual long get_thumb( void );
  virtual void set_max( long max );
  virtual void set_thumb( long thumb );
  virtual void set_owner( a_control_number owner );
  virtual a_control_number get_owner( void );

};


//-> Static Lines
//
// SetText - set the text of the line
// GetText - return the text of the line
// SetStyle - set the print text of the line
// GetStyle - return the print text of the line

class a_static_line : an_iconic_control {

private:

  str255 text;               // text in the static line
  a_text_style style;        // the style of text (default normal)
  a_pen_colour_name colour;  // colour of text

public:

  a_static_line( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_static_line();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual str255 get_text( void );
  virtual void set_text( str255 text );
  virtual void set_text( char * text );
  virtual a_text_style get_style( void );
  virtual void set_style( a_text_style style );
  virtual a_pen_colour_name get_colour( void );
  virtual void set_colour( void a_pen_colour_name colour );

};


//-> Edit Lines, elementary edit line
//
// SetText - set the text of the edit line
// GetText - return the text of the edit line
// SetAdvanceMode - enable/disable auto advance when line is full
// GetAdvanceMode - return auto advance setting

class an_edit_line : a_window_control {

private:

  str255 text;                 // text in the edit line
  unsigned int max;            // maximum number of characters (not impl. yet)
  unsigned int origin;         // offset for display if text is wider than box
  unsigned char advance_mode;  // auto-advance with last character?
  unsigned char blind_mode;    // true for blind text (eg. password entry)
  int max_length;              // maximum number of characters

// optimzations for text screen
unsigned char dirty_text;    // if only text right of cursor needs drawing

public:

  an_edit_line( int left, int top, int right, int bottom,
    unsighed int max = 0, char hot_key = null_key );
  ~an_edit_line();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
                                                              /* class-wide */
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual str255 get_text( void );                            /* class-wide */
  virtual void set_text( str255 text );                       /* class-wide */
  virtual unsigned char get_advance_mode( void );             /* class-wide */
  virtual void set_advance_mode( unsigned char mode );        /* class-wide */
  virtual unsigned char get_blind_mode( void );               /* class-wide */
  virtual void set_blind_mode( unsigned char mode );          /* class-wide */
  virtual int get_max_length( void );                         /* class-wide */
  virtual void set_max_length( int max_length );              /* class-wide */

};

typedef *an_edit_line some_edit_line; // an_edit_line or its child classes pointer


//-> Integer Edit Lines
//

class an_integer_edit_line : an_edit_line {

private:

  int value;

public:

  an_integer_edit_line( int left, int top, int right, int bottom,
    unsighed int max = 0, char hot_key = null_key );
  // ~an_integer_edit_line();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual void set_value( int value );
  virtual int get_value( void );

};


//-> Long Integer Edit Lines
//

class a_long_int_edit_line : an_edit_line {

private:

  long value;

public:

  a_long_integer_edit_line( int left, int top, int right, int bottom,
    unsigned int max = 0, char hot_key = null_key );
  // ~a_long_integer_edit_line();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual void set_value( long value );
  virtual long get_value( void );

};

//-> Float Edit Lines
//

// forward declaration of private record a_float_edit_line
// you'll need to copy the class here

class a_float_edit_line : an_edit_line {

private:

  float value;

public:

  a_float_edit_line( int left, int top, int right, int bottom,
    unsigned int max = 0, char hot_key = null_key );
  // ~a_float_edit_line();

public:

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual void set_value( float value );
  virtual float get_value( void );

};

//-> Check Boxes
//
// SetText - set the button's message
// GetText - return the button's message
// SetCheck - check/uncheck the button
// GetCheck - return the button's check

class a_check_box : a_window_control {

private:

  str255 text;                                      // message of the button
  unsigned char checked;                            // true if button's checked
  unsigned int hot_pos;                             // 

public:

  a_check_box( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_check_box();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( a_check_box *c, int dleft, int dtop, int dright,
    int dbottom );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual str255 get_text( void );
  virtual unsigned char get_check( void );
  virtual void set_text( str255 text );
  virtual void set_check( unsigned char checked );

};


//-> Radio Buttons
//
// GetText - return the button's message
// SetText - set the button's message
// SetCheck - check/uncheck the radio button
// GetCheck - return the button's check
// GetFamily - the the family number of the radio button

class a_radio_button : a_window_control {

private:

  str255 text;                                // title
  unsigned char checked;                      // true if button is "on"
  int family;                                 // a number to associate families
  unsigned int hot_pos;

public:

  a_radio_button( int left, int top, int right, int bottom,
    int family = 0, char hot_key = null_key );
  ~a_radio_button();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual str255 get_text( void );
  virtual unsigned char get_check( void );
  virtual int get_family( void );
  virtual void set_text( str255 text );
  virtual void set_check( unsigned char checked );

};


//-> Simple Buttons
//
// SetText - set the button's message
// GetText - return the button's message

class a_simple_button : a_window_control {

private:

  str255 text;                      // message of the button
  unsigned char instant;            // true if an instant selection on ScanNext
  unsigned int hot_pos;             // position of hot key character
  a_pen_colour_name colour;

public:

  a_simple_button( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_simple_button();

  extern void hear( an_input_record i, a_dialog_action *d );
  extern void draw( void );
  extern void resize( int dleft, int dtop, int dright, int dbottom );
  extern void set_status( a_control_status status );
  extern encoded_string encode( void );
  extern void decode( encoded_string *estr );

  extern str255 get_text( a_simple_button c );
  extern void set_text( str255 text );
  //extern void set_text( char * text );
  extern unsigned char get_instant( void );
  extern void set_instant( unsigned char instant = true );
  extern a_pen_colour_name get_colour( void );
  extern void set_colour( a_pen_colour_name colour );

};


//-> Window Buttons
//
// SetText - set the button's message
// GetText - return the button's message
// SetLink - set the path to the window associated with this button
// GetLink - return the window path

class a_window_button : an_iconic_control {

private:

  str255 text;                      // message of the button
  unsigned char instant;            // true if an instant selection on ScanNext
  unsigned int hot_pos;             // position of hot key character
  a_control_number chit;            // what was hit

public:

  a_window_button( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_window_button();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );

  virtual void set_text( str255 text );
  virtual str255 get_text( void );
  virtual unsigned char get_instant( void );
  virtual void set_instant( unsigned char instant = true );
  virtual void set_control_hit( a_control_number chit );
  virtual a_control_number get_control_hit( void );

};


//-> Rectangles
//
// SetColours - set the foreground and background colours
// GetColours - return the foreground and background colours

class a_rectangle : an_iconic_control {

private:

  a_pen_colour_name frame_colour;                   // colour of the frame
  a_pen_colour_name back_colour;                    // colour of the background
  str255 text;                                      // ?

  a_rectangle( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_rectangle();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
  virtual void set_status( a_control_status status );
  virtual encoded_string encode( a_rectangle c );
  virtual void decode( encoded_string *estr );

  virtual void set_colours( a_pen_colour_name frame_colour,
    a_pen_colour_name back_colour );
  virtual void get_colours( a_pen_colour_name *frame_colour,
    a_pen_colour_name *back_colour );

};



//-> Lines
//
// SetColour - select the colour of the line
// GetColour - return the colour of the line
// SetDrawDir - DownRight => line is drawn from top-left to bottom-right
//    of the control frame, else bottom-left to top-right.
// GetDrawDir - return the drawing direction

class a_line : an_iconic_control {

private:

  a_pen_colour_name colour;           // colour of the line
  unsigned char down_right;           // true if line goes from top-left to b-r

public:

  a_line( int left, int top, int right, int bottom,
    char hot_key = null_key );                                 /* class-wide */
  ~a_line();                                                   /* class-wide */

  virtual void hear( an_input_record i, a_dialog_action *d );  /* class-wide */
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
                                                               /* class-wide */
  virtual void set_status( a_control_status status );          /* class-wide */
  virtual encoded_string encode( void );
  virtual void decode( encoded_string *estr );                 /* class-wide */

  virtual void set_colour( a_pen_colour_name colour );         /* class-wide */
  virtual a_pen_colour_name get_colour( void );                /* class-wide */
  virtual void set_draw_dir( unsigned char down_right );
  virtual unsigned char get_draw_dir( void );

};


//-> Section Separators
//
// On Graphics Displays, centered in drawing grid appropriately

class an_horizontal_sep : a_line {

public:

  an_horizontal_sep( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~an_horizontal_sep();
// can it be virtual like Ada?  better check!

  virtual void draw( void );

};

class a_vertical_sep : a_line {

public:

  a_virtual_sep( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_virtual_sep();

  virtual void draw( void );

};

//-> Static Lists, the elementary static list
//
// Is the list the belongs to the control a pointer to a list, or
// a copy of a list supplied by the programmer?  A pointer makes it
// handy to read the list, but offers no protection against failure
// to inform the control to update.  I'll compromise here: SetList
// COPIES and GetList returns a pointer.
//
// that it can't be copied by assignment.
// SetList - install the text to display in the box
// SetOrigin - change top line being displayed
// GetList - return the list of text
// GetOrigin - return the origin
// GetCurrent - return line the cursor is on
// GetPosition - return the position on the line
// SetCursor - move the cursor to a specific place
// GetLength - return number of lines
// JustifyText - format text to fit within specified width
// SetScrollBar - set the scroll bar (or thermometer) to be associated
//   with this list control
// GetScrollBar - return the associated scroll bar (or 0)

class a_static_list : a_window_control {

private:

  str255_list._list list;                 // list of text
  str255_list._alist_index origin;        // line # at top of box
  a_control_number scroll_bar;            // reference value for window manager
  long mark;                              // as set by set mark
  str255 find_phrase = null_str255;       // for hilighting purposes

public:

  a_static_list( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_static_list();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );
  virtual void resize( int dleft, int dtop, int dright, int dbottom );
                                                               /* class-wide */
  virtual void set_status( a_control_status status );          /* class-wide */
  virtual encoded_string encode( void );                       /* class-wide */
  virtual void decode( encoded_string *estr );                 /* class-wide */

  virtual void set_list( str255_list_list *list );             /* class-wide */
  virtual void set_origin( str255_list.a_list_index origin );  /* class-wide */
  virtual str255_list_list get_list( void );                   /* class-wide */
  virtual str255_list_a_list_index get_origin( void );         /* class-wide */
  virtual str255_list_a_list_index get_current( void );        /* class-wide */
  virtual str255_list_a_list_index get_length( void );         /* class-wide */
  virtual void justify_text( int width,
    str255_list_alist_index starting_at = 0 );                 /* class-wide */
  virtual void move_cursor( int dx, long dy );                 /* class-wide */
  virtual void set_scroll_bar( a_control_number bar );         /* class-wide */
  virtual a_control_number get_scroll_bar( void );             /* class-wide */
  virtual void copy_line( str255 *text );                      /* class-wide */
  virtual void paste_line( str255 text );                      /* class-wide */
  virtual void replace_line( str255 text );                    /* class-wide */

  virtual void find_text( str255 str2find, unsigned char backwards,
    unsigned char is_reg_exp = false );                        /* class-wide */
  virtual void replace_text( str255 str2find, str255 str2repl,
    unsigned char backwards, unsigned char is_reg_exp = false );
                                                               /* class-wide */
  virtual void set_find_phrase( str255 phrase );               /* class-wide */

  virtual void set_mark( long mark );                          /* class-wide */
  virtual long get_mark( void );                               /* class-wide */
// mark position.  Use -1 to denote no mark set.

  virtual void copy_lines( long mark2, str255_list_list *lines ); /* c-w */
  // copy lines between mark2 and mark set with SetMark
  virtual void paste_lines( str255_list_list *lines );        /* class-wide */

};
typedef *a_static_list some_list_control; // a_static_list or its child classes pointer


//-> Check Lists
//
// SetChecks - install list of check boxes
// GetChecks - return pointer to list of checks

class a_check_list : a_static_list {

private:

  boolean_list._list checks;                     // list of selections (if any)

public:

  a_check_list( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_check_list();

  extern void hear( an_input_record i, a_dialog_action *d );
  extern void draw( void );

  extern void set_checks( boolean_list_list *checks );
  extern boolean_list_list get_checks( void );

};


//-> Radio Lists
//
// SetChecks - install list of radio button checks + first to check
// GetChecks - return a pointer to the list of checks
// GetCheck  - return the number of the item checked

class a_radio_list : a_static_list {

private:

  boolean_list._list checks;                     // list of selections (if any)
  long last_check;                               // last selection (else 0)

public:

  a_radio_list( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_radio_list();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );

  virtual void set_checks( boolean_list_list *checks,
    boolean_list_a_list_index default = 1 );
  virtual boolean_list_list get_checks( void );
  virtual boolean_list_alist_index get_check( void );

};


//-> Edit Lists
//
// GetPosition - get horizontal position of cursor (left side = 1)
// SetCursor - move the cursor to a specific position in the text

class an_edit_list : a_static_list {

private:

  unsigned char dirty_line;                         // if current line is dirty
  unsigned char touched = false;                    // true if received input
  unsigned char forward_char_search_mode = false;   // true if in mode

public:

  an_edit_list( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~an_edit_list();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );

  virtual int get_position( void );                            /* class-wide */
  virtual void set_cursor( int x, str255_list_a_list_index y ); /* class-wide*/

  virtual void touch( void );                                  /* class-wide */
  // set touch flag to true
  virtual void clear_touch( void );                            /* class-wide */
  // set touch flag to false
  virtual unsigned char was_touched( void );                   /* class-wide */
  // true if Touch or received input.  Used for saving

};

//-> SOURCE EDIT LIST
//
// For displaying source code with hilighted keywords

class a_source_edit_list : an_edit_list {

private:

  str255_list._list keyword_list;

public:

  a_source_edit_list( int left, int top, int right, int bottom,
    char hot_key = null_key );
  ~a_edit_source_list();

  virtual void hear( an_input_record i, a_dialog_action *d );
  virtual void draw( void );

  virtual void add_keyword( char * keyword );
  // add a keyword
  virtual void clear_keywords( void );
  // remove all keywords


};

//--> UNFINISHED CONTROLS

class an_htmlbox : a_static_list {

};


//-> Pictures
//
// Bit-mapped pictures.  They can double as traditional icons using the
// text description as the icon caption.  APicture is a collection of
// simple pictures optimized at different resolutions.

class a_simple_picture : an_iconic_control {

private:

  a_picture_id pic;                      // ID of the picture
  str255 path;                           // path of the picture
  str255 text;                           // description (if can't be displayed)

};

class a_picture : a_simple_picture {

private:

   // to be defined

};


//-> Scalable pictures
//
// Traditional "draw" object composed of scalable geometric objects, like
// lines, circles, rectangles, etc.

class a_sketch : an_iconic_control {

};


//-> Animations
//
// A collection of objects to be displayed through a sequence of states.
// The objects can't be edited, hence an animation is iconic.

// forward declaration of private record an_animation
// you'll need to copy the class here

class an_animation : an_iconic_control {

private:

int x, y;                           // actually, redundant with control pos'n
int xvector, yvector;               // motion offset information
unsigned char enabled;              // actually, redundant with status
unsigned char visible;              // actually, redundant with status
short index;                        // frame index
short ani_status;                   // grammer status
//Stack  : AnAnimationStack;  -- the animation grammar

};

class a_tree_list : a_static_list

}

}

#endif

