/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides support for standard Swing actions.
 * The package contains several classes that help with internationalization of actions and buttons. 
 * For most practical applications
 * however, we suggest the use of the <i>menu builder</i> 
 * ({@link be.ugent.caagt.swirl.menus.MenuBuilder}) which has built-in internationalization, and uses
 * the classes from this package behind the scenes.
 * <p>The package also includes some (abstract) implementations
 * of general purpose actions:
 * <ul>
 * <li>{@link be.ugent.caagt.swirl.actions.ShowWindow} shows an existing 
 * window and brings it to the front. {@link be.ugent.caagt.swirl.actions.HideWindow} hides a window.</li>
 * <li>{@link be.ugent.caagt.swirl.actions.FileOpenAction} displays an 'open file' dialog and
 * loads the selected files. {@link be.ugent.caagt.swirl.actions.FileSaveAction} is
 * used in a similar way to save files.
 * </ul>
 * <h2>Description objects</h2>
 * A description object combines caption, mnemonic and accelerator key of a button
 * into a single string. For example, the description string
 * <pre>
 *     Javadoc inde&amp;x search [shift F1]
 * </pre>
 * can be used to provide a button with the caption 
 * '<code>Javadoc index search</code>', the mnemonic '<code>x</code>' and the 
 * accelerator key shift-F1.<p>
 *
 * Description strings are typically retrieved from resource
 * bundles, making internationalization of buttons and actions fairly
 * straightforward.<p>
 *
 * In most cases buttons and menu
 * items can most easily be internationalized using actions that 
 * extend {@link be.ugent.caagt.swirl.actions.SimpleAction} or through one of
 * the class methods of {@link be.ugent.caagt.swirl.actions.ButtonFactory}.<p>
 * <h2>Enhanced action support</h2>
 * This package also supports some additional action properties. 
 * <ul>
 * <li>Actions can use 'medium size' icons when they are displayed as
 * tool bar buttons, and at the same time use different 'small' icons
 * when used as part of a menu.</li>
 * <li>In both cases the 'disabled' icon can be registered with the action,
 * while in Swing these icons can only be set directly on the buttons or
 * menu items.</li>
 * <li>A toggle button model can be registered with the action. As a consequence
 * this will automatically synchronise the state of all toggle buttons, radio 
 * buttons or check boxes 
 * that correspond to the same action. See <a href="#model">below</a> for an example
 * of how to use this feature.</li>
 * </ul>
 * To take advantage of these new properties, you cannot use the standard Swing button classes
 * but need to use one of the following
 * new classes provided by this package:
 * <ul>
 * <li>{@link be.ugent.caagt.swirl.actions.ToolBarButton}
 * replaces {@code JButton} for use in a tool bar.</li>
 * <li>{@link be.ugent.caagt.swirl.actions.ToolBarToggleButton}
 * replaces {@code JToggleButton} for use in a tool bar.</li>
 * <li>{@link be.ugent.caagt.swirl.actions.MenuButton}
 * replaces {@code JMenuItem}.</li>
 * <li>{@link be.ugent.caagt.swirl.actions.MenuRadioButton}
 * replaces {@code JRadioButtonMenuItem}.</li>
 * <li>{@link be.ugent.caagt.swirl.actions.MenuCheckBoxButton}
 * replaces {@code JCheckBoxMenuItem}.</li>
 * </ul>
 * <p>
 * <h2><a name="model"></a>Sharing a toggle button model</h2>
 * The following example illustrates the use of the property
 * {@link be.ugent.caagt.swirl.actions.SimpleAction#TOGGLE_BUTTON_MODEL} to allow
 * a check box menu item and a toggle button to share state: selecting one of them, 
 * automatically selects the other.
 * <pre>
 *     Action action = new SomeAction (...);
 *     action.putValue (
 *            SimpleAction.TOGGLE_MENU_BUTTON,
 *            new JToggleButton.ToggleButtonModel ()
 *     );
 *     MenuCheckBoxItem checkBox = new MenuCheckBoxItem (action);
 *     ...
 *     ToolBarToggleButton toggleButton = new ToolBarToggleButton (action);
 *     ...
 * </pre>
 * The same technique can be used with radio buttons.<p>
 * 
 * Note that if two 'button groups' need to be synchronised, only one of them needs to be put inside a
 * {@code ButtonGroup} object. However, in this case 
 * classes {@link be.ugent.caagt.swirl.SelectionGroup} or
 * {@link be.ugent.caagt.swirl.GenericSelectionGroup} often provide a 
 * better alternative. Two 'selection groups' that share the same selection
 * model are always
 * automatically synchronised, and then there is no need for the 
 * individual button models to be shared.
 */
package be.ugent.caagt.swirl.actions;

