/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Abstract Syntax Tree (AST) representation of a
 * mathematical expression.
 * <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 * <p>
 * Abstract Syntax Trees (ASTs) are a simple kind of data structure used in
 * libSBML for storing mathematical expressions.  The {@link ASTNode} is the
 * cornerstone of libSBML's AST representation.  An AST 'node' represents the
 * most basic, indivisible part of a mathematical formula and come in many
 * types.  For instance, there are node types to represent numbers (with
 * subtypes to distinguish integer, real, and rational numbers), names
 * (e.g., constants or variables), simple mathematical operators, logical
 * or relational operators and functions. LibSBML ASTs provide a canonical,
 * in-memory representation for all mathematical formulas regardless of
 * their original format (which might be MathML or might be text strings).
 * <p>
 * An AST <em>node</em> in libSBML is a recursive structure containing a pointer
 * to the node's value (which might be, for example, a number or a symbol)
 * and a list of children nodes.  Each {@link ASTNode} node may have none, one,
 * two, or more children depending on its type.  The following diagram
 * illustrates an example of how the mathematical expression <code>'1 +
 * 2'</code> is represented as an AST with one <em>plus</em> node having two 
 * <em>integer</em> children nodes for the numbers <code>1</code> and
 * <code>2</code>.  The figure also shows the corresponding MathML
 * representation:
 * <p>
 * <center style='padding-bottom: 0.5em'>
<table border='0' class='text-table width80 normal-font'>
<caption class='top-caption'>Example AST representation of a mathematical expression.</caption>
<tr>
<th>Infix</th>
<th>AST</th>
<th>MathML</th>
</tr>
<tr>
<td valign='middle'>
<code>1 + 2</code>
</td>
<td valign='middle'>
<iframe src='simple-ast.svg' width='140' height='120' scrolling='no' frameborder='0'></iframe>
</td>
<td valign='middle'>
<code>&lt;math xmlns='http://www.w3.org/1998/Math/MathML'&gt;</code><br>
<code>&nbsp;&nbsp;&lt;apply&gt;</code><br>
<code>&nbsp;&nbsp;&nbsp;&nbsp;&lt;plus/&gt;</code><br>
<code>&nbsp;&nbsp;&nbsp;&nbsp;&lt;cn type='integer'&gt; 1 &lt;/cn&gt;</code><br>
<code>&nbsp;&nbsp;&nbsp;&nbsp;&lt;cn type='integer'&gt; 2 &lt;/cn&gt;</code><br>
<code>&nbsp;&nbsp;&lt;/apply&gt;</code><br>
<code>&lt;/math&gt;</code>
</td>
</tr>
</table>
</center>

 * <p>
 * The following are other noteworthy points about the AST representation
 * in libSBML:
 * <ul>
 * <li> A numerical value represented in MathML as a real number with an
 * exponent is preserved as such in the AST node representation, even if
 * the number could be stored in a <code>double</code> data type.  This is done
 * so that when an SBML model is read in and then written out again, the
 * amount of change introduced by libSBML to the SBML during the round-trip
 * activity is minimized.
 * <p>
 * <li> Rational numbers are represented in an AST node using separate
 * numerator and denominator values.  These can be retrieved using the
 * methods {@link ASTNode#getNumerator()} and {@link ASTNode#getDenominator()}.
 * <p>
 * <li> The children of an {@link ASTNode} are other {@link ASTNode} objects.  The list of
 * children is empty for nodes that are leaf elements, such as numbers.
 * For nodes that are actually roots of expression subtrees, the list of
 * children points to the parsed objects that make up the rest of the
 * expression.
 * </ul>
 * <p>
 * <p>
 * <h3><a class='anchor'
 * name='ASTNodeType_t'>The set of possible ASTNode types</a></h3> 
 * <p>
 * Every {@link ASTNode} has an associated type code to indicate,
 * for example, whether it holds a number or stands for an arithmetic
 * operator.
 * <p>
 * The type is recorded as a value drawn from a
 * set of static integer constants defined in the class {@link
 * libsbmlConstants}. Their names begin with the characters <code>AST_.</code>
 * <p>
 * <p>
 * The list of possible types is quite long, because it covers all the
 * mathematical functions that are permitted in SBML. The values are shown
 * in the following table:
 * <p>
 * <ul class='columnlist list3'>
<li>AST_CONSTANT_E</li>
<li>AST_CONSTANT_FALSE</li>
<li>AST_CONSTANT_PI</li>
<li>AST_CONSTANT_TRUE</li>
<li>AST_DIVIDE</li>
<li>AST_FUNCTION</li>
<li>AST_FUNCTION_ABS</li>
<li>AST_FUNCTION_ARCCOS</li>
<li>AST_FUNCTION_ARCCOSH</li>
<li>AST_FUNCTION_ARCCOT</li>
<li>AST_FUNCTION_ARCCOTH</li>
<li>AST_FUNCTION_ARCCSC</li>
<li>AST_FUNCTION_ARCCSCH</li>
<li>AST_FUNCTION_ARCSEC</li>
<li>AST_FUNCTION_ARCSECH</li>
<li>AST_FUNCTION_ARCSIN</li>
<li>AST_FUNCTION_ARCSINH</li>
<li>AST_FUNCTION_ARCTAN</li>
<li>AST_FUNCTION_ARCTANH</li>
<li>AST_FUNCTION_CEILING</li>
<li>AST_FUNCTION_COS</li>
<li>AST_FUNCTION_COSH</li>
<li>AST_FUNCTION_COT</li>
<li>AST_FUNCTION_COTH</li>
<li>AST_FUNCTION_CSC</li>
<li>AST_FUNCTION_CSCH</li>
<li>AST_FUNCTION_DELAY</li>
<li>AST_FUNCTION_EXP</li>
<li>AST_FUNCTION_FACTORIAL</li>
<li>AST_FUNCTION_FLOOR</li>
<li>AST_FUNCTION_LN</li>
<li>AST_FUNCTION_LOG</li>
<li>AST_FUNCTION_PIECEWISE</li>
<li>AST_FUNCTION_POWER</li>
<li>AST_FUNCTION_ROOT</li>
<li>AST_FUNCTION_SEC</li>
<li>AST_FUNCTION_SECH</li>
<li>AST_FUNCTION_SIN</li>
<li>AST_FUNCTION_SINH</li>
<li>AST_FUNCTION_TAN</li>
<li>AST_FUNCTION_TANH</li>
<li>AST_INTEGER</li>
<li>AST_LAMBDA</li>
<li>AST_LOGICAL_AND</li>
<li>AST_LOGICAL_NOT</li>
<li>AST_LOGICAL_OR</li>
<li>AST_LOGICAL_XOR</li>
<li>AST_MINUS</li>
<li>AST_NAME</li>
<li><nobr>AST_NAME_AVOGADRO <em><span class='warning'>(Level&nbsp;3 only)</span></em></nobr></li>
<li>AST_NAME_TIME</li>
<li>AST_PLUS</li>
<li>AST_POWER</li>
<li>AST_RATIONAL</li>
<li>AST_REAL</li>
<li>AST_REAL_E</li>
<li>AST_RELATIONAL_EQ</li>
<li>AST_RELATIONAL_GEQ</li>
<li>AST_RELATIONAL_GT</li>
<li>AST_RELATIONAL_LEQ</li>
<li>AST_RELATIONAL_LT</li>
<li>AST_RELATIONAL_NEQ</li>
<li>AST_TIMES</li>
<li>AST_UNKNOWN</li>
</ul>
<br style='clear: both'>

 * <p>
 * The types have the following meanings:
 * <ul>
 * <li> If the node is basic mathematical operator (e.g., <code>'+'</code>), then the
 * node's type will be <code>AST_PLUS</code>, <code>AST_MINUS</code>, <code>AST_TIMES</code>, <code>AST_DIVIDE</code>,
 * or <code>AST_POWER</code>, as appropriate.
 * <p>
 * <li> If the node is a predefined function or operator from SBML Level&nbsp;1
 * (in the string-based formula syntax used in Level&nbsp;1) or SBML Levels&nbsp;2 and&nbsp;3
 * (in the subset of MathML used in SBML Levels&nbsp;2 and&nbsp;3), then the node's type
 * will be either <code>AST_FUNCTION_</code><em><span
 * class='placeholder'>X</span></em>, <code>AST_LOGICAL_</code><em><span
 * class='placeholder'>X</span></em>, or
 * <code>AST_RELATIONAL_</code><em><span class='placeholder'>X</span></em>,
 * as appropriate.  (Examples: <code>AST_FUNCTION_LOG</code>, <code>AST_RELATIONAL_LEQ.</code>)
 * <p>
 * <li> If the node refers to a user-defined function, the node's type will
 * be <code>AST_NAME</code> (because it holds the name of the function).
 * <p>
 * <li> If the node is a lambda expression, its type will be <code>AST_LAMBDA.</code>
 * <p>
 * <li> If the node is a predefined constant (<code>'ExponentialE'</code>, <code>'Pi'</code>, 
 * <code>'True'</code> or <code>'False'</code>), then the node's type will be <code>AST_CONSTANT_E</code>,
 * <code>AST_CONSTANT_PI</code>, <code>AST_CONSTANT_TRUE</code>, or <code>AST_CONSTANT_FALSE.</code>
 * <p>
 * <li> (Levels&nbsp;2 and&nbsp;3 only) If the node is the special MathML csymbol <code>time</code>,
 * the value of the node will be <code>AST_NAME_TIME.</code>  (Note, however, that the
 * MathML csymbol <code>delay</code> is translated into a node of type
 * <code>AST_FUNCTION_DELAY.</code>  The difference is due to the fact that <code>time</code> is a
 * single variable, whereas <code>delay</code> is actually a function taking
 * arguments.)
 * <p>
 * <li> (Level&nbsp;3 only) If the node is the special MathML csymbol <code>avogadro</code>,
 * the value of the node will be <code>AST_NAME_AVOGADRO.</code>
 * <p>
 * <li> If the node contains a numerical value, its type will be
 * <code>AST_INTEGER</code>, <code>AST_REAL</code>, <code>AST_REAL_E</code>, or <code>AST_RATIONAL</code>,
 * as appropriate.
 * </ul>
 * <p>
 * <p>
 * <h3><a class='anchor' name='math-convert'>Converting between ASTs and text strings</a></h3>
 * <p>
 * The text-string form of mathematical formulas produced by <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString()</a></code> and
 * read by <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String formula)</a></code>
 * and
 * <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * are in a simple C-inspired infix notation.  A
 * formula in this text-string form can be handed to a program that
 * understands SBML mathematical expressions, or used as part
 * of a translation system.  The libSBML distribution comes with an example
 * program in the <code>'examples'</code> subdirectory called <code>translateMath</code> that
 * implements an interactive command-line demonstration of translating
 * infix formulas into MathML and vice-versa.
 * <p>
 * The formula strings may contain operators, function calls, symbols, and
 * white space characters.  The allowable white space characters are tab
 * and space.  The following are illustrative examples of formulas
 * expressed in the syntax:
 * <p>
 * <div class='fragment'><pre>
0.10 * k4^2
</pre></div>
 * <div class='fragment'><pre>
(vm * s1)/(km + s1)
</pre></div>
 * <p>
 * The following table shows the precedence rules in this syntax.  In the
 * Class column, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the Precedence column show how the order
 * of different types of operation are determined.  For example, the
 * expression <em>a * b + c</em> is evaluated as <em>(a * b) + c</em>
 * because the <code>*</code> operator has higher precedence.  The
 * Associates column shows how the order of similar precedence operations
 * is determined; for example, <em>a - b + c</em> is evaluated as <em>(a -
 * b) + c</em> because the <code>+</code> and <code>-</code> operators are
 * left-associative.  The precedence and associativity rules are taken from
 * the C programming language, except for the symbol <code>^</code>, which
 * is used in C for a different purpose.  (Exponentiation can be invoked
 * using either <code>^</code> or the function <code>power.</code>)
 * <p>
 * <center style='padding-bottom: 0.5em'>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr style='background: lightgray; font-size: 14px;'>
     <th align='left'>Token</th>
     <th align='left'>Operation</th>
     <th align='left'>Class</th>
     <th>Precedence</th>
     <th align='left'>Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align='center'>6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align='center'>5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align='center'>4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align='center'>1</td><td>left</td></tr>
<caption class='top-caption'>A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>
</center>
 
 * <p>
 * A program parsing a formula in an SBML model should assume that names
 * appearing in the formula are the identifiers of {@link Species}, {@link Parameter},
 * {@link Compartment}, {@link FunctionDefinition}, {@link Reaction} (in SBML Levels&nbsp;2
 * and&nbsp;3), or {@link SpeciesReference} (in SBML Level&nbsp;3 only) objects
 * defined in a model.  When a function call is involved, the syntax
 * consists of a function identifier, followed by optional white space,
 * followed by an opening parenthesis, followed by a sequence of zero or
 * more arguments separated by commas (with each comma optionally preceded
 * and/or followed by zero or more white space characters), followed by a
 * closing parenthesis.  There is an almost one-to-one mapping between the
 * list of predefined functions available, and those defined in MathML.
 * All of the MathML functions are recognized; this set is larger than the
 * functions defined in SBML Level&nbsp;1.  In the subset of functions that
 * overlap between MathML and SBML Level&nbsp;1, there exist a few
 * differences.  The following table summarizes the differences between the
 * predefined functions in SBML Level&nbsp;1 and the MathML equivalents in
 * SBML Levels&nbsp;2 and &nbsp;3:
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr style='background: lightgray; font-size: 14px;'>
     <th align='left'>Text string formula functions</th>
     <th align='left'>MathML equivalents in SBML Levels&nbsp;2 and&nbsp;3</th>
 </tr>
 <tr><td><code>acos</code></td><td><code>arccos</code></td></tr>
 <tr><td><code>asin</code></td><td><code>arcsin</code></td></tr>
 <tr><td><code>atan</code></td><td><code>arctan</code></td></tr>
 <tr><td><code>ceil</code></td><td><code>ceiling</code></td></tr>
 <tr><td><code>log</code></td><td><code>ln</code></td></tr>
 <tr><td><code>log10(x)</code></td><td><code>log(10, x)</code></td></tr>
 <tr><td><code>pow(x, y)</code></td><td><code>power(x, y)</code></td></tr>
 <tr><td><code>sqr(x)</code></td><td><code>power(x, 2)</code></td></tr>
 <tr><td><code>sqrt(x)</code></td><td><code>root(2, x)</code></td></tr>
<caption class='top-caption'>Table comparing the names of certain
functions in the SBML text-string formula syntax and MathML.  The left
column shows the names of functions recognized by SBML_parseFormula(); the
right column shows their equivalent function names in MathML&nbsp;2.0, used
in SBML Levels&nbsp;2 and&nbsp;3.</caption>
</table>
</center>

 * <p>
 * @warning We urge developers to keep in mind that the text-string formula syntax is
specific to SBML Level&nbsp;1's C-like mathematical formula syntax.  In
particular, it is <em>not a general-purpose mathematical expression
syntax</em>.  LibSBML provides methods for parsing and transforming
text-string math formulas back and forth from AST structures, but it is
important to keep the system's limitations in mind.

 * <p>
 * <p>
 * <p>
 * <p>
 * @see <code><a href='libsbml.html#parseL3Formula(String formula)'>libsbml.parseL3Formula(String formula)</a></code>
 * <p>
 * <p>
 * <p>
 * @see <code><a href='libsbml.html#parseFormula(String formula)'>libsbml.parseFormula(String formula)</a></code>
 */

public class ASTNode {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected ASTNode(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(ASTNode obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ASTNode obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ASTNode(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for ASTNode.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((ASTNode)(sb));
  }

  /**
   * Returns a hashcode for this ASTNode object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates and returns a new {@link ASTNode}.
   * <p>
   * Unless the argument <code>type</code> is given, the returned node will by
   * default have a type of {@link  libsbmlConstants#AST_UNKNOWN
   * AST_UNKNOWN}.  If the type isn't supplied when caling this
   * constructor, the caller should set the node type to something else as
   * soon as possible using
   * {@link ASTNode#setType(int)}.
   * <p>
   * @param type an optional
   * type
   * code indicating the type of node to create.
   * <p>
   * <!-- Don't remove the leading </dl> below. It's a hack for javadoc. -->
</dl><dl class='docnote'><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 ASTNode(int type) {
    this(libsbmlJNI.new_ASTNode__SWIG_0(type), true);
  }

  
/**
   * Creates and returns a new {@link ASTNode}.
   * <p>
   * Unless the argument <code>type</code> is given, the returned node will by
   * default have a type of {@link  libsbmlConstants#AST_UNKNOWN
   * AST_UNKNOWN}.  If the type isn't supplied when caling this
   * constructor, the caller should set the node type to something else as
   * soon as possible using
   * {@link ASTNode#setType(int)}.
   * <p>
   * @param type an optional
   * type
   * code indicating the type of node to create.
   * <p>
   * <!-- Don't remove the leading </dl> below. It's a hack for javadoc. -->
</dl><dl class='docnote'><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 ASTNode() {
    this(libsbmlJNI.new_ASTNode__SWIG_1(), true);
  }

  
/**
   * Copy constructor; creates a deep copy of the given {@link ASTNode}.
   * <p>
   * @param orig the {@link ASTNode} to be copied.
   */ public
 ASTNode(ASTNode orig) {
    this(libsbmlJNI.new_ASTNode__SWIG_2(ASTNode.getCPtr(orig), orig), true);
  }

  
/**
   * Frees the name of this {@link ASTNode} and sets it to <code>null.</code>
   * <p>
   * This operation is only applicable to {@link ASTNode} objects corresponding to
   * operators, numbers, or {@link  libsbmlConstants#AST_UNKNOWN
   * AST_UNKNOWN}.  This method has no effect on other types of
   * nodes.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */ public
 int freeName() {
    return libsbmlJNI.ASTNode_freeName(swigCPtr, this);
  }

  
/**
   * Converts this {@link ASTNode} to a canonical form and returns <code>true</code> if
   * successful, <code>false</code> otherwise.
   * <p>
   * The rules determining the canonical form conversion are as follows:
   * <ul>
   * <p>
   * <li> If the node type is {@link  libsbmlConstants#AST_NAME AST_NAME}
   * and the node name matches <code>'ExponentialE'</code>, <code>'Pi'</code>, <code>'True'</code> or 
   * <code>'False'</code> the node type is converted to the corresponding 
   * <code>AST_CONSTANT_</code><em><span class='placeholder'>X</span></em> type.
   * <p>
   * <li> If the node type is an {@link  libsbmlConstants#AST_FUNCTION
   * AST_FUNCTION} and the node name matches an SBML (MathML) function name, logical operator name, or
   * relational operator name, the node is converted to the corresponding
   * <code>AST_FUNCTION_</code><em><span class='placeholder'>X</span></em> or
   * <code>AST_LOGICAL_</code><em><span class='placeholder'>X</span></em> type.
   * <p>
   * </ul>
   * <p>
   * SBML Level&nbsp;1 function names are searched first; thus, for
   * example, canonicalizing <code>log</code> will result in a node type of {@link 
   * libsbmlConstants#AST_FUNCTION_LN AST_FUNCTION_LN}.  (See the SBML
   * Level&nbsp;1 Version&nbsp;2 Specification, Appendix C.)
   * <p>
   * Sometimes, canonicalization of a node results in a structural
   * conversion of the node as a result of adding a child.  For example, a
   * node with the SBML Level&nbsp;1 function name <code>sqr</code> and a single
   * child node (the argument) will be transformed to a node of type
   * {@link  libsbmlConstants#AST_FUNCTION_POWER AST_FUNCTION_POWER} with
   * two children.  The first child will remain unchanged, but the second
   * child will be an {@link ASTNode} of type {@link  libsbmlConstants#AST_INTEGER
   * AST_INTEGER} and a value of 2.  The function names that result
   * in structural changes are: <code>log10</code>, <code>sqr</code>, and <code>sqrt.</code>
   */ public
 boolean canonicalize() {
    return libsbmlJNI.ASTNode_canonicalize(swigCPtr, this);
  }

  
/**
   * Adds the given node as a child of this {@link ASTNode}.  Child nodes are added
   * in-order, from left to right.
   * <p>
   * @param child the {@link ASTNode} instance to add
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note Adding a child to an {@link ASTNode} may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.  Callers need to be careful to use
   * this method in the context of other operations to create complete and
   * correct formulas.  The method
   * {@link ASTNode#isWellFormedASTNode()}
   * may also be useful for checking the results of node modifications.
   * <p>
   * @see #prependChild(ASTNode child)
   * @see #replaceChild(long n, ASTNode child)
   * @see #insertChild(long n, ASTNode child)
   * @see #removeChild(long n)
   * @see #isWellFormedASTNode()
   */ public
 int addChild(ASTNode child) {
    return libsbmlJNI.ASTNode_addChild(swigCPtr, this, ASTNode.getCPtrAndDisown(child), child);
  }

  
/**
   * Adds the given node as a child of this {@link ASTNode}.  This method adds
   * child nodes from right to left.
   * <p>
   * @param child the {@link ASTNode} instance to add
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note Prepending a child to an {@link ASTNode} may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   * <p>
   * @see #addChild(ASTNode child)
   * @see #replaceChild(long n, ASTNode child)
   * @see #insertChild(long n, ASTNode child)
   * @see #removeChild(long n)
   */ public
 int prependChild(ASTNode child) {
    return libsbmlJNI.ASTNode_prependChild(swigCPtr, this, ASTNode.getCPtrAndDisown(child), child);
  }

  
/**
   * Removes the nth child of this {@link ASTNode} object.
   * <p>
   * @param n long the index of the child to remove
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE }
   * </ul>
   * <p>
   * @note Removing a child from an {@link ASTNode} may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   * <p>
   * @see #addChild(ASTNode child)
   * @see #prependChild(ASTNode child)
   * @see #replaceChild(long n, ASTNode child)
   * @see #insertChild(long n, ASTNode child)
   */ public
 int removeChild(long n) {
    return libsbmlJNI.ASTNode_removeChild(swigCPtr, this, n);
  }

  
/**
   * Replaces the nth child of this {@link ASTNode} with the given {@link ASTNode}.
   * <p>
   * @param n long the index of the child to replace
   * @param newChild {@link ASTNode} to replace the nth child
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * </ul>
   * <p>
   * @note Replacing a child from an {@link ASTNode} may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   * <p>
   * @see #addChild(ASTNode child)
   * @see #prependChild(ASTNode child)
   * @see #insertChild(long n, ASTNode child)
   * @see #removeChild(long n)
   */ public
 int replaceChild(long n, ASTNode newChild) {
    return libsbmlJNI.ASTNode_replaceChild(swigCPtr, this, n, ASTNode.getCPtrAndDisown(newChild), newChild);
  }

  
/**
   * Insert the given {@link ASTNode} at point n in the list of children
   * of this {@link ASTNode}.
   * <p>
   * @param n long the index of the {@link ASTNode} being added
   * @param newChild {@link ASTNode} to insert as the nth child
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * </ul>
   * <p>
   * @note Inserting a child into an {@link ASTNode} may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   * <p>
   * @see #addChild(ASTNode child)
   * @see #prependChild(ASTNode child)
   * @see #replaceChild(long n, ASTNode child)
   * @see #removeChild(long n)
   */ public
 int insertChild(long n, ASTNode newChild) {
    return libsbmlJNI.ASTNode_insertChild(swigCPtr, this, n, ASTNode.getCPtrAndDisown(newChild), newChild);
  }

  
/**
   * Creates a recursive copy of this node and all its children.
   * <p>
   * @return a copy of this {@link ASTNode} and all its children.  The caller owns
   * the returned {@link ASTNode} and is reponsible for deleting it.
   */ public
 ASTNode deepCopy() {
    long cPtr = libsbmlJNI.ASTNode_deepCopy(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
   * Get a child of this node according to its index number.
   * <p>
   * @param n the index of the child to get
   * <p>
   * @return the nth child of this {@link ASTNode} or <code>null</code> if this node has no nth
   * child (<code>n &gt; </code>
   * {@link ASTNode#getNumChildren()}
   * <code>- 1</code>).
   */ public
 ASTNode getChild(long n) {
    long cPtr = libsbmlJNI.ASTNode_getChild(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Get the left child of this node.
   * <p>
   * @return the left child of this {@link ASTNode}.  This is equivalent to calling
   * {@link ASTNode#getChild(long)}
   * with an argument of <code>0.</code>
   */ public
 ASTNode getLeftChild() {
    long cPtr = libsbmlJNI.ASTNode_getLeftChild(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Get the right child of this node.
   * <p>
   * @return the right child of this {@link ASTNode}, or <code>null</code> if this node has no
   * right child.  If
   * {@link ASTNode#getNumChildren()}
   * <code>&gt; 1</code>, then this is equivalent to:
   * <div class='fragment'><pre>
   * getChild( getNumChildren() - 1 );</pre></div>
   */ public
 ASTNode getRightChild() {
    long cPtr = libsbmlJNI.ASTNode_getRightChild(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Get the number of children that this node has.
   * <p>
   * @return the number of children of this {@link ASTNode}, or 0 is this node has
   * no children.
   */ public
 long getNumChildren() {
    return libsbmlJNI.ASTNode_getNumChildren(swigCPtr, this);
  }

  
/**
   * Adds the given {@link XMLNode} as a <em>semantic annotation</em> of this {@link ASTNode}.
   * <p>
   * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
that can be used to associate additional information with a MathML
construct.  The construct can be used to decorate a MathML expressions with
a sequence of one or more <code>&lt;annotation&gt;</code> or
<code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
pair of items; the first is a symbol that acts as an attribute or key, and
the second is the value associated with the attribute or key.  Please refer
to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
5.2, Semantic Annotations</a> for more information about these constructs.

   * <p>
   * @param sAnnotation the annotation to add.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note Although SBML permits the semantic annotation construct in
   * MathML expressions, the truth is that this construct has so far (at
   * this time of this writing, which is early 2011) seen very little use
   * in SBML software.  The full implications of using semantic annotations
   * are still poorly understood.  If you wish to use this construct, we
   * urge you to discuss possible uses and applications on the SBML
   * discussion lists, particularly <a target='_blank'
   * href='http://sbml.org/Forums'>sbml-discuss&#64;caltech.edu</a> and/or <a
   * target='_blank'
   * href='http://sbml.org/Forums'>sbml-interoperability&#64;caltech.edu</a>.
   */ public
 int addSemanticsAnnotation(XMLNode sAnnotation) {
    return libsbmlJNI.ASTNode_addSemanticsAnnotation(swigCPtr, this, XMLNode.getCPtrAndDisown(sAnnotation), sAnnotation);
  }

  
/**
   * Get the number of <em>semantic annotation</em> elements inside this node.
   * <p>
   * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
that can be used to associate additional information with a MathML
construct.  The construct can be used to decorate a MathML expressions with
a sequence of one or more <code>&lt;annotation&gt;</code> or
<code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
pair of items; the first is a symbol that acts as an attribute or key, and
the second is the value associated with the attribute or key.  Please refer
to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
5.2, Semantic Annotations</a> for more information about these constructs.

   * <p>
   * @return the number of annotations of this {@link ASTNode}.
   * <p>
   * @see ASTNode#addSemanticsAnnotation(XMLNode sAnnotation)
   */ public
 long getNumSemanticsAnnotations() {
    return libsbmlJNI.ASTNode_getNumSemanticsAnnotations(swigCPtr, this);
  }

  
/**
   * Get the nth semantic annotation of this node.
   * <p>
   * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
that can be used to associate additional information with a MathML
construct.  The construct can be used to decorate a MathML expressions with
a sequence of one or more <code>&lt;annotation&gt;</code> or
<code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
pair of items; the first is a symbol that acts as an attribute or key, and
the second is the value associated with the attribute or key.  Please refer
to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
5.2, Semantic Annotations</a> for more information about these constructs.

   * <p>
   * @return the nth annotation of this {@link ASTNode}, or <code>null</code> if this node has
   * no nth annotation (<code>n &gt;</code>
   * {@link ASTNode#getNumChildren()}
   * <code>- 1</code>).
   * <p>
   * @see ASTNode#addSemanticsAnnotation(XMLNode sAnnotation)
   */ public
 XMLNode getSemanticsAnnotation(long n) {
    long cPtr = libsbmlJNI.ASTNode_getSemanticsAnnotation(swigCPtr, this, n);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
/**
   * Get the value of this node as a single character.  This function
   * should be called only when
   * {@link ASTNode#getType()} returns
   * {@link  libsbmlConstants#AST_PLUS AST_PLUS},
   * {@link  libsbmlConstants#AST_MINUS AST_MINUS},
   * {@link  libsbmlConstants#AST_TIMES AST_TIMES},
   * {@link  libsbmlConstants#AST_DIVIDE AST_DIVIDE} or
   * {@link  libsbmlConstants#AST_POWER AST_POWER}.
   * <p>
   * @return the value of this {@link ASTNode} as a single character
   */ public
 char getCharacter() {
    return libsbmlJNI.ASTNode_getCharacter(swigCPtr, this);
  }

  
/**
   * Get the id of this {@link ASTNode}.  
   * <p>
   * @return the mathml id of this {@link ASTNode}.
   */ public
 String getId() {
    return libsbmlJNI.ASTNode_getId(swigCPtr, this);
  }

  
/**
   * Get the class of this {@link ASTNode}.  
   * <p>
   * @return the mathml class of this {@link ASTNode}.
   */ public
 String getClassName() {
    return libsbmlJNI.ASTNode_getClassName(swigCPtr, this);
  }

  
/**
   * Get the style of this {@link ASTNode}.  
   * <p>
   * @return the mathml style of this {@link ASTNode}.
   */ public
 String getStyle() {
    return libsbmlJNI.ASTNode_getStyle(swigCPtr, this);
  }

  
/**
   * Get the value of this node as an integer. This function should be
   * called only when
   * {@link ASTNode#getType()}
   * <code>== {@link  libsbmlConstants#AST_INTEGER AST_INTEGER}</code>.
   * <p>
   * @return the value of this {@link ASTNode} as a (<code>long</code>) integer. 
   */ public
 int getInteger() {
    return libsbmlJNI.ASTNode_getInteger(swigCPtr, this);
  }

  
/**
   * Get the value of this node as a string.  This function may be called
   * on nodes that (1) are not operators, i.e., nodes for which
   * {@link ASTNode#isOperator()}
   * returns <code>false</code>, and (2) are not numbers, i.e.,
   * {@link ASTNode#isNumber()} returns <code>false.</code>
   * <p>
   * @return the value of this {@link ASTNode} as a string.
   */ public
 String getName() {
    return libsbmlJNI.ASTNode_getName(swigCPtr, this);
  }

  
/**
   * Get the value of this operator node as a string.  This function may be called
   * on nodes that are operators, i.e., nodes for which
   * {@link ASTNode#isOperator()}
   * returns <code>true.</code>
   * <p>
   * @return the name of this operator {@link ASTNode} as a string (or null if not an operator).
   */ public
 String getOperatorName() {
    return libsbmlJNI.ASTNode_getOperatorName(swigCPtr, this);
  }

  
/**
   * Get the value of the numerator of this node.  This function should be
   * called only when
   * {@link ASTNode#getType()}
   * <code>== {@link  libsbmlConstants#AST_RATIONAL AST_RATIONAL}</code>.
   * <p>
   * @return the value of the numerator of this {@link ASTNode}.  
   */ public
 int getNumerator() {
    return libsbmlJNI.ASTNode_getNumerator(swigCPtr, this);
  }

  
/**
   * Get the value of the denominator of this node.  This function should
   * be called only when
   * {@link ASTNode#getType()}
   * <code>== {@link  libsbmlConstants#AST_RATIONAL AST_RATIONAL}</code>.
   * <p>
   * @return the value of the denominator of this {@link ASTNode}.
   */ public
 int getDenominator() {
    return libsbmlJNI.ASTNode_getDenominator(swigCPtr, this);
  }

  
/**
   * Get the real-numbered value of this node.  This function
   * should be called only when
   * {@link ASTNode#isReal()}
   * <code>== true</code>.
   * <p>
   * This function performs the necessary arithmetic if the node type is
   * {@link  libsbmlConstants#AST_REAL_E AST_REAL_E} (<em>mantissa *
   * 10<sup> exponent</sup></em>) or {@link  libsbmlConstants#AST_RATIONAL
   * AST_RATIONAL} (<em>numerator / denominator</em>).
   * <p>
   * @return the value of this {@link ASTNode} as a real (double).
   */ public
 double getReal() {
    return libsbmlJNI.ASTNode_getReal(swigCPtr, this);
  }

  
/**
   * Get the mantissa value of this node.  This function should be called
   * only when {@link ASTNode#getType()}
   * returns {@link  libsbmlConstants#AST_REAL_E AST_REAL_E}
   * or {@link  libsbmlConstants#AST_REAL AST_REAL}.
   * If {@link ASTNode#getType()}
   * returns {@link  libsbmlConstants#AST_REAL AST_REAL},
   * this method is identical to
   * {@link ASTNode#getReal()}.
   * <p>
   * @return the value of the mantissa of this {@link ASTNode}. 
   */ public
 double getMantissa() {
    return libsbmlJNI.ASTNode_getMantissa(swigCPtr, this);
  }

  
/**
   * Get the exponent value of this {@link ASTNode}.  This function should be
   * called only when
   * {@link ASTNode#getType()}
   * returns {@link  libsbmlConstants#AST_REAL_E AST_REAL_E}
   * or {@link  libsbmlConstants#AST_REAL AST_REAL}.
   * <p>
   * @return the value of the exponent of this {@link ASTNode}.
   */ public
 int getExponent() {
    return libsbmlJNI.ASTNode_getExponent(swigCPtr, this);
  }

  
/**
   * Get the precedence of this node in the infix math syntax of SBML
   * Level&nbsp;1.  For more information about the infix syntax, see the
   * discussion about <a href='#math-convert'>text string formulas</a> at
   * the top of the documentation for {@link ASTNode}.
   * <p>
   * @return an integer indicating the precedence of this {@link ASTNode}
   */ public
 int getPrecedence() {
    return libsbmlJNI.ASTNode_getPrecedence(swigCPtr, this);
  }

  
/**
   * Get the type of this {@link ASTNode}.  The value returned is one of the
   * enumeration values such as {@link  libsbmlConstants#AST_LAMBDA
   * AST_LAMBDA}, {@link  libsbmlConstants#AST_PLUS AST_PLUS},
   * etc.
   * <p>
   * @return the type of this {@link ASTNode}.
   */ public
 int getType() {
    return libsbmlJNI.ASTNode_getType(swigCPtr, this);
  }

  
/**
   * Get the units of this {@link ASTNode}.  
   * <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing {@link Model}.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class='fragment'>&lt;math xmlns='http://www.w3.org/1998/Math/MathML'
      xmlns:sbml='http://www.sbml.org/sbml/level3/version1/core'&gt;
        &lt;cn type='integer' sbml:units='second'&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   * <p>
   * @return the units of this {@link ASTNode}.
   * <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   * <p>
   * <p>
   * <p>
   * <p>
   * @see <code><a href='libsbml.html#parseL3Formula(String formula)'>libsbml.parseL3Formula(String formula)</a></code>
   */ public
 String getUnits() {
    return libsbmlJNI.ASTNode_getUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is the special 
   * symbol <code>avogadro.</code>  The predicate returns <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is the special symbol avogadro.
   * <p>
   * <p>
   * <p>
   * <p>
   * @see <code><a href='libsbml.html#parseL3Formula(String formula)'>libsbml.parseL3Formula(String formula)</a></code>
   */ public
 boolean isAvogadro() {
    return libsbmlJNI.ASTNode_isAvogadro(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node has a boolean type
   * (a logical operator, a relational operator, or the constants <code>true</code>
   * or <code>false</code>).
   * <p>
   * @return true if this {@link ASTNode} is a boolean, false otherwise.
   */ public
 boolean isBoolean() {
    return libsbmlJNI.ASTNode_isBoolean(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node returns a boolean type
   * or <code>false</code> (zero) otherwise.
   * <p>
   * This function looks at the whole {@link ASTNode} rather than just the top 
   * level of the {@link ASTNode}. Thus it will consider return values from
   * piecewise statements.  In addition, if this {@link ASTNode} uses a function
   * call, the return value of the functionDefinition will be determined.
   * Note that this is only possible where the {@link ASTNode} can trace its parent
   * {@link Model}, that is, the {@link ASTNode} must represent the math element of some
   * SBML object that has already been added to an instance of an {@link SBMLDocument}.
   * <p>
   * @see #isBoolean()
   * <p>
   * @return true if this {@link ASTNode} returns a boolean, false otherwise.
   */ public
 boolean returnsBoolean(Model model) {
    return libsbmlJNI.ASTNode_returnsBoolean__SWIG_0(swigCPtr, this, Model.getCPtr(model), model);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node returns a boolean type
   * or <code>false</code> (zero) otherwise.
   * <p>
   * This function looks at the whole {@link ASTNode} rather than just the top 
   * level of the {@link ASTNode}. Thus it will consider return values from
   * piecewise statements.  In addition, if this {@link ASTNode} uses a function
   * call, the return value of the functionDefinition will be determined.
   * Note that this is only possible where the {@link ASTNode} can trace its parent
   * {@link Model}, that is, the {@link ASTNode} must represent the math element of some
   * SBML object that has already been added to an instance of an {@link SBMLDocument}.
   * <p>
   * @see #isBoolean()
   * <p>
   * @return true if this {@link ASTNode} returns a boolean, false otherwise.
   */ public
 boolean returnsBoolean() {
    return libsbmlJNI.ASTNode_returnsBoolean__SWIG_1(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents a MathML
   * constant (e.g., <code>true</code>, <code>Pi</code>).
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML constant, <code>false</code> otherwise.
   * <p>
   * @note this function will also return <code>true</code> for {@link 
   * libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} in SBML Level&nbsp;3.
   */ public
 boolean isConstant() {
    return libsbmlJNI.ASTNode_isConstant(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents a
   * MathML function (e.g., <code>abs()</code>), or an SBML Level&nbsp;1
   * function, or a user-defined function.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a function, <code>false</code> otherwise.
   */ public
 boolean isFunction() {
    return libsbmlJNI.ASTNode_isFunction(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents
   * the special IEEE 754 value infinity, <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is the special IEEE 754 value infinity,
   * <code>false</code> otherwise.
   */ public
 boolean isInfinity() {
    return libsbmlJNI.ASTNode_isInfinity(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node contains an
   * integer value, <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link 
   * libsbmlConstants#AST_INTEGER AST_INTEGER}, <code>false</code> otherwise.
   */ public
 boolean isInteger() {
    return libsbmlJNI.ASTNode_isInteger(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a MathML
   * <code>&lt;lambda&gt;</code>, <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link  libsbmlConstants#AST_LAMBDA
   * AST_LAMBDA}, <code>false</code> otherwise.
   */ public
 boolean isLambda() {
    return libsbmlJNI.ASTNode_isLambda(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents a 
   * <code>log10</code> function, <code>false</code> (zero) otherwise.  More precisely, this
   * predicate returns <code>true</code> if the node type is {@link 
   * libsbmlConstants#AST_FUNCTION_LOG AST_FUNCTION_LOG} with two
   * children, the first of which is an {@link  libsbmlConstants#AST_INTEGER
   * AST_INTEGER} equal to 10.
   * <p>
   * @return <code>true</code> if the given {@link ASTNode} represents a log10() function, 
   * <code>false</code> otherwise.
   * <p>
   * <p>
   * <p>
   * <p>
   * @see <code><a href='libsbml.html#parseL3Formula(String formula)'>libsbml.parseL3Formula(String formula)</a></code>
   */ public
 boolean isLog10() {
    return libsbmlJNI.ASTNode_isLog10(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a MathML
   * logical operator (i.e., <code>and</code>, <code>or</code>, <code>not</code>, <code>xor</code>).
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML logical operator
   */ public
 boolean isLogical() {
    return libsbmlJNI.ASTNode_isLogical(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a user-defined
   * variable name in SBML L1, L2 (MathML), or the special symbols <code>delay</code>
   * or <code>time.</code>  The predicate returns <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a user-defined variable name in SBML
   * L1, L2 (MathML) or the special symbols delay or time.
   */ public
 boolean isName() {
    return libsbmlJNI.ASTNode_isName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents the
   * special IEEE 754 value 'not a number' (NaN), <code>false</code> (zero)
   * otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is the special IEEE 754 NaN.
   */ public
 boolean isNaN() {
    return libsbmlJNI.ASTNode_isNaN(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents the
   * special IEEE 754 value 'negative infinity', <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is the special IEEE 754 value negative
   * infinity, <code>false</code> otherwise.
   */ public
 boolean isNegInfinity() {
    return libsbmlJNI.ASTNode_isNegInfinity(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node contains a number,
   * <code>false</code> (zero) otherwise.  This is functionally equivalent to the
   * following code:
   * <div class='fragment'><pre>
   *   isInteger() || isReal()</pre></div>
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a number, <code>false</code> otherwise.
   */ public
 boolean isNumber() {
    return libsbmlJNI.ASTNode_isNumber(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a mathematical
   * operator, meaning, <code>+</code>, <code>-</code>, <code>*</code>, 
   * <code>/</code> or <code>^</code> (power).
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is an operator.
   */ public
 boolean isOperator() {
    return libsbmlJNI.ASTNode_isOperator(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is the MathML
   * <code>&lt;piecewise&gt;</code> construct, <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML <code>piecewise</code> function
   */ public
 boolean isPiecewise() {
    return libsbmlJNI.ASTNode_isPiecewise(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents a rational
   * number, <code>false</code> (zero) otherwise.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link 
   * libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   */ public
 boolean isRational() {
    return libsbmlJNI.ASTNode_isRational(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node can represent a
   * real number, <code>false</code> (zero) otherwise.  More precisely, this node
   * must be of one of the following types: {@link  libsbmlConstants#AST_REAL
   * AST_REAL}, {@link  libsbmlConstants#AST_REAL_E AST_REAL_E} or
   * {@link  libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   * <p>
   * @return <code>true</code> if the value of this {@link ASTNode} can represented as a real
   * number, <code>false</code> otherwise.
   */ public
 boolean isReal() {
    return libsbmlJNI.ASTNode_isReal(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a MathML
   * relational operator, meaning <code>==</code>, <code>&gt;=</code>, 
   * <code>&gt;</code>, <code>&lt;</code>, and <code>!=</code>.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML relational operator, 
   * <code>false</code> otherwise
   */ public
 boolean isRelational() {
    return libsbmlJNI.ASTNode_isRelational(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node represents a
   * square root function, <code>false</code> (zero) otherwise.  More precisely, the
   * node type must be {@link  libsbmlConstants#AST_FUNCTION_ROOT
   * AST_FUNCTION_ROOT} with two children, the first of which is an
   * {@link  libsbmlConstants#AST_INTEGER AST_INTEGER} node having value
   * equal to 2.
   * <p>
   * @return <code>true</code> if the given {@link ASTNode} represents a sqrt() function,
   * <code>false</code> otherwise.
   */ public
 boolean isSqrt() {
    return libsbmlJNI.ASTNode_isSqrt(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a unary minus
   * operator, <code>false</code> (zero) otherwise.  A node is defined as a unary
   * minus node if it is of type {@link  libsbmlConstants#AST_MINUS
   * AST_MINUS} and has exactly one child.
   * <p>
   * For numbers, unary minus nodes can be 'collapsed' by negating the
   * number.  In fact, 
   * <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String formula)</a></code>
   * does this during its parsing process, and 
   * <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
   * has a configuration option that allows this behavior to be turned
   * on or off.  However, unary minus nodes for symbols
   * ({@link  libsbmlConstants#AST_NAME AST_NAME}) cannot
   * be 'collapsed', so this predicate function is necessary.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a unary minus, <code>false</code> otherwise.
   * <p>
   * <p>
   * <p>
   * <p>
   * @see <code><a href='libsbml.html#parseL3Formula(String formula)'>libsbml.parseL3Formula(String formula)</a></code>
   */ public
 boolean isUMinus() {
    return libsbmlJNI.ASTNode_isUMinus(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node is a unary plus
   * operator, <code>false</code> (zero) otherwise.  A node is defined as a unary
   * minus node if it is of type {@link  libsbmlConstants#AST_MINUS
   * AST_MINUS} and has exactly one child.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is a unary plus, <code>false</code> otherwise.
   */ public
 boolean isUPlus() {
    return libsbmlJNI.ASTNode_isUPlus(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node has an unknown type.
   * <p>
   * 'Unknown' nodes have the type {@link  libsbmlConstants#AST_UNKNOWN
   * AST_UNKNOWN}.  Nodes with unknown types will not appear in an
   * {@link ASTNode} tree returned by libSBML based upon valid SBML input; the only
   * situation in which a node with type {@link  libsbmlConstants#AST_UNKNOWN
   * AST_UNKNOWN} may appear is immediately after having create a
   * new, untyped node using the {@link ASTNode} constructor.  Callers creating
   * nodes should endeavor to set the type to a valid node type as soon as
   * possible after creating new nodes.
   * <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link 
   * libsbmlConstants#AST_UNKNOWN AST_UNKNOWN}, <code>false</code> otherwise.
   */ public
 boolean isUnknown() {
    return libsbmlJNI.ASTNode_isUnknown(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node has the mathml attribute
   * <code>id</code>.
   * <p>
   * @return true if this {@link ASTNode} has an attribute id, false otherwise.
   */ public
 boolean isSetId() {
    return libsbmlJNI.ASTNode_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node has the mathml attribute
   * <code>class</code>.
   * <p>
   * @return true if this {@link ASTNode} has an attribute class, false otherwise.
   */ public
 boolean isSetClass() {
    return libsbmlJNI.ASTNode_isSetClass(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node has the mathml attribute
   * <code>style</code>.
   * <p>
   * @return true if this {@link ASTNode} has an attribute style, false otherwise.
   */ public
 boolean isSetStyle() {
    return libsbmlJNI.ASTNode_isSetStyle(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node has the attribute
   * <code>sbml:units</code>.
   * <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing {@link Model}.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class='fragment'>&lt;math xmlns='http://www.w3.org/1998/Math/MathML'
      xmlns:sbml='http://www.sbml.org/sbml/level3/version1/core'&gt;
        &lt;cn type='integer' sbml:units='second'&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   * <p>
   * @return <code>true</code> if this {@link ASTNode} has units associated with it, <code>false</code> otherwise.
   * <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   */ public
 boolean isSetUnits() {
    return libsbmlJNI.ASTNode_isSetUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> (non-zero) if this node or any of its
   * children nodes have the attribute <code>sbml:units</code>.
   * <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing {@link Model}.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class='fragment'>&lt;math xmlns='http://www.w3.org/1998/Math/MathML'
      xmlns:sbml='http://www.sbml.org/sbml/level3/version1/core'&gt;
        &lt;cn type='integer' sbml:units='second'&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   * <p>
   * @return <code>true</code> if this {@link ASTNode} or its children has units associated
   * with it, <code>false</code> otherwise.
   * <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   */ public
 boolean hasUnits() {
    return libsbmlJNI.ASTNode_hasUnits(swigCPtr, this);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given character.  If character
   * is one of <code>+</code>, <code>-</code>, <code>*</code>, <code>/</code> or <code>^</code>, the node
   * type will be set accordingly.  For all other characters, the node type
   * will be set to {@link  libsbmlConstants#AST_UNKNOWN AST_UNKNOWN}.
   * <p>
   * @param value the character value to which the node's value should be
   * set.
   * <p>
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setCharacter(char value) {
    return libsbmlJNI.ASTNode_setCharacter(swigCPtr, this, value);
  }

  
/**
   * Sets the mathml id of this {@link ASTNode} to id.
   * <p>
   * @param id <code>string</code> representing the identifier.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setId(String id) {
    return libsbmlJNI.ASTNode_setId(swigCPtr, this, id);
  }

  
/**
   * Sets the mathml class of this {@link ASTNode} to className.
   * <p>
   * @param className <code>string</code> representing the mathml class for this node.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setClassName(String className) {
    return libsbmlJNI.ASTNode_setClassName(swigCPtr, this, className);
  }

  
/**
   * Sets the mathml style of this {@link ASTNode} to style.
   * <p>
   * @param style <code>string</code> representing the identifier.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setStyle(String style) {
    return libsbmlJNI.ASTNode_setStyle(swigCPtr, this, style);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given name.
   * <p>
   * As a side-effect, this {@link ASTNode} object's type will be reset to
   * {@link  libsbmlConstants#AST_NAME AST_NAME} if (and <em>only
   * if</em>) the {@link ASTNode} was previously an operator (
   * {@link ASTNode#isOperator()}
   * <code>== true</code>), number (
   * {@link ASTNode#isNumber()}
   * <code>== true</code>), or unknown.
   * This allows names to be set for {@link  libsbmlConstants#AST_FUNCTION
   * AST_FUNCTION} nodes and the like.
   * <p>
   * @param name the string containing the name to which this node's value
   * should be set
   * <p>
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.ASTNode_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given (<code>long</code>) integer and sets
   * the node type to {@link  libsbmlConstants#AST_INTEGER AST_INTEGER}.
   * <p>
   * @param value the integer to which this node's value should be set
   * <p>
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setValue(int value) {
    return libsbmlJNI.ASTNode_setValue__SWIG_0(swigCPtr, this, value);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given rational in two parts: the
   * numerator and denominator.  The node type is set to {@link 
   * libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   * <p>
   * @param numerator the numerator value of the rational
   * @param denominator the denominator value of the rational
   * <p>
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setValue(int numerator, int denominator) {
    return libsbmlJNI.ASTNode_setValue__SWIG_1(swigCPtr, this, numerator, denominator);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given real (<code>double</code>) and sets
   * the node type to {@link  libsbmlConstants#AST_REAL AST_REAL}.
   * <p>
   * This is functionally equivalent to:
   * <div class='fragment'><pre>
   * setValue(value, 0);</pre></div>
   * <p>
   * @param value the <code>double</code> format number to which this node's value
   * should be set
   * <p>
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are: @li {@link 
   * libsbmlConstants#LIBSBML_OPERATION_SUCCESS
   * LIBSBML_OPERATION_SUCCESS }
   */ public
 int setValue(double value) {
    return libsbmlJNI.ASTNode_setValue__SWIG_2(swigCPtr, this, value);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given real (<code>double</code>) in two
   * parts: the mantissa and the exponent.  The node type is set to
   * {@link  libsbmlConstants#AST_REAL_E AST_REAL_E}.
   * <p>
   * @param mantissa the mantissa of this node's real-numbered value
   * @param exponent the exponent of this node's real-numbered value
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setValue(double mantissa, int exponent) {
    return libsbmlJNI.ASTNode_setValue__SWIG_3(swigCPtr, this, mantissa, exponent);
  }

  
/**
   * Sets the type of this {@link ASTNode} to the given type code.  A side-effect
   * of doing this is that any numerical values previously stored in this
   * node are reset to zero.
   * <p>
   * @param type the type to which this node should be set
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setType(int type) {
    return libsbmlJNI.ASTNode_setType(swigCPtr, this, type);
  }

  
/**
   * Sets the units of this {@link ASTNode} to units.
   * <p>
   * The units will be set <em>only</em> if this {@link ASTNode} object represents a
   * MathML <code>&lt;cn&gt;</code> element, i.e., represents a number.
   * Callers may use
   * {@link ASTNode#isNumber()}
   * to inquire whether the node is of that type.
   * <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing {@link Model}.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class='fragment'>&lt;math xmlns='http://www.w3.org/1998/Math/MathML'
      xmlns:sbml='http://www.sbml.org/sbml/level3/version1/core'&gt;
        &lt;cn type='integer' sbml:units='second'&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   * <p>
   * @param units <code>string</code> representing the unit identifier.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   * <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   */ public
 int setUnits(String units) {
    return libsbmlJNI.ASTNode_setUnits(swigCPtr, this, units);
  }

  
/**
   * Swap the children of this {@link ASTNode} object with the children of the
   * given {@link ASTNode} object.
   * <p>
   * @param that the other node whose children should be used to replace
   * <em>this</em> node's children
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int swapChildren(ASTNode that) {
    return libsbmlJNI.ASTNode_swapChildren(swigCPtr, this, ASTNode.getCPtr(that), that);
  }

  
/**
   * Renames all the SIdRef attributes on this node and any child node
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.ASTNode_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * Renames all the UnitSIdRef attributes on this node and any child node.
   * (The only place UnitSIDRefs appear in MathML <code>&lt;cn&gt;</code> elements.)
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.ASTNode_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * Replace any nodes of type AST_NAME with the name 'id' from the child 'math' object with the provided {@link ASTNode}. 
   * <p>
   * @internal
   */ public
 void replaceIDWithFunction(String id, ASTNode function) {
    libsbmlJNI.ASTNode_replaceIDWithFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/**
   * Replaces any 'AST_NAME_TIME' nodes with a node that multiplies time by the given function.
   * <p>
   * @internal
   */ public
 void multiplyTimeBy(ASTNode function) {
    libsbmlJNI.ASTNode_multiplyTimeBy(swigCPtr, this, ASTNode.getCPtr(function), function);
  }

  
/**
   * Unsets the units of this {@link ASTNode}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetUnits() {
    return libsbmlJNI.ASTNode_unsetUnits(swigCPtr, this);
  }

  
/**
   * Unsets the mathml id of this {@link ASTNode}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetId() {
    return libsbmlJNI.ASTNode_unsetId(swigCPtr, this);
  }

  
/**
   * Unsets the mathml class of this {@link ASTNode}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetClass() {
    return libsbmlJNI.ASTNode_unsetClass(swigCPtr, this);
  }

  
/**
   * Unsets the mathml style of this {@link ASTNode}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetStyle() {
    return libsbmlJNI.ASTNode_unsetStyle(swigCPtr, this);
  }

  
/**
   * Gets the MathML <code>definitionURL</code> attribute value.
   * <p>
   * @return the value of the <code>definitionURL</code> attribute, in the form of
   * a libSBML {@link XMLAttributes} object.
   */ public
 XMLAttributes getDefinitionURL() {
    long cPtr = libsbmlJNI.ASTNode_getDefinitionURL(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLAttributes(cPtr, false);
  }

  
/**
   * Replaces occurences of a given name within this {@link ASTNode} with the
   * name/value/formula represented by <code>arg</code>.
   * <p>
   * For example, if the formula in this {@link ASTNode} is <code>x + y</code>,
   * then the <code>&lt;bvar&gt;</code> is <code>x</code> and <code>arg</code> is an {@link ASTNode}
   * representing the real value <code>3.</code>  This method substitutes <code>3</code> for 
   * <code>x</code> within this {@link ASTNode} object.
   * <p>
   * @param bvar a string representing the variable name to be substituted
   * @param arg an {@link ASTNode} representing the name/value/formula to substitute
   */ public
 void replaceArgument(String bvar, ASTNode arg) {
    libsbmlJNI.ASTNode_replaceArgument(swigCPtr, this, bvar, ASTNode.getCPtr(arg), arg);
  }

  
/**
   * Returns the parent SBML object.
   * <p>
   * @return the parent SBML object of this {@link ASTNode}.
   */ public
 SBase getParentSBMLObject() {
  return libsbml.DowncastSBase(libsbmlJNI.ASTNode_getParentSBMLObject(swigCPtr, this), false);
}

  
/**
   * Reduces this {@link ASTNode} to a binary tree.
   * <p>
   * Example: if this {@link ASTNode} is <code>and(x, y, z)</code>, then the 
   * formula of the reduced node is <code>and(and(x, y), z)</code>.  The
   * operation replaces the formula stored in the current {@link ASTNode} object.
   */ public
 void reduceToBinary() {
    libsbmlJNI.ASTNode_reduceToBinary(swigCPtr, this);
  }

  
/**
  * Predicate returning <code>true</code> or <code>false</code> depending on whether this
  * {@link ASTNode} is well-formed.
  * <p>
  * @note An {@link ASTNode} may be well-formed, with each node and its children
  * having the appropriate number of children for the given type, but may
  * still be invalid in the context of its use within an SBML model.
  * <p>
  * @return <code>true</code> if this {@link ASTNode} is well-formed, <code>false</code> otherwise.
  * <p>
  * @see #hasCorrectNumberArguments()
  */ public
 boolean isWellFormedASTNode() {
    return libsbmlJNI.ASTNode_isWellFormedASTNode(swigCPtr, this);
  }

  
/**
  * Predicate returning <code>true</code> or <code>false</code> depending on whether this
  * {@link ASTNode} has the correct number of children for it's type.
  * <p>
  * For example, an {@link ASTNode} with type {@link  libsbmlConstants#AST_PLUS
  * AST_PLUS} expects 2 child nodes.
  * <p>
  * @note This function performs a check on the toplevel node only.
  * Child nodes are not checked.
  * <p>
  * @return <code>true</code> if this {@link ASTNode} is has appropriate number of children
  * for it's type, <code>false</code> otherwise.
  * <p>
  * @see #isWellFormedASTNode()
  */ public
 boolean hasCorrectNumberArguments() {
    return libsbmlJNI.ASTNode_hasCorrectNumberArguments(swigCPtr, this);
  }

  
/**
  * Predicate returning <code>true</code> or <code>false</code> depending on whether this
  * {@link ASTNode} has the correct number of children for it's type.
  * <p>
  * For example, an {@link ASTNode} with type {@link  libsbmlConstants#AST_PLUS
  * AST_PLUS} expects 2 child nodes.
  * <p>
  * @note This function performs a check on the toplevel node only.
  * Child nodes are not checked.
  * <p>
  * @return <code>true</code> if this {@link ASTNode} is has appropriate number of children
  * for it's type, <code>false</code> otherwise.
  * <p>
  * @see #isWellFormedASTNode()
  * @internal
  */ public
 boolean isBvar() {
    return libsbmlJNI.ASTNode_isBvar(swigCPtr, this);
  }

  
/**
  * Predicate returning <code>true</code> or <code>false</code> depending on whether this
  * {@link ASTNode} has the correct number of children for it's type.
  * <p>
  * For example, an {@link ASTNode} with type {@link  libsbmlConstants#AST_PLUS
  * AST_PLUS} expects 2 child nodes.
  * <p>
  * @note This function performs a check on the toplevel node only.
  * Child nodes are not checked.
  * <p>
  * @return <code>true</code> if this {@link ASTNode} is has appropriate number of children
  * for it's type, <code>false</code> otherwise.
  * <p>
  * @see #isWellFormedASTNode()
  * @internal
  */ public
 void setBvar() {
    libsbmlJNI.ASTNode_setBvar(swigCPtr, this);
  }

  
  /**
   * Performs a depth-first search of the tree rooted at this {@link ASTNode}
   * object, and returns an {@link ASTNodeList} of all nodes.
   *
   * @return the list of {@link ASTNode} objects.
   */
 public ASTNodeList getListOfNodes() {
    long cPtr = libsbmlJNI.ASTNode_getListOfNodes(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNodeList(cPtr, true);
  }

}
