/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Base class for SBML validators
 * <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 * <p>
 * LibSBML implements facilities for verifying that a given SBML document
 * is valid according to the SBML specifications; it also exposes the
 * validation interface so that user programs and SBML Level&nbsp;3 package
 * authors may use the facilities to implement new validators.  There are
 * two main interfaces to libSBML's validation facilities, based on the
 * classes Validator and SBMLValidator.
 * <p>
 * The Validator class is the basis of the system for validating an SBML
 * document against the validation rules defined in the SBML
 * specifications.  The scheme used by Validator relies is compact and uses
 * the <em>visitor</em> programming pattern, but it relies on C/C++ features and
 * is not directly accessible from language bindings.  SBMLValidator offers
 * a framework for straightforward class-based extensibility, so that user
 * code can subclass SBMLValidator to implement new validation systems,
 * different validators can be introduced or turned off at run-time, and
 * interfaces can be provided in the libSBML language bindings.
 * SBMLValidator can call Validator functionality internally (as is the
 * case in the current implementation of SBMLInternalValidator) or use
 * entirely different implementation approaches, as necessary.
 * <p>
 * Users of libSBML may already be familiar with the facilities encompassed
 * by the validation system, in the form of the consistency-checking methods
 * defined on {@link SBMLDocument}.  The methods {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)},
 * {@link SBMLDocument#checkConsistency()}, {@link SBMLDocument#checkInternalConsistency()}
 * and other method of that sort are in fact implemented via SBMLValidator,
 * specifically as methods on the class SBMLInternalValidator.
 * <p>
 * Authors may use SBMLValidator as the base class for their own validator
 * extensions to libSBML.  The class SBMLInternalValidator may serve as a
 * code example for how to implement such things.
 */

public class SBMLValidator {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBMLValidator(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBMLValidator obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLValidator obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLValidator(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  protected void swigDirectorDisconnect() {
    swigCMemOwn = false;
    delete();
  }

  public void swigReleaseOwnership() {
    swigCMemOwn = false;
    libsbmlJNI.SBMLValidator_change_ownership(this, swigCPtr, false);
  }

  public void swigTakeOwnership() {
    swigCMemOwn = true;
    libsbmlJNI.SBMLValidator_change_ownership(this, swigCPtr, true);
  }

  
/**
   * Creates a new SBMLValidator.
   */ public
 SBMLValidator() {
    this(libsbmlJNI.new_SBMLValidator__SWIG_0(), true);
    libsbmlJNI.SBMLValidator_director_connect(this, swigCPtr, swigCMemOwn, true);
  }

  
/**
   * Copy constructor; creates a copy of an SBMLValidator object.
   * <p>
   * @param orig the object to copy.
   * <p>
   * @throws SBMLConstructorException 
   * Thrown if the argument <code>orig</code> is <code>null.</code>
   */ public
 SBMLValidator(SBMLValidator orig) {
    this(libsbmlJNI.new_SBMLValidator__SWIG_1(SBMLValidator.getCPtr(orig), orig), true);
    libsbmlJNI.SBMLValidator_director_connect(this, swigCPtr, swigCMemOwn, true);
  }

  
/**
   * Creates and returns a deep copy of this SBMLValidator.
   * <p>
   * @return a (deep) copy of this SBMLValidator.
   */ public
 SBMLValidator cloneObject() {
    long cPtr = (getClass() == SBMLValidator.class) ? libsbmlJNI.SBMLValidator_cloneObject(swigCPtr, this) : libsbmlJNI.SBMLValidator_cloneObjectSwigExplicitSBMLValidator(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLValidator(cPtr, true);
  }

  
/**
   * Returns the current SBML document in use by this validator.
   * <p>
   * @return the current SBML document
   * <p>
   * @see #setDocument(SBMLDocument doc)
   */ public
 SBMLDocument getDocument() {
    long cPtr = (getClass() == SBMLValidator.class) ? libsbmlJNI.SBMLValidator_getDocument__SWIG_0(swigCPtr, this) : libsbmlJNI.SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, false);
  }

  
/** 
   * Sets the current SBML document to the given {@link SBMLDocument} object.
   * <p>
   * @param doc the document to use for this validation
   * <p>
   * @return an integer value indicating the success/failure of the
   * validation.   The possible values returned by this
   * function are
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   * <p>
   * @see #getDocument()
   */ public
 int setDocument(SBMLDocument doc) {
    return (getClass() == SBMLValidator.class) ? libsbmlJNI.SBMLValidator_setDocument(swigCPtr, this, SBMLDocument.getCPtr(doc), doc) : libsbmlJNI.SBMLValidator_setDocumentSwigExplicitSBMLValidator(swigCPtr, this, SBMLDocument.getCPtr(doc), doc);
  }

  
/** 
   * Runs this validator on the current SBML document.
   * <p>
   * @return an integer value indicating the success/failure of the
   * validation.   The possible values returned by this
   * function are determined by the specific subclasses of this class.
   */ public
 long validate() {
    return (getClass() == SBMLValidator.class) ? libsbmlJNI.SBMLValidator_validate__SWIG_0(swigCPtr, this) : libsbmlJNI.SBMLValidator_validateSwigExplicitSBMLValidator__SWIG_0(swigCPtr, this);
  }

  
/**
   * Clears this validator's list of failures.
   * <p>
   * If you are validating multiple SBML documents with the same validator,
   * call this method after you have processed the list of failures from
   * the last validation run and before validating the next document.
   * <p>
   * <p>
   */ public
 void clearFailures() {
    if (getClass() == SBMLValidator.class) libsbmlJNI.SBMLValidator_clearFailures(swigCPtr, this); else libsbmlJNI.SBMLValidator_clearFailuresSwigExplicitSBMLValidator(swigCPtr, this);
  }

  
/**
   * Adds the given failure to this list of Validators failures.
   * <p>
   * @param err an {@link SBMLError} object representing an error or warning
   * <p>
   * <p>
   */ public
 void logFailure(SBMLError err) {
    libsbmlJNI.SBMLValidator_logFailure(swigCPtr, this, SBMLError.getCPtr(err), err);
  }

  
/**
   * Validates the given {@link SBMLDocument} object.
   * <p>
   * This is identical to calling setDocument(SBMLDocument d )
   * followed by validate().
   * <p>
   * @param d the SBML document to validate
   * <p>
   * @return the number of validation failures that occurred.  The objects
   * describing the actual failures can be retrieved using getFailures().
   */ public
 long validate(SBMLDocument d) {
    return libsbmlJNI.SBMLValidator_validate__SWIG_1(swigCPtr, this, SBMLDocument.getCPtr(d), d);
  }

  
/**
   * Validates the SBML document located at the given <code>filename</code>.
   * <p>
   * This is a convenience method that saves callers the trouble of
   * using {@link SBMLReader} to read the document first.
   * <p>
   * @param filename the path to the file to be read and validated.
   * <p>
   * @return the number of validation failures that occurred.  The objects
   * describing the actual failures can be retrieved using getFailures().
   */ public
 long validate(String filename) {
    return libsbmlJNI.SBMLValidator_validate__SWIG_2(swigCPtr, this, libsbml.getAbsolutePath(filename));
  }

  
/**
   * Returns the list of errors or warnings logged during parsing,
   * consistency checking, or attempted translation of this model.
   * <p>
   * Note that this refers to the {@link SBMLDocument} object's error log (i.e.,
   * the list returned by {@link SBMLDocument#getErrorLog()}).  <em>That</em> list of
   * errors and warnings is <em>separate</em> from the validation failures
   * tracked by this validator (i.e., the list returned by getFailures()).
   * <p>
   * @return the {@link SBMLErrorLog} used for the {@link SBMLDocument}
   * <p>
   * <p>
   */ public
 SBMLErrorLog getErrorLog() {
    long cPtr = libsbmlJNI.SBMLValidator_getErrorLog(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLErrorLog(cPtr, false);
  }

  
/**
   * Returns the {@link Model} object stored in the {@link SBMLDocument}.
   * <p>
   * It is important to note that this method <em>does not create</em> a
   * {@link Model} instance.  The model in the {@link SBMLDocument} must have been created
   * at some prior time, for example using {@link SBMLDocument#createModel()} 
   * or {@link SBMLDocument#setModel(Model m)}.
   * This method returns <code>null</code> if a model does not yet exist.
   * <p>
   * @return the {@link Model} contained in this validator's {@link SBMLDocument} object.
   * <p>
   * @see SBMLDocument#setModel(Model m)
   * @see SBMLDocument#createModel()
   */ public
 Model getModel() {
    long cPtr = libsbmlJNI.SBMLValidator_getModel__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
/** 
   * Returns the number of failures encountered in the last validation run.
   * <p>
   * This method returns the number of failures logged by this validator.
   * This number only reflects <em>this</em> validator's actions; the number may
   * not be the same as the number of errors and warnings logged on the
   * {@link SBMLDocument} object's error log (i.e., the object returned by
   * {@link SBMLDocument#getErrorLog()}), because other parts of libSBML may log
   * errors and warnings beyond those found by this validator.
   * <p>
   * @return the number of errors logged by this validator. 
   */ public
 long getNumFailures() {
    return libsbmlJNI.SBMLValidator_getNumFailures(swigCPtr, this);
  }

  
/** 
   * Returns the failure object at index n in this validator's list of
   * failures logged during the last run.
   * <p>
   * Callers should use getNumFailures() first, to find out the number
   * of entries in this validator's list of failures.
   * <p>
   * @param n an integer indicating the index of the object to return from
   * the failures list; index values start at 0.
   * <p>
   * @return the failure at the given index number.
   * <p>
   * @see #getNumFailures()
   */ public
 SBMLError getFailure(long n) {
    long cPtr = libsbmlJNI.SBMLValidator_getFailure(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SBMLError(cPtr, false);
  }

}
