///  @file    TestL3FormulaParserC.cs
///  @brief   L3FormulaParser unit tests
///  @author  Frank Bergmann (Csharp conversion)
///  @author  Akiya Jouraku (Csharp conversion)
///  @author  Ben Bornstein
 
///  
///  ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
/// 
///  DO NOT EDIT THIS FILE.
/// 
///  This file was generated automatically by converting the file located at
///  src/sbml/test/TestL3FormulaParserC.c
///  using the conversion program dev/utilities/translateTests/translateTests.pl.
///  Any changes made here will be lost the next time the file is regenerated.
/// 
///  -----------------------------------------------------------------------------
///  This file is part of libSBML.  Please visit http://sbml.org for more
///  information about SBML, and the latest version of libSBML.
/// 
///  Copyright 2005-2010 California Institute of Technology.
///  Copyright 2002-2005 California Institute of Technology and
///                      Japan Science and Technology Corporation.
///  
///  This library is free software; you can redistribute it and/or modify it
///  under the terms of the GNU Lesser General Public License as published by
///  the Free Software Foundation.  A copy of the license agreement is provided
///  in the file named "LICENSE.txt" included with this software distribution
///  and also available online as http://sbml.org/software/libsbml/license.html
///  -----------------------------------------------------------------------------


namespace LibSBMLCSTest.math {

  using libsbmlcs;

  using System;

  using System.IO;

  public class TestL3FormulaParserC {
    public class AssertionError : System.Exception 
    {
      public AssertionError() : base()
      {
        
      }
    }


    static void assertTrue(bool condition)
    {
      if (condition == true)
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        return;
      }
      else if ( (a == null) || (b == null) )
      {
        throw new AssertionError();
      }
      else if (a.Equals(b))
      {
        return;
      }
  
      throw new AssertionError();
    }

    static void assertNotEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        throw new AssertionError();
      }
      else if ( (a == null) || (b == null) )
      {
        return;
      }
      else if (a.Equals(b))
      {
        throw new AssertionError();
      }
    }

    static void assertEquals(bool a, bool b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(bool a, bool b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(int a, int b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(int a, int b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }


    public void test_SBML_C_parseL3Formula_1()
    {
      ASTNode r = libsbml.parseL3Formula("1");
      assertTrue( r.getType() == libsbml.AST_INTEGER );
      assertTrue( r.getInteger() == 1 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_10()
    {
      ASTNode r = libsbml.parseL3Formula("1 + -2e100 / 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_PLUS );
      assertTrue( r.getCharacter() == '+' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_DIVIDE );
      assertTrue( c.getCharacter() == '/' );
      assertTrue( c.getNumChildren() == 2 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getCharacter() == '-' );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL_E );
      assertTrue( c.getMantissa() == 2 );
      assertTrue( c.getExponent() == 100 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_11()
    {
      ASTNode r = libsbml.parseL3Formula("1 - -foo / 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getCharacter() == '-' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_DIVIDE );
      assertTrue( c.getCharacter() == '/' );
      assertTrue( c.getNumChildren() == 2 );
      c = r.getRightChild().getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getCharacter() == '-' );
      assertTrue( c.getNumChildren() == 1 );
      c = r.getRightChild().getLeftChild().getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "foo" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_12()
    {
      ASTNode r = libsbml.parseL3Formula("2 * foo^bar + 3.0");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_PLUS );
      assertTrue( r.getCharacter() == '+' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_TIMES );
      assertTrue( c.getCharacter() == '*' );
      assertTrue( c.getNumChildren() == 2 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 3.0 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_POWER );
      assertTrue( c.getCharacter() == '^' );
      assertTrue( c.getNumChildren() == 2 );
      c = r.getLeftChild().getRightChild().getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "foo" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getRightChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "bar" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_13()
    {
      ASTNode r = libsbml.parseL3Formula("foo()");
      assertTrue( r.getType() == libsbml.AST_FUNCTION );
      assertTrue((  "foo" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_14()
    {
      ASTNode r = libsbml.parseL3Formula("foo(1)");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_FUNCTION );
      assertTrue((  "foo" == r.getName() ));
      assertTrue( r.getNumChildren() == 1 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_15()
    {
      ASTNode r = libsbml.parseL3Formula("foo(1, bar)");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_FUNCTION );
      assertTrue((  "foo" == r.getName() ));
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "bar" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_16()
    {
      ASTNode r = libsbml.parseL3Formula("foo(1, bar, 2^-3)");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_FUNCTION );
      assertTrue((  "foo" == r.getName() ));
      assertTrue( r.getNumChildren() == 3 );
      c = r.getChild(0);
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getChild(1);
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "bar" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getChild(2);
      assertTrue( c.getType() == libsbml.AST_POWER );
      assertTrue( c.getCharacter() == '^' );
      assertTrue( c.getNumChildren() == 2 );
      c = r.getChild(2).getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getChild(2).getRightChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getCharacter() == '-' );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_17()
    {
      ASTNode r = libsbml.parseL3Formula("1//1");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input '1//1' at position 3:  syntax error, unexpected '/'" == libsbml.getLastParseL3Error() ));
    }

    public void test_SBML_C_parseL3Formula_18()
    {
      ASTNode r = libsbml.parseL3Formula("1+2*3 4");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input '1+2*3 4' at position 7:  syntax error, unexpected integer" == libsbml.getLastParseL3Error() ));
    }

    public void test_SBML_C_parseL3Formula_2()
    {
      ASTNode r = libsbml.parseL3Formula("2.1");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getReal() == 2.1 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_3()
    {
      ASTNode r = libsbml.parseL3Formula("2.1e5");
      assertTrue( r.getType() == libsbml.AST_REAL_E );
      assertTrue( r.getMantissa() == 2.1 );
      assertTrue( r.getExponent() == 5 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_4()
    {
      ASTNode r = libsbml.parseL3Formula("foo");
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "foo" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_5()
    {
      ASTNode r = libsbml.parseL3Formula("1 + foo");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_PLUS );
      assertTrue( r.getCharacter() == '+' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "foo" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_6()
    {
      ASTNode r = libsbml.parseL3Formula("1 + 2");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_PLUS );
      assertTrue( r.getCharacter() == '+' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_7()
    {
      ASTNode r = libsbml.parseL3Formula("1 + 2 * 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_PLUS );
      assertTrue( r.getCharacter() == '+' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_TIMES );
      assertTrue( c.getCharacter() == '*' );
      assertTrue( c.getNumChildren() == 2 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_8()
    {
      ASTNode r = libsbml.parseL3Formula("(1 - 2) * 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_TIMES );
      assertTrue( r.getCharacter() == '*' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getCharacter() == '-' );
      assertTrue( c.getNumChildren() == 2 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_9()
    {
      ASTNode r = libsbml.parseL3Formula("1 + -2 / 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_PLUS );
      assertTrue( r.getCharacter() == '+' );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_DIVIDE );
      assertTrue( c.getCharacter() == '/' );
      assertTrue( c.getNumChildren() == 2 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getCharacter() == '-' );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_arguments()
    {
      ASTNode r = libsbml.parseL3Formula("sin(x,y)");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'sin(x,y)' at position 8:  The function 'sin' takes exactly one argument, but 2 were found." == libsbml.getLastParseL3Error() ));
      r = libsbml.parseL3Formula("delay(x)");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'delay(x)' at position 8:  The function 'delay' takes exactly two arguments, but 1 were found." == libsbml.getLastParseL3Error() ));
      r = libsbml.parseL3Formula("piecewise()");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'piecewise()' at position 11:  The function 'piecewise' takes at least one argument, but none were found." == libsbml.getLastParseL3Error() ));
      r = libsbml.parseL3Formula("gt(x)");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'gt(x)' at position 5:  The function 'gt' takes at least two arguments, but 1 were found." == libsbml.getLastParseL3Error() ));
      r = libsbml.parseL3Formula("minus()");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'minus()' at position 7:  The function 'minus' takes exactly one or two arguments, but 0 were found." == libsbml.getLastParseL3Error() ));
      r = libsbml.parseL3Formula("root(x, y, z)");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'root(x, y, z)' at position 13:  The function 'root' takes exactly one or two arguments, but 3 were found." == libsbml.getLastParseL3Error() ));
      r = libsbml.parseL3Formula("power()");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'power()' at position 7:  The function 'power' takes exactly two arguments, but 0 were found." == libsbml.getLastParseL3Error() ));
    }

    public void test_SBML_C_parseL3Formula_avogadrosettings()
    {
      ASTNode r = libsbml.parseL3Formula("avogadro");
      assertTrue( r.getType() == libsbml.AST_NAME_AVOGADRO );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseAvogadroCsymbol(false);
      assertTrue( settings.getParseAvogadroCsymbol() == false );
      r = libsbml.parseL3FormulaWithSettings("avogadro", settings);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "avogadro" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings.setParseAvogadroCsymbol(true);
      assertTrue( settings.getParseAvogadroCsymbol() == true );
      r = libsbml.parseL3FormulaWithSettings("avogadro", settings);
      assertTrue( r.getType() == libsbml.AST_NAME_AVOGADRO );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_collapseminussettings1()
    {
      ASTNode r = libsbml.parseL3Formula("--4.4");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 1 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseCollapseMinus(true);
      assertTrue( settings.getParseCollapseMinus() == true );
      r = libsbml.parseL3FormulaWithSettings("--4.4", settings);
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getReal() == 4.4 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings.setParseCollapseMinus(false);
      assertTrue( settings.getParseCollapseMinus() == false );
      r = libsbml.parseL3FormulaWithSettings("--4.4", settings);
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 1 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_collapseminussettings2()
    {
      ASTNode r = libsbml.parseL3Formula("--x");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 1 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseCollapseMinus(true);
      assertTrue( settings.getParseCollapseMinus() == true );
      r = libsbml.parseL3FormulaWithSettings("--x", settings);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings.setParseCollapseMinus(false);
      assertTrue( settings.getParseCollapseMinus() == false );
      r = libsbml.parseL3FormulaWithSettings("--x", settings);
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 1 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_collapseminussettings3()
    {
      ASTNode r = libsbml.parseL3Formula("x---4.4");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseCollapseMinus(true);
      assertTrue( settings.getParseCollapseMinus() == true );
      r = libsbml.parseL3FormulaWithSettings("x---4.4", settings);
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings.setParseCollapseMinus(false);
      assertTrue( settings.getParseCollapseMinus() == false );
      r = libsbml.parseL3FormulaWithSettings("x---4.4", settings);
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_collapseminussettings4()
    {
      ASTNode r = libsbml.parseL3Formula("x---y");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "y" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseCollapseMinus(true);
      assertTrue( settings.getParseCollapseMinus() == true );
      r = libsbml.parseL3FormulaWithSettings("x---y", settings);
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "y" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings.setParseCollapseMinus(false);
      assertTrue( settings.getParseCollapseMinus() == false );
      r = libsbml.parseL3FormulaWithSettings("x---y", settings);
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_MINUS );
      assertTrue( c.getNumChildren() == 1 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "y" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_collapseminussettings5()
    {
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseCollapseMinus(true);
      assertTrue( settings.getParseCollapseMinus() == true );
      ASTNode r = libsbml.parseL3FormulaWithSettings("---4", settings);
      assertTrue( r.getType() == libsbml.AST_INTEGER );
      assertTrue( r.getInteger() == -4 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3FormulaWithSettings("---(3/8)", settings);
      assertTrue( r.getType() == libsbml.AST_RATIONAL );
      assertTrue( r.getNumerator() == -3 );
      assertTrue( r.getDenominator() == 8 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3FormulaWithSettings("---(-3/8)", settings);
      assertTrue( r.getType() == libsbml.AST_RATIONAL );
      assertTrue( r.getNumerator() == 3 );
      assertTrue( r.getDenominator() == 8 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3FormulaWithSettings("---4.4", settings);
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getReal() == -4.4 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3FormulaWithSettings("---4e-3", settings);
      assertTrue( r.getType() == libsbml.AST_REAL_E );
      assertTrue( r.getMantissa() == -4 );
      assertTrue( r.getExponent() == -3 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3FormulaWithSettings("---.4", settings);
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getReal() == -.4 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_constants1()
    {
      ASTNode r = libsbml.parseL3Formula("true");
      assertTrue( r.getType() == libsbml.AST_CONSTANT_TRUE );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants10()
    {
      ASTNode r = libsbml.parseL3Formula("notanumber");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants11()
    {
      ASTNode r = libsbml.parseL3Formula("nan");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants12()
    {
      ASTNode r = libsbml.parseL3Formula("NaN");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants2()
    {
      ASTNode r = libsbml.parseL3Formula("false");
      assertTrue( r.getType() == libsbml.AST_CONSTANT_FALSE );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants3()
    {
      ASTNode r = libsbml.parseL3Formula("pi");
      assertTrue( r.getType() == libsbml.AST_CONSTANT_PI );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants4()
    {
      ASTNode r = libsbml.parseL3Formula("exponentiale");
      assertTrue( r.getType() == libsbml.AST_CONSTANT_E );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants5()
    {
      ASTNode r = libsbml.parseL3Formula("avogadro");
      assertTrue( r.getType() == libsbml.AST_NAME_AVOGADRO );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants6()
    {
      ASTNode r = libsbml.parseL3Formula("time");
      assertTrue( r.getType() == libsbml.AST_NAME_TIME );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants7()
    {
      ASTNode r = libsbml.parseL3Formula("inf");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants8()
    {
      ASTNode r = libsbml.parseL3Formula("infinity");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_constants9()
    {
      ASTNode r = libsbml.parseL3Formula("INF");
      assertTrue( r.getType() == libsbml.AST_REAL );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_e1()
    {
      ASTNode r = libsbml.parseL3Formula("2.001e+5");
      assertTrue( r.getType() == libsbml.AST_REAL_E );
      assertTrue( r.getMantissa() == 2.001 );
      assertTrue( r.getExponent() == 5 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_e2()
    {
      ASTNode r = libsbml.parseL3Formula(".001e+5");
      assertTrue( r.getType() == libsbml.AST_REAL_E );
      assertTrue( r.getMantissa() == .001 );
      assertTrue( r.getExponent() == 5 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_e3()
    {
      ASTNode r = libsbml.parseL3Formula(".001e-5");
      assertTrue( r.getType() == libsbml.AST_REAL_E );
      assertTrue( r.getMantissa() == .001 );
      assertTrue( r.getExponent() == -5 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_e4()
    {
      ASTNode r = libsbml.parseL3Formula("2.e-005");
      assertTrue( r.getType() == libsbml.AST_REAL_E );
      assertTrue( r.getMantissa() == 2 );
      assertTrue( r.getExponent() == -5 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_e5()
    {
      ASTNode r = libsbml.parseL3Formula(".e+5");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input '.e+5' at position 1:  syntax error, unexpected $undefined" == libsbml.getLastParseL3Error() ));
      r = null;
    }

    public void test_SBML_C_parseL3Formula_logic1()
    {
      ASTNode r = libsbml.parseL3Formula("1 && 2 == 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_LOGICAL_AND );
      assertTrue((  "and" == r.getName() ));
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_RELATIONAL_EQ );
      assertTrue((  "eq" == c.getName() ));
      assertTrue( c.getNumChildren() == 2 );
      c = c.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_logic2()
    {
      ASTNode r = libsbml.parseL3Formula("(1 && 2) == 3");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_RELATIONAL_EQ );
      assertTrue((  "eq" == r.getName() ));
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_LOGICAL_AND );
      assertTrue((  "and" == c.getName() ));
      assertTrue( c.getNumChildren() == 2 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getLeftChild().getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent1()
    {
      Model model = new  Model(3,1);
      Parameter p = model.createParameter();
      p.setId( "infinity");;
      ASTNode r = libsbml.parseL3FormulaWithModel("infinity", model);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "infinity" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent2()
    {
      Model model = new  Model(3,1);
      Species p = model.createSpecies();
      p.setId( "true");;
      ASTNode r = libsbml.parseL3FormulaWithModel("true", model);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "true" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent3()
    {
      Model model = new  Model(3,1);
      Compartment p = model.createCompartment();
      p.setId( "NaN");;
      ASTNode r = libsbml.parseL3FormulaWithModel("NaN", model);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "NaN" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent4()
    {
      Model model = new  Model(3,1);
      Reaction p = model.createReaction();
      p.setId( "pi");;
      ASTNode r = libsbml.parseL3FormulaWithModel("pi", model);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "pi" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent5()
    {
      Model model = new  Model(3,1);
      Reaction p = model.createReaction();
      SpeciesReference sr = p.createProduct();
      sr.setId( "avogadro");;
      ASTNode r = libsbml.parseL3FormulaWithModel("avogadro", model);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "avogadro" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent6()
    {
      Model model = new  Model(3,1);
      Reaction p = model.createReaction();
      SpeciesReference sr = p.createProduct();
      sr.setId( "AVOGADRO");;
      ASTNode r = libsbml.parseL3FormulaWithModel("avogadro", model);
      assertTrue( r.getType() == libsbml.AST_NAME_AVOGADRO );
      assertTrue((  "avogadro" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modelPresent7()
    {
      Model model = new  Model(3,1);
      FunctionDefinition p = model.createFunctionDefinition();
      p.setId( "sin");;
      ASTNode r = libsbml.parseL3FormulaWithModel("sin(x, y)", model);
      assertTrue( r.getType() == libsbml.AST_FUNCTION );
      assertTrue((  "sin" == r.getName() ));
      assertTrue( r.getNumChildren() == 2 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_modulo()
    {
      ASTNode r = libsbml.parseL3Formula("x % y");
      assertTrue((  "piecewise(x - y * ceil(x / y), xor(lt(x, 0), lt(y, 0)), x - y * floor(x / y))" == libsbml.formulaToString(r) ));
      r = null;
    }

    public void test_SBML_C_parseL3Formula_negInf()
    {
      ASTNode r = libsbml.parseL3Formula("-inf");
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getCharacter() == '-' );
      assertTrue( r.getNumChildren() == 1 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_negZero()
    {
      ASTNode r = libsbml.parseL3Formula("-0.0");
      assertTrue( r.getType() == libsbml.AST_MINUS );
      assertTrue( r.getCharacter() == '-' );
      assertTrue( r.getNumChildren() == 1 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 0 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_oddMathML1()
    {
      ASTNode r = libsbml.parseL3Formula("sqrt(3)");
      assertTrue( r.getType() == libsbml.AST_FUNCTION_ROOT );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_oddMathML2()
    {
      ASTNode r = libsbml.parseL3Formula("sqr(3)");
      assertTrue( r.getType() == libsbml.AST_FUNCTION_POWER );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 2 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_oddMathML3()
    {
      ASTNode r = libsbml.parseL3Formula("log10(3)");
      assertTrue( r.getType() == libsbml.AST_FUNCTION_LOG );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 10 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_oddMathML4()
    {
      ASTNode r = libsbml.parseL3Formula("log(4.4, 3)");
      assertTrue( r.getType() == libsbml.AST_FUNCTION_LOG );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_oddMathML5()
    {
      ASTNode r = libsbml.parseL3Formula("root(1.1, 3)");
      assertTrue( r.getType() == libsbml.AST_FUNCTION_ROOT );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 1.1 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_parselogsettings()
    {
      ASTNode r = libsbml.parseL3Formula("log(4.4)");
      ASTNode c;
      assertTrue( r.getType() == libsbml.AST_FUNCTION_LOG );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 10 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = new  L3ParserSettings();
      settings.setParseLog(libsbml.L3P_PARSE_LOG_AS_LN);
      assertTrue( settings.getParseLog() == libsbml.L3P_PARSE_LOG_AS_LN );
      r = libsbml.parseL3FormulaWithSettings("log(4.4)", settings);
      assertTrue( r.getType() == libsbml.AST_FUNCTION_LN );
      assertTrue( r.getNumChildren() == 1 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings.setParseLog(libsbml.L3P_PARSE_LOG_AS_LOG10);
      assertTrue( settings.getParseLog() == libsbml.L3P_PARSE_LOG_AS_LOG10 );
      r = libsbml.parseL3FormulaWithSettings("log(4.4)", settings);
      assertTrue( r.getType() == libsbml.AST_FUNCTION_LOG );
      assertTrue( r.getNumChildren() == 2 );
      c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 10 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
      settings.setParseLog(libsbml.L3P_PARSE_LOG_AS_ERROR);
      assertTrue( settings.getParseLog() == libsbml.L3P_PARSE_LOG_AS_ERROR );
      r = libsbml.parseL3FormulaWithSettings("log(4.4)", settings);
      assertTrue( r == null );
      assertTrue((  "Error when parsing input 'log(4.4)' at position 8:  Writing a function as 'log(x)' was legal in the L1 parser, but translated as the natural log, not the base-10 log.  This construct is disallowed entirely as being ambiguous, and you are encouraged instead to use 'ln(x)', 'log10(x)', or 'log(base, x)'." == libsbml.getLastParseL3Error() ));
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_precedence()
    {
      ASTNode root = libsbml.parseL3Formula("a && b == !c - d * e^-f ");
      ASTNode left;
      ASTNode right;
      assertTrue( root.getType() == libsbml.AST_LOGICAL_AND );
      assertTrue((  "and" == root.getName() ));
      assertTrue( root.getNumChildren() == 2 );
      left = root.getLeftChild();
      assertTrue( left.getType() == libsbml.AST_NAME );
      assertTrue((  "a" == left.getName() ));
      assertTrue( left.getNumChildren() == 0 );
      right = root.getRightChild();
      assertTrue( right.getType() == libsbml.AST_RELATIONAL_EQ );
      assertTrue((  "eq" == right.getName() ));
      assertTrue( right.getNumChildren() == 2 );
      left = right.getLeftChild();
      assertTrue( left.getType() == libsbml.AST_NAME );
      assertTrue((  "b" == left.getName() ));
      assertTrue( left.getNumChildren() == 0 );
      right = right.getRightChild();
      assertTrue( right.getType() == libsbml.AST_LOGICAL_NOT );
      assertTrue((  "not" == right.getName() ));
      assertTrue( right.getNumChildren() == 1 );
      right = right.getLeftChild();
      assertTrue( right.getType() == libsbml.AST_MINUS );
      assertTrue( right.getCharacter() == '-' );
      assertTrue( right.getNumChildren() == 2 );
      left = right.getLeftChild();
      assertTrue( left.getType() == libsbml.AST_NAME );
      assertTrue((  "c" == left.getName() ));
      assertTrue( left.getNumChildren() == 0 );
      right = right.getRightChild();
      assertTrue( right.getType() == libsbml.AST_TIMES );
      assertTrue( right.getCharacter() == '*' );
      assertTrue( right.getNumChildren() == 2 );
      left = right.getLeftChild();
      assertTrue( left.getType() == libsbml.AST_NAME );
      assertTrue((  "d" == left.getName() ));
      assertTrue( left.getNumChildren() == 0 );
      right = right.getRightChild();
      assertTrue( right.getType() == libsbml.AST_POWER );
      assertTrue( right.getCharacter() == '^' );
      assertTrue( right.getNumChildren() == 2 );
      left = right.getLeftChild();
      assertTrue( left.getType() == libsbml.AST_NAME );
      assertTrue((  "e" == left.getName() ));
      assertTrue( left.getNumChildren() == 0 );
      right = right.getRightChild();
      assertTrue( right.getType() == libsbml.AST_MINUS );
      assertTrue( right.getCharacter() == '-' );
      assertTrue( right.getNumChildren() == 1 );
      left = right.getLeftChild();
      assertTrue( left.getType() == libsbml.AST_NAME );
      assertTrue((  "f" == left.getName() ));
      assertTrue( left.getNumChildren() == 0 );
      root = null;
    }

    public void test_SBML_C_parseL3Formula_rational1()
    {
      ASTNode r = libsbml.parseL3Formula("(3/4)");
      assertTrue( r.getType() == libsbml.AST_RATIONAL );
      assertTrue( r.getNumerator() == 3 );
      assertTrue( r.getDenominator() == 4 );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_rational2()
    {
      ASTNode r = libsbml.parseL3Formula("(3/4) mL");
      assertTrue( r.getType() == libsbml.AST_RATIONAL );
      assertTrue( r.getNumerator() == 3 );
      assertTrue( r.getDenominator() == 4 );
      assertTrue((  "mL" == r.getUnits() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_rational3()
    {
      ASTNode r = libsbml.parseL3Formula("3/4");
      assertTrue( r.getType() == libsbml.AST_DIVIDE );
      assertTrue( r.getCharacter() == '/' );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_rational4()
    {
      ASTNode r = libsbml.parseL3Formula("(3/x)");
      assertTrue( r.getType() == libsbml.AST_DIVIDE );
      assertTrue( r.getCharacter() == '/' );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_NAME );
      assertTrue((  "x" == c.getName() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_rational5()
    {
      ASTNode r = libsbml.parseL3Formula("(3/4.4)");
      assertTrue( r.getType() == libsbml.AST_DIVIDE );
      assertTrue( r.getCharacter() == '/' );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_REAL );
      assertTrue( c.getReal() == 4.4 );
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_rational6()
    {
      ASTNode r = libsbml.parseL3Formula("3/4 ml");
      assertTrue( r.getType() == libsbml.AST_DIVIDE );
      assertTrue( r.getCharacter() == '/' );
      assertTrue( r.getNumChildren() == 2 );
      ASTNode c = r.getLeftChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 3 );
      assertTrue( c.getNumChildren() == 0 );
      c = r.getRightChild();
      assertTrue( c.getType() == libsbml.AST_INTEGER );
      assertTrue( c.getInteger() == 4 );
      assertTrue((  "ml" == c.getUnits() ));
      assertTrue( c.getNumChildren() == 0 );
      r = null;
    }

    public void test_SBML_C_parseL3Formula_rational7()
    {
      ASTNode r = libsbml.parseL3Formula("(3/4.4) ml");
      assertTrue( r == null );
      assertTrue((  "Error when parsing input '(3/4.4) ml' at position 10:  syntax error, unexpected element name" == libsbml.getLastParseL3Error() ));
    }

    public void test_SBML_C_parseL3Formula_targetl2settings()
    {
      ASTNode r = libsbml.parseL3Formula("4 mL");
      assertTrue( r.getType() == libsbml.AST_INTEGER );
      assertTrue( r.getInteger() == 4 );
      assertTrue((  "mL" == r.getUnits() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3Formula("avogadro");
      assertTrue( r.getType() == libsbml.AST_NAME_AVOGADRO );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseUnits(false);
      settings.setParseAvogadroCsymbol(false);
      assertTrue(settings.getParseUnits() == false);
      assertTrue(settings.getParseAvogadroCsymbol() == false);
      r = libsbml.parseL3FormulaWithSettings("4 mL", settings);
      assertTrue( r == null );
      assertTrue(("Error when parsing input '4 mL' at position 4:  The ability to associate units with numbers has been disabled." == libsbml.getLastParseL3Error()));
      r = libsbml.parseL3FormulaWithSettings("avogadro", settings);
      assertTrue( r.getType() == libsbml.AST_NAME );
      assertTrue((  "avogadro" == r.getName() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings.setParseUnits(true);
      settings.setParseAvogadroCsymbol(true);
      assertTrue(settings.getParseUnits() == true);
      assertTrue(settings.getParseAvogadroCsymbol() == true);
      r = libsbml.parseL3FormulaWithSettings("4 mL", settings);
      assertTrue( r.getType() == libsbml.AST_INTEGER );
      assertTrue( r.getInteger() == 4 );
      assertTrue((  "mL" == r.getUnits() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      r = libsbml.parseL3FormulaWithSettings("avogadro", settings);
      assertTrue( r.getType() == libsbml.AST_NAME_AVOGADRO );
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

    public void test_SBML_C_parseL3Formula_unitssettings()
    {
      ASTNode r = libsbml.parseL3Formula("4 mL");
      assertTrue( r.getType() == libsbml.AST_INTEGER );
      assertTrue( r.getInteger() == 4 );
      assertTrue((  "mL" == r.getUnits() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      L3ParserSettings settings = libsbml.getDefaultL3ParserSettings();
      settings.setParseUnits(false);
      assertTrue( settings.getParseUnits() == false );
      r = libsbml.parseL3FormulaWithSettings("4 mL", settings);
      assertTrue( r == null );
      assertTrue(("Error when parsing input '4 mL' at position 4:  The ability to associate units with numbers has been disabled." == libsbml.getLastParseL3Error()));
      settings.setParseUnits(true);
      assertTrue( settings.getParseUnits() == true );
      r = libsbml.parseL3FormulaWithSettings("4 mL", settings);
      assertTrue( r.getType() == libsbml.AST_INTEGER );
      assertTrue( r.getInteger() == 4 );
      assertTrue((  "mL" == r.getUnits() ));
      assertTrue( r.getNumChildren() == 0 );
      r = null;
      settings = null;
    }

  }
}
