
INCLUDE(UsePkgConfig)
PKGCONFIG(OpenRijn _OpenRijnIncDir _OpenRijnLinkDir _OpenRijnLinkFlags _OpenRijnCflags)

set(OPENRIJN_DEFINITIONS ${_OpenRijnCflags})
set(OPENRIJN_LIBRARIES ${_OpenRijnLinkFlags})
set(OPENRIJN_INCLUDE_DIR ${_OpenRijnIncDir})

if(OPENRIJN_DEFINITIONS AND OPENRIJN_LIBRARIES)

  FIND_PROGRAM(PKGCONFIG_EXECUTABLE NAMES pkg-config PATHS /usr/bin/ /usr/local/bin )

  # query pkg-config asking for OpenRijn >= 0.9.7
  EXEC_PROGRAM(${PKGCONFIG_EXECUTABLE} ARGS --atleast-version=0.9.7 OpenRijn RETURN_VALUE _return_VALUE OUTPUT_VARIABLE _pkgconfigDevNull )

  if(_return_VALUE STREQUAL "0")
    set(OPENRIJN_FOUND TRUE)
    set(HAVE_OPENRIJN TRUE)
  else(_return_VALUE STREQUAL "0")
    message(STATUS "OpenRijn >= 0.9.3 was found")
  endif(_return_VALUE STREQUAL "0")
endif(OPENRIJN_DEFINITIONS AND OPENRIJN_LIBRARIES)

if (OPENRIJN_FOUND)
    if (NOT OPENRIJN_FIND_QUIETLY)
        message(STATUS "Found OpenRijn: ${OPENRIJN_LIBRARIES}")
    endif (NOT OPENRIJN_FIND_QUIETLY)
else (OPENRijn_FOUND)
    if (NOT OPENRIJN_FIND_QUIETLY)
        message(STATUS "OpenRijn was NOT found.")
    endif (NOT OPENRIJN_FIND_QUIETLY)
    if (OPENRIJN_FIND_REQUIRED)
        message(FATAL_ERROR "Could NOT find OpenRijn")
    endif (OPENRIJN_FIND_REQUIRED)
endif (OPENRIJN_FOUND)
