/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _QTRIJN_BRUSH_H_
#define _QTRIJN_BRUSH_H_

#include <OpenRijn/AbstractBrush.h>

class QPen;

namespace QtRijn
{
  class Brush : public OpenRijn::AbstractBrush
  {
    public:
      Brush(const QPen& pen);
      virtual ~Brush();
      virtual float drawPoint( OpenRijn::AbstractCanvas*, const OpenRijn::DrawingPoint&);
      virtual OpenRijn::DistanceInformation drawLine( OpenRijn::AbstractCanvas* canvas, const OpenRijn::DrawingPoint& pt1, const OpenRijn::DrawingPoint& pt2, const OpenRijn::DistanceInformation& information);
      virtual OpenRijn::DistanceInformation drawCurve(  OpenRijn::AbstractCanvas* canvas, const OpenRijn::DrawingPoint& pt1, float x1, float y1, float x2, float y2, const OpenRijn::DrawingPoint& pt2, const OpenRijn::DistanceInformation& information);
    private:
      struct Private;
      Private* const d;
  };
}

#endif
