#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <pcapnav.h>

int 
main(int argc, char** argv)
{
  struct bpf_timeval start, end, delta;
  pcapnav_t *pn;
  
  pcapnav_init();
  
  if ((pn = pcapnav_open_offline(argv[1])) == NULL)
    {
      printf("Could not open source trace file %s\n", argv[1]);
      exit(-1);
    }
  
  pcapnav_get_timespan(pn, &start, &end);
  pcapnav_timeval_sub(&end, &start, &delta);

  printf("%u.%u - %u.%u: %u.%u\n",
	 start.tv_sec, start.tv_usec,
	 end.tv_sec, end.tv_usec,
	 delta.tv_sec, delta.tv_usec);
	 
  pcapnav_close(pn);

  return 0;
}
