/* nonBlockDelete.t.cc
 */
#include "osl/misc/nonBlockDelete.h"
#include "osl/misc/atomicCounter.h"
#include <boost/thread/thread.hpp>
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

namespace osl
{

  class NonBlockDeleteTest : public CppUnit::TestFixture 
  {
    CPPUNIT_TEST_SUITE(NonBlockDeleteTest);
    CPPUNIT_TEST(testReset);
    CPPUNIT_TEST(testCount);
    CPPUNIT_TEST(testClearAll);
    CPPUNIT_TEST_SUITE_END();
  public:
    void testReset();
    void testCount();
    void testClearAll();
  };
} // namespace osl

namespace 
{
  struct X
  {
    static osl::AtomicCounter counter;
    X() { counter.inc(); }
    X(const X&) { counter.inc(); }
    ~X() { counter.dec(); }
  };
  struct Y
  {
    static osl::AtomicCounter counter;
    Y() { counter.inc(); }
    Y(const Y&) { counter.inc(); }
    ~Y() { counter.dec(); }
  };
  osl::AtomicCounter X::counter;
  osl::AtomicCounter Y::counter;
}

CPPUNIT_TEST_SUITE_REGISTRATION(osl::NonBlockDeleteTest);

void osl::NonBlockDeleteTest::
testReset()
{ 
  boost::shared_ptr<X> x(new X());
  NonBlockDelete::reset(x);
  CPPUNIT_ASSERT(x.get() == 0);
}

void osl::NonBlockDeleteTest::
testCount() { 
  NonBlockDelete::planDelete(new X());
  {
    boost::shared_ptr<X> x(new X());
    NonBlockDelete::reset(x);
  }
  NonBlockDelete::planDelete(new Y());
  sleep(1);
  CPPUNIT_ASSERT_EQUAL(0, X::counter.value()); 
  CPPUNIT_ASSERT_EQUAL(0, Y::counter.value()); 
}

void osl::NonBlockDeleteTest::
testClearAll() { 
  for (int i=0; i<100; ++i)
  {
    NonBlockDelete::planDelete(new X());
    NonBlockDelete::planDelete(new Y());
  }
  NonBlockDelete::deleteAll();
  CPPUNIT_ASSERT_EQUAL(0, NonBlockDelete::waiting());
  boost::thread::yield();
  sleep(1);
  CPPUNIT_ASSERT_EQUAL(0, X::counter.value()); 
  CPPUNIT_ASSERT_EQUAL(0, Y::counter.value()); 
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
