/*
 * xmlformat - registration of xml object formats 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef XMLFORMAT_CALENDAR_H
#define XMLFORMAT_CALENDAR_H

#include "xmlformat-common.h"

#define XMLFORMAT_CALENDAR_ROOT				"note"
#define XMLFORMAT_CALENDAR_VERSION			"version"

// Alarm
#define XMLFORMAT_CALENDAR_ALARM			"Alarm"
#define XMLFORMAT_CALENDAR_ALARM_ACTION			"AlarmAction"
#define XMLFORMAT_CALENDAR_ALARM_ACTION_AUDIO		"AUDIO"	
#define XMLFORMAT_CALENDAR_ALARM_ACTION_DISPLAY		"DISPLAY"	
#define XMLFORMAT_CALENDAR_ALARM_ACTION_EMAIL		"EMAIL"	
#define XMLFORMAT_CALENDAR_ALARM_ACTION_PROCEDURE	"PROCEDURE"	
#define XMLFORMAT_CALENDAR_ALARM_ATTACH			"AlarmAttach"
#define XMLFORMAT_CALENDAR_ALARM_ATTENDEE		"AlarmAttendee"
#define XMLFORMAT_CALENDAR_ALARM_DESCRIPTION		"AlarmDescription"
#define XMLFORMAT_CALENDAR_ALARM_REPEAT			"AlarmRepeat"
#define XMLFORMAT_CALENDAR_ALARM_REPEATDURATION		"AlarmRepeatDuration"
#define XMLFORMAT_CALENDAR_ALARM_SUMMARY		"AlarmSummary"
#define XMLFORMAT_CALENDAR_ALARM_TRIGGER		"AlarmTrigger"
#define XMLFORMAT_CALENDAR_ALARM_VALUE			"Value"
#define XMLFORMAT_CALENDAR_ALARM_RELATEDTYPE		"RelatedType"
#define XMLFORMAT_CALENDAR_ALARM_ALTERNATIVETEXTREP	"AlternativeTextRep"
#define XMLFORMAT_CALENDAR_ALARM_LANGUAGE		"Language"
#define XMLFORMAT_CALENDAR_ALARM_ATTACHVALUE		"AttachValue"
#define XMLFORMAT_CALENDAR_ALARM_FORMATTYPE		"FormatType"
#define XMLFORMAT_CALENDAR_ALARM_ENCODING		"Encoding"

// Attachment
#define XMLFORMAT_CALENDAR_ATTACHMENT			"Attachment"
#define XMLFORMAT_CALENDAR_ATTACHMENT_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_ATTACHMENT_VALUE		"Value"
#define XMLFORMAT_CALENDAR_ATTACHMENT_FORMATTYPE	"FormatType"
#define XMLFORMAT_CALENDAR_ATTACHMENT_ENCODING		"Encoding"

// AttachmentType
#define XMLFORMAT_CALENDAR_ATTACHMENTTYPE		"AttachmentType"
#define XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI		"URI"
#define XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY	"BINARY"

// Attendee
#define XMLFORMAT_CALENDAR_ATTENDEE			"Attendee"
#define XMLFORMAT_CALENDAR_ATTENDEE_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_ATTENDEE_CUTYPE		"CUType"
#define XMLFORMAT_CALENDAR_ATTENDEE_MEMBER		"Member"
#define XMLFORMAT_CALENDAR_ATTENDEE_ROLE		"Role"
#define XMLFORMAT_CALENDAR_ATTENDEE_PARTSTAT		"PartStat"
#define XMLFORMAT_CALENDAR_ATTENDEE_RSVP		"Rsvp"
#define XMLFORMAT_CALENDAR_ATTENDEE_DELEGATEDFROM	"DelegatedFrom"
#define XMLFORMAT_CALENDAR_ATTENDEE_SENTBY		"SentBy"
#define XMLFORMAT_CALENDAR_ATTENDEE_COMMONNAME		"CommonName"
#define XMLFORMAT_CALENDAR_ATTENDEE_DIRECTORY		"Directory"
#define XMLFORMAT_CALENDAR_ATTENDEE_LANGUAGE		"Language"

// BasicRecurrenceFreq
#define XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ		"BasicRecurrenceFreq"
#define XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_DAILY	"DAILY"
#define XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_WEEKLY	"WEEKLY"
#define XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_MONTHLY	"MONTHLY"
#define XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_YEARLY	"YEARLY"

// CalendarUserType
#define XMLFORMAT_CALENDAR_CALENDARUSERTYPE		"CalendarUserType"
#define XMLFORMAT_CALENDAR_CALENDARUSERTYPE_INDIVIDUAL	"INDIVIDUAL"
#define XMLFORMAT_CALENDAR_CALENDARUSERTYPE_GROUP	"GROUP"
#define XMLFORMAT_CALENDAR_CALENDARUSERTYPE_RESOURCE	"RESOURCE"
#define XMLFORMAT_CALENDAR_CALENDARUSERTYPE_ROOM	"ROOM"
#define XMLFORMAT_CALENDAR_CALENDARUSERTYPE_UNKNOWN	"UNKNOWN"

// Duration
#define XMLFORMAT_CALENDAR_DURATION			"Duration"
#define XMLFORMAT_CALENDAR_DURATION_INADVANCE		"InAdvance"
#define XMLFORMAT_CALENDAR_DURATION_WEEKS		"Weeks"
#define XMLFORMAT_CALENDAR_DURATION_DAYS		"Days"
#define XMLFORMAT_CALENDAR_DURATION_HOURS		"Hours"
#define XMLFORMAT_CALENDAR_DURATION_MINUTES		"Minutes"
#define XMLFORMAT_CALENDAR_DURATION_SECONDS		"Seconds"

// FreeBusy
#define XMLFORMAT_CALENDAR_FREEBUSY			"FreeBusy"
#define XMLFORMAT_CALENDAR_FREEBUSY_ATTENDEE		"Attendee"
#define XMLFORMAT_CALENDAR_FREEBUSY_CONTACT		"Contact"
#define XMLFORMAT_CALENDAR_FREEBUSY_COMMENT		"Comment"
#define XMLFORMAT_CALENDAR_FREEBUSY_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_FREEBUSY_DATEEND		"DateEnd"
#define XMLFORMAT_CALENDAR_FREEBUSY_DATESTAMP		"DateStamp"
#define XMLFORMAT_CALENDAR_FREEBUSY_DATESTARTED		"DateStarted"
#define XMLFORMAT_CALENDAR_FREEBUSY_DURATION		"Duration"
#define XMLFORMAT_CALENDAR_FREEBUSY_ORGANIZER		"Organizer"
#define XMLFORMAT_CALENDAR_FREEBUSY_RSTATUS		"RStatus"
#define XMLFORMAT_CALENDAR_FREEBUSY_UID			"Uid"
#define XMLFORMAT_CALENDAR_FREEBUSY_URL			"Url"

// FreeBusyElement
#define XMLFORMAT_CALENDAR_FREEBUSYELEMENT		"FreeBusyElement"
#define XMLFORMAT_CALENDAR_FREEBUSYELEMENT_TYPE		"Type"
#define XMLFORMAT_CALENDAR_FREEBUSYELEMENT_PERIOD	"Period"

// IntegerContent
#define XMLFORMAT_CALENDAR_INTEGERCONTENT		"IntegerContent"
#define XMLFORMAT_CALENDAR_INTEGERCONTENT_CONTENT	"Content"

// Organizer
#define XMLFORMAT_CALENDAR_ORGANIZER			"Organizer"
#define XMLFORMAT_CALENDAR_ORGANIZER_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_ORGANIZER_COMMONNAME		"CommonName"
#define XMLFORMAT_CALENDAR_ORGANIZER_DIRECTORY		"Directory"
#define XMLFORMAT_CALENDAR_ORGANIZER_SENTBY		"SentBy"
#define XMLFORMAT_CALENDAR_ORGANIZER_LANGUAGE		"Language"

// Period
#define XMLFORMAT_CALENDAR_PERIOD			"Period"
#define XMLFORMAT_CALENDAR_PERIOD_START			"Start"
#define XMLFORMAT_CALENDAR_PERIOD_DURATION		"Duration"
#define XMLFORMAT_CALENDAR_PERIOD_END			"End"

// Priority
#define XMLFORMAT_CALENDAR_PRIORITY			"Priority"
#define XMLFORMAT_CALENDAR_PRIORITY_CONTENT		"Content"			// Element
#define XMLFORMAT_CALENDAR_PRIORITY_CONTENT_MAX		"9"				// Max value of Element
#define XMLFORMAT_CALENDAR_PRIORITY_CONTENT_MIN		"0"				// Min value of Element

// RecurrenceDateTimeList
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST	"RecurrenceDateTimeList"
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_CONTENT	"Content"		// Element
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_TIMEZONEID	"TimezoneID"		// Attribute
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE	"Value"				// Attribute type RecurrenceDateTimeValue
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_DATETIME	"DATE-TIME"	// Value of Attribute
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_DATE	"DATE"			// Value of Attribute
#define XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_PERIOD	"PERIOD"		// Value of Attribute

// RecurrenceId
#define XMLFORMAT_CALENDAR_RECURRENCEID			"RecurrenceId"
#define XMLFORMAT_CALENDAR_RECURRENCEID_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_RECURRENCEID_TIMEZONEID	"TimezoneID"
#define XMLFORMAT_CALENDAR_RECURRENCEID_RANGE		"Range"
#define XMLFORMAT_CALENDAR_RECURRENCEID_RANGE_THISANDPRIOR	"THISANDPRIOR"
#define XMLFORMAT_CALENDAR_RECURRENCEID_RANGE_THISANDFUTURE	"THISANDFUTURE"
#define XMLFORMAT_CALENDAR_RECURRENCEID_VALUE		"Value"

// RecurrenceRule
#define XMLFORMAT_CALENDAR_RECURRENCERULE		"RecurrenceRule"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_FREQUENCY	"Frequency"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_UNTIL		"Until"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_COUNT		"Count"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_INTERVAL	"Interval"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_BYDAY		"ByDay"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTHDAY	"ByMonthDay"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_BYYEARDAY	"ByYearDay"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTH	"ByMonth"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_TIMEZONEID	"TimezoneID"
#define XMLFORMAT_CALENDAR_RECURRENCERULE_TZCOMPONENT	"TZComponent"

// RecurrenceRuleExtended
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED	"RecurrenceRuleExtended"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_FREQUENCY	"Frequency"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_UNTIL		"Until"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_COUNT		"Count"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_INTERVAL	"Interval"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYSECOND	"BySecond"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMINUTE	"ByMinute"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYHOUR	"ByHour"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYDAY		"ByDay"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMONTHDAY	"ByMonthDay"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYYEARDAY	"ByYearDay"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYWEEKNO	"ByWeekNo"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMONTH	"ByMonth"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYSETPOS	"BySetPos"
#define XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_WKST		"WKST"

// RelatedType
#define XMLFORMAT_CALENDAR_RELATEDTYPE			"RelatedType"
#define XMLFORMAT_CALENDAR_RELATEDTYPE_START		"START"
#define XMLFORMAT_CALENDAR_RELATEDTYPE_END		"END"

// RelatedTo
#define XMLFORMAT_CALENDAR_RELATEDTO			"RelatedTo"
#define XMLFORMAT_CALENDAR_RELATEDTO_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_RELATEDTO_TIMEZONEID		"TimezoneID"
#define XMLFORMAT_CALENDAR_RELATEDTO_RELATIONSHIPTYPE	"RelationshipType"

// RelationshipType
#define XMLFORMAT_CALENDAR_RELATIONSHIPTYPE		"RelationshipType"
#define XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT	"PARENT"
#define XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD	"CHILD"
#define XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING	"SIBLING"

// RequestStatus
#define XMLFORMAT_CALENDAR_REQUESTSTATUS		"RequestStatus"
#define XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSCODE	"StatusCode"
#define XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSDESCRIPTION	"StatusDescription"
#define XMLFORMAT_CALENDAR_REQUESTSTATUS_EXCEPTIONDATA	"ExceptionData"
#define XMLFORMAT_CALENDAR_REQUESTSTATUS_TIMEZONEID	"TimezoneID"
#define XMLFORMAT_CALENDAR_REQUESTSTATUS_RELATIONSHIPTYPE	"RelationshipType"

// RoleType
#define XMLFORMAT_CALENDAR_ROLETYPE			"RoleType"
#define XMLFORMAT_CALENDAR_ROLETYPE_NEEDSACTION		"NEEDS-ACTION"
#define XMLFORMAT_CALENDAR_ROLETYPE_ACCEPTED		"ACCEPTED"
#define XMLFORMAT_CALENDAR_ROLETYPE_DECLINED		"DECLINED"
#define XMLFORMAT_CALENDAR_ROLETYPE_TENTATIVE		"TENTATIVE"
#define XMLFORMAT_CALENDAR_ROLETYPE_DELEGATED		"DELEGATED"

// Status
#define XMLFORMAT_CALENDAR_STATUS			"Status"
#define XMLFORMAT_CALENDAR_STATUS_CONTENT		"Content"
#define XMLFORMAT_CALENDAR_STATUS_CONTENT_TENTATIVE	"TENTATIVE"
#define XMLFORMAT_CALENDAR_STATUS_CONTENT_CONFIRMED	"CONFIRMED"
#define XMLFORMAT_CALENDAR_STATUS_CONTENT_CANCELLED	"CANCELLED"

// TimeTransparency
#define XMLFORMAT_CALENDAR_TIMETRANSPARENCY		"TimeTransparency"
#define XMLFORMAT_CALENDAR_TIMETRANSPARENCY_CONTENT	"Content"
#define XMLFORMAT_CALENDAR_TIMETRANSPARENCY_CONTENT_OPAQUE	"OPAQUE"
#define XMLFORMAT_CALENDAR_TIMETRANSPARENCY_CONTENT_TRANSPARENT	"TRANSPARENT"

// Timezone
#define XMLFORMAT_CALENDAR_TIMEZONE			"Timezone"
#define XMLFORMAT_CALENDAR_TIMEZONE_LASTMODIFIED	"LastModified"			// Type DateTimeContent
#define XMLFORMAT_CALENDAR_TIMEZONE_TZURL		"TZUrl"				// Element
#define XMLFORMAT_CALENDAR_TIMEZONE_XLOCATION		"X-Location"			// Element
#define XMLFORMAT_CALENDAR_TIMEZONE_TIMEZONEID		"TimezoneID"			// Attribute
#define XMLFORMAT_CALENDAR_TIMEZONE_TZCOMPONENT		"TZComponent"			// Attribute

// TimezoneComponent
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT		"TimezoneComponent"
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_COMMENT	"Comment"			// Type MultiText
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_RECURRENCEDATETIME	"RecurrenceDateTime"	// Type RecurrenceDateTimeList
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_DATETIMESTART	"DateTimeStart"		// Element
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZNAME	"TZName"			// Element
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZOFFSETFROM	"TZOffsetFrom"		// Type UtcOffset
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZOFFSETTO	"TZOffsetTo"			// Type UtcOffset
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TIMEZONEID	"TimezoneID"			// Attribute
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZCOMPONENT	"TZComponent"		// Attribute
#define XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_LANGUAGE	"Language"			// Attribute

// TriggerType
#define XMLFORMAT_CALENDAR_TRIGGERTYPE			"TriggerType"
#define XMLFORMAT_CALENDAR_TRIGGERTYPE_DATETIME		"DATE-TIME"
#define XMLFORMAT_CALENDAR_TRIGGERTYPE_DURATION		"DURATION"

// UrlContent
#define XMLFORMAT_CALENDAR_URLCONTENT			"UrlContent"
#define XMLFORMAT_CALENDAR_URLCONTENT_CONTENT		"Content"

// Weekday
#define XMLFORMAT_CALENDAR_WEEKDAY			"Weekday"
#define XMLFORMAT_CALENDAR_WEEKDAY_SUNDAY		"SU"
#define XMLFORMAT_CALENDAR_WEEKDAY_MONDAY		"MO"
#define XMLFORMAT_CALENDAR_WEEKDAY_TUESDAY		"TU"
#define XMLFORMAT_CALENDAR_WEEKDAY_WEDNESDAY		"WE"
#define XMLFORMAT_CALENDAR_WEEKDAY_THURSDAY		"TH"
#define XMLFORMAT_CALENDAR_WEEKDAY_FRIDAY		"FR"
#define XMLFORMAT_CALENDAR_WEEKDAY_SATURDAY		"SA"

#endif /* XMLFORMAT_CALENDAR_H */
