// $Id: quadrature_simpson_1D.C 2501 2007-11-20 02:33:29Z benkirk $

// The libMesh Finite Element Library.
// Copyright (C) 2002-2007  Benjamin S. Kirk, John W. Peterson
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



// Local includes
#include "quadrature_simpson.h"
 


void QSimpson::init_1D(const ElemType,
                       unsigned int)
{
  //----------------------------------------------------------------------
  // 1D quadrature rules
  _points.resize(3);
  _weights.resize(3);

  _points[0](0) = -1.;
  _points[1](0) =  0.;
  _points[2](0) =  1.;
  
  _weights[0] = 0.333333333333333333333333333333;
  _weights[1] = 1.333333333333333333333333333333;
  _weights[2] = 0.333333333333333333333333333333;
  
  return;
}
